/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.jdbc.filter;

import com.ontotext.graphdb.jdbc.filter.GraphDBFilter;
import org.apache.calcite.runtime.GraphDBLike;
import org.apache.calcite.sql.SqlKind;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.rio.helpers.NTriplesUtil;

public class GraphDBFilterElement
implements GraphDBFilter {
    final String column;
    final Object sqlValue;
    final SqlKind sqlKind;
    private final String sqlType;
    private final Value rdfValue;
    private final IRI sparqlType;
    private final Object modifierValue;

    public GraphDBFilterElement(String column, Object sqlValue, SqlKind sqlKind, String sqlType, Value rdfValue, IRI sparqlType, Object modifierValue) {
        this.column = column;
        this.sqlValue = sqlValue;
        this.sqlKind = sqlKind;
        this.sqlType = sqlType;
        this.rdfValue = rdfValue;
        this.sparqlType = sparqlType;
        this.modifierValue = modifierValue;
    }

    public GraphDBFilterElement(String column, SqlKind sqlKind) {
        this.column = column;
        this.sqlValue = null;
        this.sqlKind = sqlKind;
        this.sqlType = null;
        this.rdfValue = null;
        this.sparqlType = null;
        this.modifierValue = null;
    }

    @Override
    public String toSparqlFilterExpression() {
        if (this.sqlKind == SqlKind.IS_NOT_NULL) {
            return "BOUND(" + this.getFilterVariable() + ")";
        }
        if (this.sqlKind == SqlKind.IS_NULL) {
            return "!BOUND(" + this.getFilterVariable() + ")";
        }
        if (this.sqlKind == SqlKind.LIKE) {
            return "REGEX(" + this.getFilterVariable() + ", " + this.getFilterValue() + ")";
        }
        if (this.sqlKind == SqlKind.SIMILAR) {
            return "REGEX(" + this.getFilterVariable() + ", " + this.getFilterValue() + ")";
        }
        return this.getFilterVariable() + " " + this.getFilterOperation() + " " + this.getFilterValue();
    }

    private String getFilterOperation() {
        if (this.sqlKind == SqlKind.NOT_EQUALS) {
            return "!=";
        }
        return this.sqlKind.sql;
    }

    private String rdfValueToString(Value value) {
        if (this.sqlKind == SqlKind.LIKE) {
            value = SimpleValueFactory.getInstance().createLiteral(GraphDBLike.translateLike(value.stringValue(), (CharSequence)this.modifierValue));
        } else if (this.sqlKind == SqlKind.SIMILAR) {
            value = SimpleValueFactory.getInstance().createLiteral(GraphDBLike.translateSimilarTo(value.stringValue(), (CharSequence)this.modifierValue));
        }
        return NTriplesUtil.toNTriplesString((Value)value);
    }

    private String getFilterValue() {
        String value = this.rdfValueToString(this.rdfValue);
        if (XMLSchema.LANGUAGE.equals((Object)this.sparqlType) && (this.sqlKind == SqlKind.LESS_THAN || this.sqlKind == SqlKind.LESS_THAN_OR_EQUAL || this.sqlKind == SqlKind.GREATER_THAN || this.sqlKind == SqlKind.GREATER_THAN_OR_EQUAL)) {
            return "STR(" + value + ")";
        }
        return value;
    }

    private String getFilterVariable() {
        if (XMLSchema.LANGUAGE.equals((Object)this.sparqlType) && (this.sqlKind == SqlKind.LESS_THAN || this.sqlKind == SqlKind.LESS_THAN_OR_EQUAL || this.sqlKind == SqlKind.GREATER_THAN || this.sqlKind == SqlKind.GREATER_THAN_OR_EQUAL)) {
            return "STR(?" + this.column + ")";
        }
        return "?" + this.column;
    }

    public String toString() {
        return this.getFilterOperation();
    }
}

