/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.jdbc.filter;

import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlKind;

public interface GraphDBFilter {
    public String toSparqlFilterExpression();

    default public String toSparqlFilter() {
        return "FILTER(" + this.toSparqlFilterExpression() + ")";
    }

    public static boolean supportsPrimitive(SqlKind kind) {
        return kind == SqlKind.EQUALS || kind == SqlKind.NOT_EQUALS || kind == SqlKind.LESS_THAN || kind == SqlKind.LESS_THAN_OR_EQUAL || kind == SqlKind.GREATER_THAN || kind == SqlKind.GREATER_THAN_OR_EQUAL || kind == SqlKind.IS_NULL || kind == SqlKind.IS_NOT_NULL || kind == SqlKind.LIKE || kind == SqlKind.SIMILAR;
    }

    public static String convertToSparql(Collection<GraphDBFilter> filters) {
        return filters.stream().map(GraphDBFilter::toSparqlFilter).collect(Collectors.joining("\n"));
    }

    public static String toExplainString(Collection<GraphDBFilter> filters) {
        return filters.stream().map(GraphDBFilter::toSparqlFilterExpression).map(f -> "(" + f + ")").collect(Collectors.joining("; "));
    }
}

