/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.jdbc;

import com.google.common.collect.ImmutableList;
import com.ontotext.graphdb.jdbc.GraphDBWritableTable;
import com.ontotext.graphdb.jdbc.filter.GraphDBFilter;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;

class GraphDBTableScan
extends TableScan
implements EnumerableRel {
    private final GraphDBWritableTable graphdbTable;
    private final List<GraphDBFilter> filters;

    GraphDBTableScan(RelOptCluster cluster, RelOptTable table, GraphDBWritableTable graphdbTable, List<GraphDBFilter> filters) {
        super(cluster, cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE), (List)ImmutableList.of(), table);
        this.graphdbTable = graphdbTable;
        this.filters = filters;
        assert (graphdbTable != null);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return new GraphDBTableScan(this.getCluster(), this.table, this.graphdbTable, this.filters);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("filters", (Object)GraphDBFilter.toExplainString(this.filters));
    }

    public void register(RelOptPlanner planner) {
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)this.getRowType(), (JavaRowFormat)pref.preferArray(), (boolean)false);
        return implementor.result(physType, Blocks.toBlock((Node)this.table.getExpression(GraphDBWritableTable.class)));
    }
}

