/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.jdbc;

import com.google.common.io.CharSource;
import com.ontotext.graphdb.jdbc.GraphDBFieldType;
import com.ontotext.graphdb.jdbc.GraphDBJdbcUtils;
import com.ontotext.graphdb.jdbc.GraphDBSparqlQueryReader;
import com.ontotext.graphdb.jdbc.filter.GraphDBAndFilter;
import com.ontotext.graphdb.jdbc.filter.GraphDBFilter;
import com.ontotext.graphdb.jdbc.filter.GraphDBFilterElement;
import com.ontotext.graphdb.jdbc.filter.GraphDBNotFilter;
import com.ontotext.graphdb.jdbc.filter.GraphDBOrFilter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeFactory;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Source;
import org.apache.calcite.util.Sources;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.query.parser.QueryParserUtil;
import org.eclipse.rdf4j.repository.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphDBTableMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(GraphDBTableMetadata.class);
    private static final Pattern COLUMN_PATTERN = Pattern.compile("^ \\s* \\# \\s* !column \\s*:\\s* ([^:\\s]+) \\s*:\\s* ([^:\\d\\s,()]+) \\s*(?: \\( (\\d+) (?: \\s* , \\s* (\\d+) )? \\) \\s*)?(?i:(null|not\\s+null)\\s*)?(?: :\\s* ([^\\s]+) \\s*)?", 12);
    private static final Pattern FOREIGN_KEY_PATTERN = Pattern.compile("^ \\s* \\# \\s* !key \\s*:\\s* ([^:\\s]+) \\s*:\\s* ([^:\\s]+) \\s*(?: :\\s* ([^:\\s]+) \\s*)?", 12);
    private static final Pattern COMPLEXITY_PATTERN = Pattern.compile("^ \\s* \\# \\s* !complexity \\s*:\\s* ([^:\\s]+) \\s*", 12);
    final SimpleValueFactory vf = SimpleValueFactory.getInstance();
    final DatatypeFactory dtf;
    private final Repository repository;
    private final String query;
    private String sparqlQuery;
    private final Map<String, String> sqlTypes = new LinkedHashMap<String, String>();
    private final Set<String> sqlNotNull = new HashSet<String>();
    private final Map<String, Integer> sqlPrecision = new HashMap<String, Integer>();
    private final Map<String, Integer> sqlScale = new HashMap<String, Integer>();
    private final Map<String, IRI> sparqlTypes = new HashMap<String, IRI>();
    private final Map<String, String> languageTags = new HashMap<String, String>();
    private final Map<Integer, String> index2column = new HashMap<Integer, String>();
    private final Map<String, Integer> column2index = new HashMap<String, Integer>();
    private final Set<String> bindingNames;
    private Set<String> possibleBindingNames;
    private final Map<String, Pair<String, String>> foreignKeys = new HashMap<String, Pair<String, String>>();
    private final double complexity;

    public GraphDBTableMetadata(Repository repository, String query) throws Exception {
        this(repository, Sources.fromCharSource((CharSource)CharSource.wrap((CharSequence)query)));
    }

    public GraphDBTableMetadata(Repository repository, Source source) throws Exception {
        this.dtf = DatatypeFactory.newInstance();
        this.sparqlQuery = this.query = GraphDBJdbcUtils.getSqlViewFromFile(source);
        this.repository = repository;
        this.validateSparqlQuery();
        Matcher matcher = COLUMN_PATTERN.matcher(this.query);
        int i = 0;
        while (matcher.find()) {
            this.sparqlQuery = this.sparqlQuery.replace(matcher.group(), "");
            String column = matcher.group(1);
            this.validateColumnName(column);
            String sqlType = matcher.group(2);
            GraphDBFieldType fieldType = this.validateFieldType(sqlType.toLowerCase());
            IRI sparqlType = fieldType.getDefaultSparqlType();
            String precisionStr = matcher.group(3);
            String scaleStr = matcher.group(4);
            String nullability = matcher.group(5);
            String sparqlTypeString = matcher.group(6);
            if (sparqlTypeString != null) {
                if (sparqlTypeString.startsWith("@")) {
                    String languageTag = sparqlTypeString.substring(1);
                    if (languageTag.isEmpty()) {
                        throw new IllegalArgumentException("Language tag must not be empty, at column: " + column);
                    }
                    if (!fieldType.hasLanguageTag()) {
                        throw new IllegalArgumentException("Language tag can only be applied to a SQL type string for column: " + column);
                    }
                    sparqlType = XSD.LANGUAGE;
                    this.languageTags.put(column, languageTag);
                } else if (sparqlTypeString.startsWith("xsd:")) {
                    sparqlType = this.vf.createIRI("http://www.w3.org/2001/XMLSchema#", sparqlTypeString.substring(4));
                } else {
                    if (sparqlTypeString.equals(XSD.LANGUAGE.toString())) {
                        throw new IllegalArgumentException(String.format("Inadvertent use of \u201c%s\u201d as a datatype for \u201c%s\u201d column for SPARQL FILTER.", XSD.LANGUAGE, column));
                    }
                    sparqlType = this.vf.createIRI(sparqlTypeString);
                }
                if (!fieldType.hasSparqlType()) {
                    throw new IllegalArgumentException("IRIs cannot have SPARQL type for column: " + column);
                }
            }
            int precision = -1;
            int scale = -1;
            if (precisionStr != null) {
                if (!fieldType.hasPrecision()) {
                    throw new IllegalArgumentException("Only IRIs, Decimal and String SQL type values can have precision, for column: " + column);
                }
                precision = Integer.parseInt(precisionStr);
            }
            if (scaleStr != null) {
                if (!fieldType.hasScale()) {
                    throw new IllegalArgumentException("Only Decimal SQL type values can have scale, for column: " + column);
                }
                scale = Integer.parseInt(scaleStr);
            }
            LOG.info("SQL schema column: {} -> {} ({}, {}) {} -> {}", new Object[]{column, sqlType, precision, scale, nullability, sparqlType});
            this.sqlTypes.put(column, sqlType);
            if (nullability != null && nullability.toLowerCase().startsWith("not")) {
                this.sqlNotNull.add(column);
            }
            this.sqlPrecision.put(column, precision);
            this.sqlScale.put(column, scale);
            this.sparqlTypes.put(column, sparqlType);
            this.index2column.put(i, column);
            this.column2index.put(column, i);
            ++i;
        }
        this.bindingNames = Collections.unmodifiableSet(this.sqlTypes.keySet());
        Matcher keyMatcher = FOREIGN_KEY_PATTERN.matcher(this.query);
        while (keyMatcher.find()) {
            String columnThis = keyMatcher.group(1);
            String tableThat = keyMatcher.group(2);
            String columnThat = keyMatcher.group(3);
            if (StringUtils.isEmpty((CharSequence)columnThat)) {
                columnThat = columnThis;
            }
            if (!this.bindingNames.contains(columnThis)) {
                throw new IllegalArgumentException("Foreign key column not found in source table: " + columnThis);
            }
            if (this.foreignKeys.containsKey(columnThis)) {
                throw new IllegalArgumentException("Foreign key defined more than once for column: " + columnThis);
            }
            this.foreignKeys.put(columnThis, (Pair<String, String>)Pair.of((Object)tableThat, (Object)columnThat));
        }
        Matcher complexityMatcher = COMPLEXITY_PATTERN.matcher(this.query);
        this.complexity = complexityMatcher.find() ? Double.parseDouble(complexityMatcher.group(1)) : 100.0;
    }

    Repository getRepository() {
        return this.repository;
    }

    public String getQuery() {
        return this.query;
    }

    public String getSparqlQuery() {
        return this.sparqlQuery;
    }

    public Collection<String> getColumns() {
        return this.bindingNames;
    }

    public Collection<String> getPossibleColumns() {
        return this.possibleBindingNames;
    }

    String getColumnByIndex(int index) {
        return this.index2column.get(index);
    }

    int getIndexByColumn(String column) {
        Integer value = this.column2index.get(column);
        if (value == null) {
            throw new IllegalArgumentException("No such column: " + column);
        }
        return value;
    }

    Pair<String, String> getForeignKey(String column) {
        return this.foreignKeys.get(column.toLowerCase());
    }

    public String getSqlType(String column) {
        return this.sqlTypes.get(column.toLowerCase());
    }

    public boolean isNullable(String column) {
        return !this.sqlNotNull.contains(column.toLowerCase());
    }

    public int getSqlPrecision(String column) {
        return this.sqlPrecision.get(column.toLowerCase());
    }

    public int getSqlScale(String column) {
        return this.sqlScale.get(column.toLowerCase());
    }

    public IRI getSparqlType(String column) {
        return this.sparqlTypes.get(column.toLowerCase());
    }

    public String getLanguageTag(String column) {
        return this.languageTags.get(column.toLowerCase());
    }

    public double getComplexity() {
        return this.complexity;
    }

    boolean addFilter(RexNode filter, List<GraphDBFilter> filterValues) {
        SqlKind kind = filter.getKind();
        if (kind == SqlKind.AND) {
            boolean converted = true;
            for (RexNode subFilter : ((RexCall)filter).getOperands()) {
                converted &= this.addFilter(subFilter, filterValues);
            }
            return converted;
        }
        if (kind == SqlKind.OR) {
            ArrayList<GraphDBFilter> orFilterValues = new ArrayList<GraphDBFilter>();
            boolean converted = true;
            for (RexNode subFilter : ((RexCall)filter).getOperands()) {
                ArrayList<GraphDBFilter> subFilterValues;
                if (!(converted &= this.addFilter(subFilter, subFilterValues = new ArrayList<GraphDBFilter>()))) continue;
                if (subFilterValues.size() > 1) {
                    orFilterValues.add(new GraphDBAndFilter(subFilterValues));
                    continue;
                }
                orFilterValues.addAll(subFilterValues);
            }
            if (converted) {
                GraphDBOrFilter orFilterElement = new GraphDBOrFilter(orFilterValues);
                filterValues.add(orFilterElement);
            }
            return converted;
        }
        if (kind == SqlKind.NOT) {
            ArrayList<GraphDBFilter> negatedFilterValues;
            RexCall call = (RexCall)filter;
            RexNode argument = (RexNode)call.getOperands().get(0);
            boolean converted = this.addFilter(argument, negatedFilterValues = new ArrayList<GraphDBFilter>());
            if (converted) {
                filterValues.add(new GraphDBNotFilter(negatedFilterValues));
            }
            return converted;
        }
        if (GraphDBFilter.supportsPrimitive(kind)) {
            RexCall call = (RexCall)filter;
            List operands = call.getOperands();
            RexNode left = (RexNode)operands.get(0);
            if (left.isA(SqlKind.CAST)) {
                left = (RexNode)((RexCall)left).operands.get(0);
            }
            if (operands.size() > 1) {
                RexNode right = (RexNode)operands.get(1);
                if (right.isA(SqlKind.CAST)) {
                    right = (RexNode)((RexCall)right).operands.get(0);
                }
                Object modifier = null;
                if (operands.size() > 2) {
                    RexNode third = (RexNode)operands.get(2);
                    if (!(third instanceof RexLiteral)) {
                        return false;
                    }
                    modifier = ((RexLiteral)third).getValue2();
                }
                if (left instanceof RexInputRef && right instanceof RexLiteral) {
                    filterValues.add(this.newFilterElement(((RexInputRef)left).getIndex(), ((RexLiteral)right).getValue2(), kind, modifier));
                    return true;
                }
                if (right instanceof RexInputRef && left instanceof RexLiteral) {
                    filterValues.add(this.newFilterElement(((RexInputRef)right).getIndex(), ((RexLiteral)left).getValue2(), kind, modifier));
                    return true;
                }
            } else if (left instanceof RexInputRef) {
                filterValues.add(this.newUnaryFilterElement(((RexInputRef)left).getIndex(), kind));
                return true;
            }
        }
        return false;
    }

    GraphDBFilterElement newFilterElement(int index, Object sqlValue, SqlKind sqlKind, Object modifierValue) {
        String column = this.getColumnByIndex(index);
        String sqlType = this.getSqlType(column);
        IRI sparqlType = this.getSparqlType(column);
        return new GraphDBFilterElement(column, sqlValue, sqlKind, sqlType, this.toRDFValue(column, sqlValue, sqlType, sparqlType), sparqlType, modifierValue);
    }

    GraphDBFilterElement newUnaryFilterElement(int index, SqlKind sqlKind) {
        String column = this.getColumnByIndex(index);
        return new GraphDBFilterElement(column, sqlKind);
    }

    RelDataType getRowType(JavaTypeFactory typeFactory, List<GraphDBFieldType> fieldTypes) {
        ArrayList<RelDataType> types = new ArrayList<RelDataType>();
        ArrayList<String> names = new ArrayList<String>();
        Collection<String> columns = this.getColumns();
        if (columns == null || columns.isEmpty()) {
            throw new RuntimeException("Table must define columns");
        }
        for (String column : columns) {
            String name = column.toUpperCase();
            String typeString = this.getSqlType(column);
            GraphDBFieldType fieldType = GraphDBFieldType.of(typeString);
            if (fieldType == null) {
                LOG.warn("Found unknown type {} for column {}, treating it as string", (Object)typeString, (Object)name);
                fieldType = GraphDBFieldType.STRING;
            }
            RelDataType type = fieldType.toType(typeFactory, this.isNullable(column), this.getSqlPrecision(column), this.getSqlScale(column));
            names.add(name);
            types.add(type);
            if (fieldTypes == null) continue;
            fieldTypes.add(fieldType);
        }
        return typeFactory.createStructType(Pair.zip(names, types));
    }

    private Value toRDFValue(String column, Object sqlValue, String sqlType, IRI sparqlType) {
        switch (sqlType) {
            case "iri": {
                return this.vf.createIRI(sqlValue.toString());
            }
            case "date": {
                ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli((long)((Integer)sqlValue).intValue() * 86400000L), ZoneId.of("UTC"));
                return this.vf.createLiteral(this.dtf.newXMLGregorianCalendarDate(zdt.getYear(), zdt.getMonthValue(), zdt.getDayOfMonth(), Integer.MIN_VALUE).toXMLFormat(), sparqlType);
            }
            case "time": {
                ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(((Integer)sqlValue).intValue()), ZoneId.of("UTC"));
                return this.vf.createLiteral(this.dtf.newXMLGregorianCalendarTime(zdt.getHour(), zdt.getMinute(), zdt.getSecond(), Integer.MIN_VALUE).toXMLFormat(), sparqlType);
            }
            case "timestamp": {
                ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli((Long)sqlValue), ZoneId.of("UTC"));
                return this.vf.createLiteral(this.dtf.newXMLGregorianCalendar(GregorianCalendar.from(zdt)).toXMLFormat(), sparqlType);
            }
        }
        if (XSD.LANGUAGE.equals((Object)sparqlType)) {
            return this.vf.createLiteral(sqlValue.toString(), this.getLanguageTag(column));
        }
        return this.vf.createLiteral(sqlValue.toString(), sparqlType);
    }

    private void validateSparqlQuery() {
        this.setQueryBindings();
        Matcher matcher = GraphDBSparqlQueryReader.FILTER_PATTERN.matcher(this.query);
        if (!matcher.find()) {
            throw new IllegalArgumentException("No specified !filter optimization clause");
        }
    }

    private void setQueryBindings() {
        ParsedTupleQuery tupleQuery = QueryParserUtil.parseTupleQuery((QueryLanguage)QueryLanguage.SPARQL, (String)this.query, null);
        this.possibleBindingNames = tupleQuery.getTupleExpr().getBindingNames();
    }

    private void validateColumnName(String column) {
        if (!column.toLowerCase().equals(column)) {
            throw new IllegalArgumentException("Only lowercase variables may be used to define columns: " + column);
        }
        if (this.sqlTypes.containsKey(column)) {
            throw new IllegalArgumentException("Column defined more than once: " + column);
        }
        if (!this.possibleBindingNames.contains(column)) {
            throw new IllegalArgumentException("No such variable is defined inside the Select query: " + column);
        }
    }

    private GraphDBFieldType validateFieldType(String sqlType) {
        GraphDBFieldType fieldType = GraphDBFieldType.of(sqlType);
        if (fieldType == null) {
            throw new IllegalArgumentException("No such SQL type exists: " + sqlType);
        }
        return fieldType;
    }
}

