/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.jdbc;

import com.ontotext.graphdb.jdbc.GraphDBTableMetadata;
import com.ontotext.graphdb.statistics.StatisticsListener;
import com.ontotext.graphdb.statistics.models.enums.OperationType;
import com.ontotext.trree.monitorRepository.MonitorRepository;
import java.io.Closeable;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphDBSparqlQueryReader
implements Closeable {
    private static Logger LOG = LoggerFactory.getLogger(GraphDBSparqlQueryReader.class);
    public static final Pattern FILTER_PATTERN = Pattern.compile("^\\s*#\\s*!filter\\s*$", 8);
    GraphDBTableMetadata metadata;
    Repository repository;
    RepositoryConnection connection;
    TupleQueryResult result;
    String filter;
    long startTime;

    GraphDBSparqlQueryReader(GraphDBTableMetadata metadata, String filter) {
        Objects.requireNonNull(metadata, "metadata");
        this.metadata = metadata;
        this.filter = filter;
        this.repository = metadata.getRepository();
        this.connection = this.repository.getConnection();
        this.startTime = System.currentTimeMillis();
    }

    Value[] readNext() {
        if (this.result == null) {
            this.fetchData();
        }
        if (this.result == null || !this.result.hasNext()) {
            return null;
        }
        BindingSet next = (BindingSet)this.result.next();
        return this.convertBindingSet(next);
    }

    @Override
    public void close() {
        try {
            if (this.result != null) {
                this.result.close();
            }
            this.connection.close();
        }
        finally {
            this.updateJdbcQueryStatistics();
        }
    }

    private Value[] convertBindingSet(BindingSet bindingSet) {
        return (Value[])this.metadata.getColumns().stream().map(arg_0 -> ((BindingSet)bindingSet).getValue(arg_0)).toArray(Value[]::new);
    }

    private void fetchData() {
        Object currentQuery = this.metadata.getQuery();
        if (StringUtils.isNotEmpty((CharSequence)this.filter)) {
            Matcher matcher = FILTER_PATTERN.matcher((CharSequence)currentQuery);
            if (matcher.find()) {
                LOG.info("SQL to SPARQL filter: {}", (Object)this.filter);
                currentQuery = ((String)currentQuery).substring(0, matcher.start()) + this.filter + ((String)currentQuery).substring(matcher.end());
            } else {
                throw new RuntimeException("No !filter placeholder in query string");
            }
        }
        TupleQuery tupleQuery = this.connection.prepareTupleQuery((String)currentQuery);
        this.result = tupleQuery.evaluate();
    }

    private void updateJdbcQueryStatistics() {
        StatisticsListener statistics;
        if (this.repository instanceof MonitorRepository && (statistics = ((MonitorRepository)this.repository).getOwlimSail().getStatistics()) != null) {
            statistics.accumulateTime(OperationType.JDBC, System.currentTimeMillis() - this.startTime);
        }
    }
}

