/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.jdbc;

import com.ontotext.graphdb.jdbc.GraphDBFieldType;
import com.ontotext.graphdb.jdbc.GraphDBRowConverter;
import com.ontotext.graphdb.jdbc.GraphDBSparqlQueryReader;
import com.ontotext.graphdb.jdbc.GraphDBTableMetadata;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.calcite.linq4j.Enumerator;
import org.eclipse.rdf4j.model.Value;

class GraphDBEnumerator
implements Enumerator<Object[]> {
    private final GraphDBSparqlQueryReader reader;
    private final AtomicBoolean cancelFlag;
    private final GraphDBRowConverter rowConverter;
    private Object[] current;

    GraphDBEnumerator(GraphDBTableMetadata metadata, AtomicBoolean cancelFlag, List<GraphDBFieldType> fieldTypes, String filter) {
        this.cancelFlag = cancelFlag;
        this.rowConverter = new GraphDBRowConverter(fieldTypes, GraphDBEnumerator.identityList(fieldTypes.size()));
        this.reader = new GraphDBSparqlQueryReader(metadata, filter);
    }

    public Object[] current() {
        return this.current;
    }

    public boolean moveNext() {
        if (this.cancelFlag.get()) {
            return false;
        }
        Value[] values = this.reader.readNext();
        if (values == null) {
            this.current = null;
            this.reader.close();
            return false;
        }
        this.current = this.rowConverter.convertRow(values);
        return true;
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.reader.close();
    }

    static int[] identityList(int n) {
        int[] integers = new int[n];
        for (int i = 0; i < n; ++i) {
            integers[i] = i;
        }
        return integers;
    }
}

