/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.jdbc;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.graphdb.jdbc.DemoUtil;
import com.ontotext.graphdb.jdbc.GraphDBMeta;
import com.ontotext.graphdb.jdbc.GraphDBSQLConnection;
import com.ontotext.graphdb.jdbc.RepositoryManagerModelProperties;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.ConnectStringParser;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.UnregisteredDriver;
import org.apache.calcite.jdbc.CalciteJdbc41Factory;
import org.apache.calcite.jdbc.CalciteSchema;
import org.eclipse.rdf4j.repository.manager.LocalRepositoryManager;

public class Driver
extends org.apache.calcite.jdbc.Driver {
    public static final String CONNECT_STRING_PREFIX = "jdbc:graphdb:internal:";
    public static final String CATALOG_NAME = "GRAPHDB";
    private static LocalRepositoryManager repositoryManager;

    static LocalRepositoryManager getRepositoryManager() {
        return repositoryManager;
    }

    @VisibleForTesting
    public static void reset() {
        repositoryManager = null;
    }

    protected String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        boolean demoMode = false;
        if (repositoryManager == null && (repositoryManager = (LocalRepositoryManager)info.get("repositoryManager")) == null && (demoMode = url.equals("jdbc:graphdb:internal:demo"))) {
            repositoryManager = DemoUtil.setupDemoRepositoryManager();
        }
        if (demoMode && !info.containsKey("model")) {
            info.put("model", new RepositoryManagerModelProperties(repositoryManager, id -> true).getProperty("model"));
        }
        String urlSuffix = url.substring(CONNECT_STRING_PREFIX.length());
        Properties info2 = ConnectStringParser.parse((String)urlSuffix, (Properties)info);
        if (!(this.factory instanceof CalciteJdbc41Factory)) {
            throw new IllegalStateException("AvaticaFactory is not an instance of CalciteJdbc41Factory");
        }
        CalciteJdbc41Factory.CalciteJdbc41Connection connection = ((CalciteJdbc41Factory)this.factory).newConnection((UnregisteredDriver)this, this.factory, url, info2, CalciteSchema.createRootSchema((boolean)true, (boolean)true, (String)CATALOG_NAME), null);
        this.handler.onConnectionInit((AvaticaConnection)connection);
        connection.setCatalog(CATALOG_NAME);
        return new GraphDBSQLConnection((Connection)connection);
    }

    public Meta createMeta(AvaticaConnection connection) {
        return new GraphDBMeta(super.createMeta(connection));
    }

    static {
        new Driver().register();
    }
}

