/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.jdbc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import org.apache.commons.io.FileUtils;
import org.eclipse.rdf4j.repository.manager.LocalRepositoryManager;

public class DemoUtil {
    static LocalRepositoryManager setupDemoRepositoryManager() throws SQLException {
        try {
            String[] resources;
            Path tempDirectory = Files.createTempDirectory("graphdb-jdbc-demo", new FileAttribute[0]);
            LocalRepositoryManager repositoryManager = new LocalRepositoryManager(tempDirectory.toFile());
            for (String resource : resources = new String[]{"repositories/repo1/config.ttl", "repositories/repo1/sql/person.rq", "repositories/repo1/sql/salary.rq"}) {
                Path target = tempDirectory.resolve(resource);
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                InputStream stream = DemoUtil.class.getResourceAsStream("/" + resource);
                if (stream == null) {
                    throw new IllegalStateException("Resource not found: " + resource);
                }
                FileUtils.copyInputStreamToFile((InputStream)stream, (File)target.toFile());
            }
            repositoryManager.init();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    repositoryManager.shutDown();
                    FileUtils.deleteDirectory((File)tempDirectory.toFile());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }));
            return repositoryManager;
        }
        catch (IOException e) {
            throw new SQLException("Cannot setup demo GraphDB JDBC: " + e.getMessage() + "; " + String.valueOf(DemoUtil.class.getClassLoader()), e);
        }
    }
}

