/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.validator;

import com.ontotext.models.Role;
import com.ontotext.models.RoleAction;
import com.ontotext.models.Roles;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import com.ontotext.rbac.RbacOptions;
import com.ontotext.soaas.plugin.Inject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class RbacSchemaValidator
implements SchemaValidator {
    private String rbacManagementRole = "SchemaRBACAdmin";

    public OperationResponse validate(SomlSchema somlSchema) {
        boolean hasAdminRole;
        OperationResponse response = new OperationResponse();
        Roles roles = somlSchema.getRbac().getRoles();
        roles.forEach(this.applyRoleValidator(somlSchema, response));
        if (roles.isTracked("Federation_SystemRole")) {
            response.addWarningMessage("rbac.role.overridden.federation.system.role", new Object[]{"Federation_SystemRole"});
        }
        if (RbacSchemaValidator.isSomlRbacSchema(somlSchema) && !(hasAdminRole = roles.containsKey((Object)this.rbacManagementRole))) {
            response.addErrorMessage("rbac.role.missing.schema.admin", new Object[]{this.rbacManagementRole});
        }
        return response;
    }

    private BiConsumer<String, Role> applyRoleValidator(SomlSchema somlSchema, OperationResponse response) {
        Roles roles = somlSchema.getRbac().getRoles();
        return (roleName, role) -> {
            if (!roles.isTracked(roleName)) {
                return;
            }
            if (role == null) {
                response.addErrorMessage("rbac.role.no.declaration", new Object[]{roleName});
                return;
            }
            if (StringUtils.isBlank((CharSequence)role.getName()) || "null".equals(role.getName())) {
                response.addErrorMessage("rbac.role.no.name");
            }
            if (StringUtils.isBlank((CharSequence)role.getDescription())) {
                response.addWarningMessage("rbac.role.no.description", new Object[]{roleName});
            }
            if (role.getActions().isEmpty() && role.getNotActions().isEmpty()) {
                response.addErrorMessage("rbac.role.no.actions", new Object[]{roleName});
            } else {
                this.validateRegularActions((Role)role, response, somlSchema);
                this.validateDuplicatedActions(response, (Role)role);
                this.validateRegexActions((Role)role, response);
            }
        };
    }

    private void validateRegularActions(Role role, OperationResponse response, SomlSchema somlSchema) {
        role.getActions().stream().filter(a -> a.getWildcardGeneratedSourceAction() == null).filter(RoleAction::isActionWithoutRegexWithFilter).forEach(action -> this.validateAction(response, (RoleAction)action, somlSchema));
        role.getNotActions().stream().filter(a -> a.getWildcardGeneratedSourceAction() == null).filter(RoleAction::isActionWithoutRegexWithFilter).forEach(notAction -> this.validateAction(response, (RoleAction)notAction, somlSchema));
    }

    private void validateRegexActions(Role role, OperationResponse response) {
        role.getActions().stream().filter(RoleAction::isActionRegexWithFilter).forEach(action -> this.validateRegexAction(role.getActions(), (RoleAction)action, response));
        role.getNotActions().stream().filter(RoleAction::isActionRegexWithFilter).forEach(notAction -> this.validateRegexAction(role.getNotActions(), (RoleAction)notAction, response));
    }

    private void validateRegexAction(List<RoleAction> actionList, RoleAction action, OperationResponse response) {
        long generatedValidActionCount = actionList.stream().filter(RoleAction::hasWildcardGeneratedParentAction).filter(a -> a.getWildcardGeneratedSourceAction().equals((Object)action)).count();
        if (generatedValidActionCount == 0L) {
            response.addErrorMessage("rbac.role.action.wrong.regex.for.object.property", new Object[]{action.getContainedIn().getName(), action.getAction()});
        }
    }

    private void validateAction(OperationResponse response, RoleAction action, SomlSchema somlSchema) {
        String roleName = action.getContainedIn().getName();
        if (RbacSchemaValidator.isActionDeclarationInvalid(action, somlSchema)) {
            response.addErrorMessage("rbac.role.action.invalid.syntax", new Object[]{roleName, action.getAction()});
        } else if (!RbacSchemaValidator.isSomlRbacSchema(somlSchema)) {
            this.validateRelatedShapes(response, action);
        }
    }

    private static boolean isActionDeclarationInvalid(RoleAction action, SomlSchema somlSchema) {
        if (RbacSchemaValidator.isSomlRbacSchema(somlSchema)) {
            return StringUtils.isBlank((CharSequence)action.getObject()) || action.getActionType() == null;
        }
        return StringUtils.isBlank((CharSequence)action.getObject()) || StringUtils.isBlank((CharSequence)action.getProperty()) || action.getActionType() == null || action.hasFilter() && (!action.getFilter().startsWith("(") || !action.getFilter().contains("where"));
    }

    private void validateRelatedShapes(OperationResponse response, RoleAction action) {
        String roleName = action.getContainedIn().getName();
        if (!action.hasRelatedShapes()) {
            response.addErrorMessage("rbac.role.action.no.related.object", new Object[]{roleName, action.getAction()});
        } else if (!action.hasRelatedPropertyShapes()) {
            response.addErrorMessage("rbac.role.action.no.related.property", new Object[]{roleName, action.getAction()});
        }
    }

    private void validateDuplicatedActions(OperationResponse response, Role role) {
        Set actions = role.getActions().stream().map(RoleAction::getAction).collect(Collectors.toSet());
        role.getNotActions().forEach(notAction -> {
            String notActionSyntax = notAction.getAction();
            if (actions.contains(notActionSyntax)) {
                response.addErrorMessage("rbac.role.duplicated.action", new Object[]{role.getName(), notActionSyntax});
            }
        });
    }

    private static boolean isSomlRbacSchema(SomlSchema somlSchema) {
        return "/soml/soml-rbac".equals(somlSchema.getId());
    }

    @Inject
    public void setValidatorOptions(RbacOptions somlRbacConfigurations) {
        this.rbacManagementRole = Objects.requireNonNullElse(StringUtils.trimToNull((String)somlRbacConfigurations.getRbacManagementRole()), "SchemaRBACAdmin");
    }
}

