/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.validator;

import com.ontotext.graphql.parser.OperationPostProcessor;
import com.ontotext.models.BaseOperation;
import com.ontotext.models.Operation;
import com.ontotext.models.OperationValidator;
import com.ontotext.models.Selection;
import com.ontotext.models.Shape;
import com.ontotext.models.ValidationContext;
import com.ontotext.models.ValidatorOptions;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.mutation.CreateMutation;
import com.ontotext.models.mutation.DeleteMutation;
import com.ontotext.models.mutation.UpdateMutation;
import com.ontotext.models.query.Query;
import com.ontotext.rbac.SecurityContext;
import com.ontotext.rbac.validator.RbacConstraintsValidationContext;
import com.ontotext.rbac.validator.RbacConstraintsValidator;
import com.ontotext.soaas.plugin.Order;
import java.util.Collections;

@Order(value=2000)
public class RbacQueryConstraintsValidator
extends RbacConstraintsValidator
implements OperationValidator,
OperationPostProcessor {
    @Override
    public boolean isEnabled(ValidatorOptions options) {
        if (!super.isEnabled(options)) {
            return false;
        }
        return options.isEnabled(this.getClass());
    }

    public void postProcess(Operation operation, SecurityContext securityContext) {
        if (this.isSecurityNotEnabled() || this.isMutation(operation)) {
            return;
        }
        RbacConstraintsValidationContext context = this.buildPostProcessingContext(operation, securityContext);
        if (this.isTypeAccessible(context, operation)) {
            this.addConstraintsOrWarningsToQuerySelections(context, operation.getSelections());
        }
    }

    public OperationResponse validate(Operation operation, ValidationContext validationContext) {
        if (!this.isEnabled(validationContext.getValidatorOptions())) {
            return OperationResponse.EMPTY;
        }
        RbacConstraintsValidationContext context = this.buildValidationContext(operation, validationContext);
        BaseOperation baseOperation = (BaseOperation)operation;
        if (!this.isMutation((Operation)baseOperation) && this.isTypeAccessible(context, (Operation)baseOperation)) {
            this.addConstraintsOrWarningsToQuerySelections(context, baseOperation.getSelections());
        }
        return context.getResponse();
    }

    private boolean isTypeAccessible(RbacConstraintsValidationContext context, Operation baseOperation) {
        Shape type = baseOperation.getDefinedInType();
        if (baseOperation.isCountSelection()) {
            type = baseOperation.getCountedType().orElse(type);
        }
        return this.isReturnTypeAccessible(context, type, Collections.singleton(baseOperation.getLocation()));
    }

    public OperationResponse visit(DeleteMutation deleteMutation, ValidationContext validationContext) {
        return this.validate((Operation)deleteMutation, validationContext);
    }

    public OperationResponse visit(Selection selection, ValidationContext validationContext) {
        return OperationResponse.EMPTY;
    }

    public OperationResponse visit(Query query, ValidationContext validationContext) {
        return this.validate((Operation)query, validationContext);
    }

    public OperationResponse visit(UpdateMutation mutation, ValidationContext validationContext) {
        return this.validate((Operation)mutation, validationContext);
    }

    public OperationResponse visit(CreateMutation mutation, ValidationContext validationContext) {
        return this.validate((Operation)mutation, validationContext);
    }
}

