/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.validator;

import com.ontotext.graphql.compiler.RbacMutationValidationQueryBuilder;
import com.ontotext.graphql.responder.EndpointExecutionResponse;
import com.ontotext.graphql.responder.MutationResponse;
import com.ontotext.graphql.responder.MutationSparqlEndpointInvoker;
import com.ontotext.graphql.responder.UpdateExecution;
import com.ontotext.graphql.responder.UpdateStep;
import com.ontotext.graphql.responder.validation.MutationActiveValidator;
import com.ontotext.models.ValidatorOptions;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.mutation.CreateMutation;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.mutation.UpdateMutation;
import com.ontotext.rbac.util.RbacUtils;
import com.ontotext.rbac.validator.RbacConstraintsValidator;
import com.ontotext.soaas.common.connection.Endpoint;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import java.util.List;
import java.util.UUID;

public class RbacPreCommitValidator
implements MutationActiveValidator {
    private static Boolean legacyMode = null;

    public MutationActiveValidator.Phase getPhase() {
        return MutationActiveValidator.Phase.PRE_COMMIT;
    }

    public OperationResponse validate(UpdateExecution request, MutationActiveValidator.ActiveValidationContext context) {
        if (!(request.getOperation() instanceof CreateMutation) && !(request.getOperation() instanceof UpdateMutation)) {
            return OperationResponse.EMPTY;
        }
        ValidatorOptions validatorOptions = context.getValidatorOptions();
        if (!validatorOptions.isEnabled() || !validatorOptions.isEnabled(RbacConstraintsValidator.class)) {
            return OperationResponse.EMPTY;
        }
        if (!validatorOptions.isEnabled(RbacPreCommitValidator.class)) {
            return OperationResponse.EMPTY;
        }
        List<UpdateStep> updateSteps = this.createPreCommitSteps(request.getOperation(), RbacPreCommitValidator.getLegacyMode(request, context), request.getOperationOptions());
        EndpointExecutionResponse<MutationResponse> validationResp = this.executeUpdateSteps(request, context, updateSteps);
        if (!validationResp.isValid()) {
            OperationResponse opResp = new OperationResponse();
            validationResp.getErrors().forEach(arg_0 -> ((OperationResponse)opResp).addErrorMessage(arg_0));
            return opResp;
        }
        return OperationResponse.EMPTY;
    }

    private List<UpdateStep> createPreCommitSteps(Mutation operation, boolean legacyMode, OperationBuilderOptions options) {
        RbacMutationValidationQueryBuilder queryBuilder = new RbacMutationValidationQueryBuilder(operation.getSchema(), legacyMode, options);
        return queryBuilder.toPreCommitValidationSteps(operation);
    }

    private EndpointExecutionResponse<MutationResponse> executeUpdateSteps(UpdateExecution request, MutationActiveValidator.ActiveValidationContext context, List<UpdateStep> updateSteps) {
        UpdateExecution updateExecution = this.createUpdateExecution(request, context, updateSteps);
        return new MutationSparqlEndpointInvoker.UpdateStepsExecutor(updateExecution, context.getEndpoint(), context.getSparqlInvoker()).execute();
    }

    private UpdateExecution createUpdateExecution(UpdateExecution request, MutationActiveValidator.ActiveValidationContext context, List<UpdateStep> updateSteps) {
        UpdateExecution updateExecution = new UpdateExecution(UUID.randomUUID().toString(), (Endpoint)context.getEndpoint(), context.getSoml(), null, request.getOperationOptions());
        updateSteps.forEach(arg_0 -> ((UpdateExecution)updateExecution).addUpdateStep(arg_0));
        updateExecution.setTransactionPolicy(request.getTransactionPolicy());
        updateExecution.setConnectionReusePolicy(request.getConnectionReusePolicy());
        updateExecution.setQuery(request.getQuery());
        return updateExecution;
    }

    private static synchronized boolean getLegacyMode(UpdateExecution request, MutationActiveValidator.ActiveValidationContext context) {
        if (legacyMode == null) {
            legacyMode = RbacUtils.isLegacyValidation(request, context);
        }
        return legacyMode;
    }
}

