/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.validator;

import com.ontotext.graphql.compiler.RbacPartialUpdateVisitor;
import com.ontotext.graphql.responder.UpdateExecution;
import com.ontotext.graphql.responder.validation.MutationActiveValidator;
import com.ontotext.models.OperationVisitor;
import com.ontotext.models.OperationVisitorContext;
import com.ontotext.models.ValidatorOptions;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.mutation.DeleteMutation;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.mutation.UpdateMutation;
import com.ontotext.rbac.util.RbacUtils;
import com.ontotext.rbac.validator.RbacConstraintsValidator;

public class RbacPartialUpdateValidator
implements MutationActiveValidator {
    private static RbacPartialUpdateVisitor partialUpdateVisitor;
    private static Boolean legacyMode;

    public MutationActiveValidator.Phase getPhase() {
        return MutationActiveValidator.Phase.PRE_TX;
    }

    public OperationResponse validate(UpdateExecution request, MutationActiveValidator.ActiveValidationContext context) {
        Mutation operation;
        if (partialUpdateVisitor == null) {
            RbacPartialUpdateValidator.initPartialUpdateVisitor(request, context);
        }
        if (!((operation = request.getOperation()) instanceof UpdateMutation) && !(operation instanceof DeleteMutation)) {
            return OperationResponse.EMPTY;
        }
        ValidatorOptions validatorOptions = context.getValidatorOptions();
        if (!validatorOptions.isEnabled() || !validatorOptions.isEnabled(RbacConstraintsValidator.class)) {
            return OperationResponse.EMPTY;
        }
        if (!validatorOptions.isEnabled(RbacPartialUpdateValidator.class)) {
            return OperationResponse.EMPTY;
        }
        request.getOperation().accept((OperationVisitor)partialUpdateVisitor, (OperationVisitorContext)new RbacPartialUpdateVisitor.Context(request));
        return OperationResponse.EMPTY;
    }

    private static synchronized void initPartialUpdateVisitor(UpdateExecution request, MutationActiveValidator.ActiveValidationContext context) {
        partialUpdateVisitor = new RbacPartialUpdateVisitor(RbacPartialUpdateValidator.getLegacyMode(request, context));
    }

    private static synchronized boolean getLegacyMode(UpdateExecution request, MutationActiveValidator.ActiveValidationContext context) {
        if (legacyMode == null) {
            legacyMode = RbacUtils.isLegacyValidation(request, context);
        }
        return legacyMode;
    }

    static void reset() {
        partialUpdateVisitor = null;
        legacyMode = null;
    }

    static {
        legacyMode = null;
    }
}

