/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.util;

import com.ontotext.models.query.AbstractExpressionVisitor;
import com.ontotext.models.query.Expression;
import com.ontotext.models.query.ExpressionTerm;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.ExpressionVisitor;
import com.ontotext.models.query.ExpressionVisitorContext;
import com.ontotext.models.query.In;
import com.ontotext.models.query.NotIn;
import com.ontotext.models.query.Value;
import com.ontotext.models.security.Role;
import com.ontotext.rbac.validator.RbacConstraintsValidationContext;
import io.jsonwebtoken.RequiredTypeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.jetbrains.annotations.NotNull;

class ContextValuesReplacer
extends AbstractExpressionVisitor<ExpressionValue, ContextValuesReplacerContext> {
    public static final String CTX_CLAIMS_PREFERRED_USERNAME = "${ctx.claims.preferred_username}";
    public static final String CTX_USERNAME = "${ctx.username}";
    private static final ValueFactory vf = SimpleValueFactory.getInstance();
    private static final String CLAIMS_PREFIX = "${ctx.claims.";
    private static final String CUSTOM_PREFIX = "CUSTOM_";

    ContextValuesReplacer() {
    }

    public ExpressionValue visit(Value target, ContextValuesReplacerContext context) {
        Object value = target.getValue();
        if (value instanceof String) {
            context.getReplacedValue(value).ifPresent(this.getSetValue(target, false, context));
        } else if (value instanceof Literal) {
            context.getReplacedValue(((Literal)value).getLabel()).ifPresent(this.getSetValue(target, true, context));
        }
        return target;
    }

    public ExpressionValue visit(In target, ContextValuesReplacerContext context) {
        ExpressionValue expressionTerm = this.visitExpressionTerm((ExpressionTerm)target, context);
        if (context.replaceValue instanceof List) {
            target.setValue((Object)((List)context.replaceValue));
        }
        return expressionTerm;
    }

    public ExpressionValue visit(NotIn target, ContextValuesReplacerContext context) {
        ExpressionValue expressionTerm = this.visitExpressionTerm((ExpressionTerm)target, context);
        if (context.replaceValue instanceof List) {
            target.setValue((Object)((List)context.replaceValue));
        }
        return expressionTerm;
    }

    @NotNull
    private Consumer<Object> getSetValue(Value target, boolean asLiteral, ContextValuesReplacerContext context) {
        return newValue -> {
            if (newValue instanceof Collection) {
                Collection collectionValues = (Collection)newValue;
                List<Object> convertedValues = asLiteral ? collectionValues.stream().map(arg_0 -> ((ValueFactory)vf).createLiteral(arg_0)).collect(Collectors.toList()) : new ArrayList(collectionValues);
                context.replaceValue = convertedValues.stream().map(Value::new).collect(Collectors.toList());
                target.setValue(convertedValues);
            } else if (asLiteral) {
                Literal literal = vf.createLiteral(newValue.toString());
                target.setValue((Object)literal);
            } else {
                target.setValue(newValue);
            }
        };
    }

    protected ExpressionValue visitExpression(Expression target, ContextValuesReplacerContext context) {
        target.getTerms().forEach(term -> term.accept((ExpressionVisitor)this, (ExpressionVisitorContext)context));
        return target;
    }

    protected ExpressionValue visitExpressionTerm(ExpressionTerm target, ContextValuesReplacerContext context) {
        this.visitTermValue(target.getValue(), context);
        return target;
    }

    private void visitTermValue(Object target, ContextValuesReplacerContext context) {
        if (target instanceof Expression) {
            ((Expression)target).accept((ExpressionVisitor)this, (ExpressionVisitorContext)context);
        } else if (target instanceof Value) {
            ((Value)target).accept((ExpressionVisitor)this, (ExpressionVisitorContext)context);
        } else if (target instanceof Collection) {
            this.visitCollection((Collection)target, context);
        }
    }

    private void visitCollection(Collection<?> target, ContextValuesReplacerContext context) {
        LinkedList<Object> updatedValues = new LinkedList<Object>();
        boolean updated = false;
        for (Object val : target) {
            context.replaceValue = null;
            this.visitTermValue(val, context);
            if (context.replaceValue != null) {
                updated = true;
                if (context.replaceValue instanceof Collection) {
                    updatedValues.addAll((Collection)context.replaceValue);
                } else {
                    updatedValues.add(context.replaceValue);
                }
                context.replaceValue = null;
                continue;
            }
            updatedValues.add(val);
        }
        if (updated) {
            context.replaceValue = updatedValues;
        }
    }

    static class ContextValuesReplacerContext
    implements ExpressionVisitorContext {
        Object replaceValue;
        private final Map<String, Object> replaceMap = new HashMap<String, Object>(3);
        private final Function<String, Object> claimResolver;
        private final Function<String, Collection<String>> claimsResolver;

        ContextValuesReplacerContext(RbacConstraintsValidationContext context) {
            this.replaceMap.put(ContextValuesReplacer.CTX_CLAIMS_PREFERRED_USERNAME, context.getUserName());
            this.replaceMap.put(ContextValuesReplacer.CTX_USERNAME, context.getUserName());
            List<String> roles = this.getCustomUserAuthorizationsOrDefaultRole(context);
            this.replaceMap.put("${ctx.claims.authorities}", roles);
            this.replaceMap.put("${ctx.roles}", roles);
            this.claimResolver = context::resolveUserClaim;
            this.claimsResolver = context::resolveUserClaims;
        }

        private List<String> getCustomUserAuthorizationsOrDefaultRole(RbacConstraintsValidationContext context) {
            ArrayList<String> roles = new ArrayList<String>(context.getAuthorizations().stream().map(Role::getName).map(String::toUpperCase).filter(role -> role.startsWith(ContextValuesReplacer.CUSTOM_PREFIX)).map(role -> role.substring(ContextValuesReplacer.CUSTOM_PREFIX.length())).toList());
            if (roles.isEmpty()) {
                roles.add(context.getSchema().getConfig().getDefaultRole().orElse("Default").toUpperCase());
            }
            return roles;
        }

        Optional<Object> getReplacedValue(Object key) {
            Object claimValue;
            String keyString = Objects.toString(key);
            Object value = this.replaceMap.get(keyString);
            if (value != null) {
                return Optional.of(value);
            }
            if (!keyString.startsWith(ContextValuesReplacer.CLAIMS_PREFIX)) {
                return Optional.empty();
            }
            String claimKey = keyString.substring(ContextValuesReplacer.CLAIMS_PREFIX.length(), keyString.length() - 1);
            boolean multiValued = claimKey.endsWith("+");
            if (multiValued) {
                claimKey = claimKey.substring(0, claimKey.length() - 1);
                try {
                    Collection<String> values = this.claimsResolver.apply(claimKey);
                    if (values.isEmpty()) {
                        return Optional.empty();
                    }
                    return Optional.of(values);
                }
                catch (RequiredTypeException values) {
                    // empty catch block
                }
            }
            if ((claimValue = this.claimResolver.apply(claimKey)) != null) {
                if (multiValued && claimValue instanceof String) {
                    return Optional.of(List.of(claimValue.toString().split("[,;\\s]+")));
                }
                return Optional.of(claimValue);
            }
            return Optional.empty();
        }
    }
}

