/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.models.extensions;

import com.ontotext.models.Rbac;
import com.ontotext.models.Role;
import com.ontotext.models.RoleAction;
import com.ontotext.models.Roles;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.SchemaExtension;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public abstract class SchemaRoleSupplier
implements SchemaExtension {
    public void process(SomlSchema somlSchema) {
        String defaultRoleName;
        Roles roles = somlSchema.getRbac().getRoles();
        if (!roles.containsKey((Object)(defaultRoleName = this.role(somlSchema.getRbac())))) {
            Role defaultRole = this.getDefaultRole(defaultRoleName);
            defaultRole.expand(roles);
            roles.put(defaultRole.getName(), defaultRole);
        }
    }

    private Role getDefaultRole(String defaultRoleName) {
        Role defaultRole = new Role(true);
        defaultRole.setName(defaultRoleName);
        defaultRole.setDescription(this.roleDescription());
        this.setActions(this::allowedActions, arg_0 -> ((Role)defaultRole).setActions(arg_0));
        this.setActions(this::notAllowedActions, arg_0 -> ((Role)defaultRole).setNotActions(arg_0));
        return defaultRole;
    }

    private void setActions(Supplier<List<String>> actionSupplier, Consumer<List<RoleAction>> actionsConsumer) {
        List<String> actionPatterns = actionSupplier.get();
        if (CollectionUtils.isEmpty(actionPatterns)) {
            return;
        }
        List actions = actionPatterns.stream().filter(Objects::nonNull).map(RoleAction::new).collect(Collectors.toList());
        actionsConsumer.accept(actions);
    }

    protected List<String> allowedActions() {
        return Collections.emptyList();
    }

    protected List<String> notAllowedActions() {
        return Collections.emptyList();
    }

    protected String roleDescription() {
        return null;
    }

    protected abstract String role(Rbac var1);
}

