/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.models.extensions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Streams;
import com.ontotext.graphql.parser.exceptions.InvalidOperationException;
import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Role;
import com.ontotext.models.RoleAction;
import com.ontotext.models.Roles;
import com.ontotext.models.Shape;
import com.ontotext.models.SimpleActionFilter;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaExtension;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.Query;
import com.ontotext.rbac.util.RbacFilterToParsedQueryHelper;
import com.ontotext.rbac.util.RbacUtils;
import com.ontotext.soaas.plugin.Order;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Order(value=3200)
public class FilteredActionParser
implements SchemaExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilteredActionParser.class);
    private static final String RBAC_ROLE_ACTION_FILTER_NOT_PARSED = "rbac.role.action.filter.not.parsed";
    private static final String INVALID_SYNTAX = "rbac.role.action.invalid.syntax";
    private static final String OPERAND_NOT_COMPATIBLE_WITH_COLLECTION = "rbac.role.action.use.filter.equals.notEquals.with.collection";

    public boolean canHandle(SomlSchema somlSchema) {
        return !somlSchema.getTypes().isEmpty() && !somlSchema.getConfig().isEmpty();
    }

    public void postBaseSchemaMergeProcessing(SomlSchema somlSchema) {
        this.processWildcardInObjectsAndProperties(somlSchema);
        OperationResponse response = new OperationResponse();
        HashSet<RoleAction> invalidated = new HashSet<RoleAction>();
        this.validateFilteredAction(somlSchema.getRbac().getRoles(), response, invalidated, somlSchema);
        RbacFilterToParsedQueryHelper parseHelper = new RbacFilterToParsedQueryHelper(somlSchema);
        Roles roles = somlSchema.getRbac().getRoles();
        roles.forEach((roleName, role) -> {
            if (role != null) {
                role.getActions().forEach(action -> this.parseActionFilter((RoleAction)action, parseHelper, response, invalidated));
                role.getNotActions().forEach(action -> this.parseActionFilter((RoleAction)action, parseHelper, response, invalidated));
            }
        });
        if (!response.isValid()) {
            throw new InvalidSchemaException("Parsing of RBAC Filters failed", response);
        }
    }

    private void validateFilteredAction(Roles roles, OperationResponse response, Set<RoleAction> invalidated, SomlSchema somlSchema) {
        for (Role role : roles.values()) {
            if (role == null) continue;
            Streams.concat((Stream[])new Stream[]{role.getActions().stream(), role.getNotActions().stream()}).filter(RoleAction::hasFilter).forEach(action -> this.filterHasAccessToSelections((RoleAction)action, response, invalidated, somlSchema));
        }
    }

    private void processWildcardInObjectsAndProperties(SomlSchema somlSchema) {
        Roles roles = somlSchema.getRbac().getRoles();
        roles.values().stream().filter(Objects::nonNull).forEach(role -> {
            List<RoleAction> newRoleActions = this.processWildcardActions(role.getActions().stream().filter(RoleAction::isActionRegexWithFilter).toList(), somlSchema);
            List<RoleAction> newRoleNotActions = this.processWildcardActions(role.getNotActions().stream().filter(RoleAction::isActionRegexWithFilter).toList(), somlSchema);
            if (!newRoleActions.isEmpty() || !newRoleNotActions.isEmpty()) {
                role.getActions().addAll(newRoleActions);
                role.getNotActions().addAll(newRoleNotActions);
            }
        });
    }

    private List<RoleAction> processWildcardActions(List<RoleAction> roleActions, SomlSchema somlSchema) {
        ArrayList<RoleAction> newRoleActions = new ArrayList<RoleAction>();
        for (RoleAction action : roleActions) {
            if (!action.isActionRegexWithFilter()) continue;
            Collection<Shape> resolvedObjects = RbacUtils.resolveQueryableShapes((Map<String, Shape>)somlSchema.getObjects(), action.getObject());
            for (Shape shape : resolvedObjects) {
                List<String> resolvedProperties = this.resolveProperties(shape.getId(), action, somlSchema);
                for (String property : resolvedProperties) {
                    RoleAction newAction = action.createDuplicate();
                    newAction.setObject(shape.getId());
                    newAction.setProperty(property);
                    newAction.setWildcardGeneratedSourceAction(action);
                    newRoleActions.add(newAction);
                }
            }
        }
        return newRoleActions;
    }

    private void filterHasAccessToSelections(RoleAction roleAction, OperationResponse response, Set<RoleAction> invalidated, SomlSchema somlSchema) {
        try {
            Collection<Shape> shapes = RbacUtils.resolveQueryableShapes((Map<String, Shape>)somlSchema.getObjects(), roleAction.getObject());
            Set<String> selections = RbacUtils.getFirstLevelSelection(roleAction.getFilter());
            selections.stream().map(arg_0 -> ((Prefixes)somlSchema.getPrefixes()).nameToShortIri(arg_0)).forEach(this.checkAccessToSelection(roleAction, response, invalidated, shapes));
        }
        catch (JsonProcessingException ex) {
            LOGGER.error("Could not evaluate if filter is applicable for selection:\n, {}", (Object)ex.getMessage());
        }
    }

    private Consumer<String> checkAccessToSelection(RoleAction roleAction, OperationResponse response, Set<RoleAction> invalidated, Collection<Shape> shapes) {
        return whereSel -> {
            Set<String> incompatible = this.collectIncompatibleShapes(shapes, (String)whereSel);
            if (incompatible.isEmpty()) {
                return;
            }
            invalidated.add(roleAction);
            if (roleAction.getWildcardGeneratedSourceAction() == null) {
                String templateKey = this.isIfTypeClause((String)whereSel) ? "rbac.role.action.filter.ifType.notApplicable" : "rbac.role.action.filter.notApplicable";
                if (FilteredActionParser.isNotUserDefinedAction(roleAction)) {
                    return;
                }
                response.addErrorMessage(templateKey, new Object[]{roleAction.getContainedIn().getName(), roleAction.getFilter(), roleAction.getObject(), incompatible, whereSel});
            }
        };
    }

    private static boolean isNotUserDefinedAction(RoleAction roleAction) {
        return roleAction.getContainedIn() != null && roleAction.getContainedIn().getContainedIn() != null && !roleAction.getContainedIn().getContainedIn().isTracked(roleAction.getContainedIn().getName());
    }

    private Set<String> collectIncompatibleShapes(Collection<Shape> shapes, String whereSel) {
        Set<String> incompatible = this.isIfTypeClause(whereSel) ? this.collectShapesIncompatibleWithIfFilterCheck(shapes, whereSel) : this.collectShapesIncompatibleWithSelection(shapes, whereSel);
        return incompatible;
    }

    private boolean isIfTypeClause(String whereSel) {
        return whereSel.startsWith("_if");
    }

    private Set<String> collectShapesIncompatibleWithSelection(Collection<Shape> shapes, String prop) {
        return shapes.stream().filter(shape -> shape.getProperty(prop).isEmpty()).map(Shape::getId).collect(Collectors.toSet());
    }

    private Set<String> collectShapesIncompatibleWithIfFilterCheck(Collection<Shape> shapes, String ifClause) {
        String checkedType = ifClause.replaceFirst("_if", "");
        HashSet<String> incompatible = new HashSet<String>();
        for (Shape shape : shapes) {
            boolean hasSuchChild = shape.getSubTypes().stream().anyMatch(subShape -> subShape.getId().equals(checkedType));
            if (hasSuchChild) continue;
            incompatible.add(shape.getId());
        }
        return incompatible;
    }

    private List<String> resolveProperties(String object, RoleAction action, SomlSchema somlSchema) {
        if (action.isPropertyRegex()) {
            return ((Shape)somlSchema.getObjects().get((Object)object)).getAllProperties().values().stream().map(PropertyShape::getName).filter(name -> name.matches(RbacUtils.toExpression(action.getProperty()))).toList();
        }
        return Collections.singletonList(action.getProperty());
    }

    private void parseActionFilter(RoleAction action, RbacFilterToParsedQueryHelper parseHelper, OperationResponse response, Set<RoleAction> invalidated) {
        if (invalidated.contains(action) || !action.hasFilter() || action.isActionRegexWithFilter()) {
            return;
        }
        try {
            Query parsedQuery = parseHelper.parseRbacFilter(action);
            if (parsedQuery == null) {
                return;
            }
            if (!parsedQuery.isValid() && !FilteredActionParser.isNotUserDefinedAction(action)) {
                response.addErrorMessage(RBAC_ROLE_ACTION_FILTER_NOT_PARSED, new Object[]{action.getContainedIn().getName(), action.getAction(), "query not valid"});
                invalidated.add(action);
            } else {
                Optional where = parsedQuery.getArguments().getWhere();
                ExpressionValue filter = null;
                if (where.isPresent()) {
                    filter = (ExpressionValue)where.get();
                }
                action.setActionFilter(new SimpleActionFilter(filter, parsedQuery.getWhereSelections()));
            }
        }
        catch (InvalidOperationException | NullPointerException ex) {
            if (!FilteredActionParser.isNotUserDefinedAction(action)) {
                if (ex.getMessage().contains(" could not be used with collection")) {
                    response.addErrorMessage(OPERAND_NOT_COMPATIBLE_WITH_COLLECTION, new Object[]{action.getContainedIn().getName(), action.getAction()});
                } else {
                    response.addErrorMessage(INVALID_SYNTAX, new Object[]{action.getContainedIn().getName(), action.getAction()});
                }
            }
            invalidated.add(action);
        }
    }
}

