/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.jwt;

import com.ontotext.rbac.jwt.Jwt;
import java.util.Collection;
import java.util.Collections;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;

public class UserWithClaims
extends User {
    private final transient Jwt jwt;

    public UserWithClaims(String username, String password, Collection<? extends GrantedAuthority> authorities, Jwt jwt) {
        super(username, password, authorities);
        this.jwt = jwt;
    }

    public String getClaimValue(String mappingKey) {
        return this.getClaimValue(mappingKey, mappingKey);
    }

    public <T> T getClaimValue(String mappingKey, Class<T> requiredType) {
        return this.getClaimValue(mappingKey, mappingKey, requiredType);
    }

    public String getClaimValue(String mappingKey, String defaultClaimKey) {
        return this.getClaimValue(mappingKey, defaultClaimKey, String.class);
    }

    public <T> T getClaimValue(String mappingKey, String defaultClaimKey, Class<T> requiredType) {
        if (this.jwt == null) {
            return null;
        }
        return this.jwt.getClaimValue(mappingKey, defaultClaimKey, requiredType);
    }

    public Collection<String> getClaimValues(String mappingKey, String defaultClaimKey) {
        if (this.jwt == null) {
            return Collections.emptyList();
        }
        return this.jwt.getClaimValue(mappingKey, defaultClaimKey, Collection.class);
    }

    public static String resolveClaimValue(String claimKey) {
        return UserWithClaims.resolveClaimValue(claimKey, String.class);
    }

    public static <T> T resolveClaimValue(String claimKey, Class<T> requiredType) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return null;
        }
        Object principal = authentication.getPrincipal();
        if (principal instanceof UserWithClaims) {
            return ((UserWithClaims)((Object)principal)).getClaimValue(claimKey, requiredType);
        }
        return null;
    }

    public static Collection<String> resolveClaimValues(String claimKey) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return Collections.emptyList();
        }
        Object principal = authentication.getPrincipal();
        if (principal instanceof UserWithClaims) {
            return ((UserWithClaims)((Object)principal)).getClaimValues(claimKey, claimKey);
        }
        return Collections.emptyList();
    }
}

