/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.http;

import com.ontotext.rbac.http.RestResources;
import com.ontotext.rbac.jwt.Jwt;
import com.ontotext.rbac.jwt.JwtClaimMapping;
import com.ontotext.rbac.jwt.JwtProcessor;
import com.ontotext.rbac.jwt.UserWithClaims;
import com.ontotext.soaas.common.logging.Loggers;
import io.jsonwebtoken.JwtException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;

public class JwtAuthRequestFilter {
    private static final Logger LOGGER = Loggers.securityLogger();
    private static final String DEFAULT_ROLE = "Default";
    private final JwtProcessor jwtProcessor;

    public JwtAuthRequestFilter(boolean enabled, String secret, String jwksUri, JwtClaimMapping claimMapping) {
        this.jwtProcessor = this.buildProcessor(enabled, secret, jwksUri, claimMapping);
    }

    private JwtProcessor buildProcessor(boolean enabled, String secret, String jwksUri, JwtClaimMapping claimMapping) {
        return new JwtProcessor.Builder().setSecurityEnabled(enabled).setSecret(secret).setJwksUri(jwksUri).setJwtClaimMapping(claimMapping).build();
    }

    public Optional<Jwt> filter(Context context) {
        if (context.enabled && !RestResources.isPublicRequest(context.requestUri)) {
            try {
                return this.jwtProcessor.resolveToken(context.authorizationHeader).map(jwt -> this.authenticate((Jwt)jwt, context.userDetails));
            }
            catch (JwtException exception) {
                String token = this.jwtProcessor.getToken(context.authorizationHeader).orElse(null);
                LOGGER.warn("JWT validation error! Token: {}. Reason: {}", (Object)token, (Object)exception.getMessage());
                LOGGER.trace("Failed token validation for {}", (Object)token, (Object)exception);
            }
        }
        return Optional.empty();
    }

    protected Jwt authenticate(Jwt jwt, Object userDetails) {
        String username = jwt.getUsername();
        if (username == null) {
            LOGGER.warn("Failed to authenticate user due to missing username in the claim: {}", (Object)jwt.getClaimMapping().getUsernameClaim());
            return jwt;
        }
        User user = this.buildUser(username, jwt);
        UsernamePasswordAuthenticationToken authToken = this.buildAuthentication(userDetails, user);
        SecurityContextHolder.getContext().setAuthentication((Authentication)authToken);
        LOGGER.debug("User {} successfully authenticated. Assigned roles are: {}", (Object)username, (Object)user.getAuthorities());
        return jwt;
    }

    @NotNull
    protected User buildUser(String username, Jwt jwt) {
        Collection<GrantedAuthority> roles = this.convertRolesToSecurityModel(jwt);
        return new UserWithClaims(username, "", roles, jwt);
    }

    @NotNull
    protected UsernamePasswordAuthenticationToken buildAuthentication(Object userDetails, User user) {
        UsernamePasswordAuthenticationToken authToken = new UsernamePasswordAuthenticationToken((Object)user, null, user.getAuthorities());
        authToken.setDetails(userDetails);
        return authToken;
    }

    protected Collection<GrantedAuthority> convertRolesToSecurityModel(Jwt jwt) {
        return jwt.getRoles().filter((? super T roles) -> !roles.isEmpty()).orElseGet(() -> Collections.singletonList(DEFAULT_ROLE)).stream().map(SimpleGrantedAuthority::new).collect(Collectors.toSet());
    }

    public static class Context {
        private boolean enabled;
        private String requestUri;
        private String authorizationHeader;
        private Object userDetails;

        public Context setEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Context setRequestUri(String requestUri) {
            this.requestUri = requestUri;
            return this;
        }

        public Context setAuthorizationHeader(String authorizationHeader) {
            this.authorizationHeader = authorizationHeader;
            return this;
        }

        public Context setUserDetails(Object userDetails) {
            this.userDetails = userDetails;
            return this;
        }
    }
}

