/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.http;

import com.google.common.collect.ImmutableSet;
import com.ontotext.models.security.Role;
import com.ontotext.rbac.ResourceUriMatcher;
import com.ontotext.rbac.SecurityContext;
import com.ontotext.rbac.exceptions.NoPermissionsException;
import com.ontotext.rbac.exceptions.NoSuchResourceException;
import com.ontotext.rbac.util.RolesProviderUtil;
import com.ontotext.soaas.common.CollectionsUtil;
import com.ontotext.soaas.common.http.RequestUtils;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class DefaultSomlRbacFilter {
    private static final String SOML_RBAC_ENDPOINT = "/soml-rbac";
    private final boolean isEnabled;
    private final Set<String> unrestrictedEndpoints;
    private final ResourceUriMatcher uriMatcher;
    private final String adminRoleName;

    private DefaultSomlRbacFilter(boolean isEnabled, Collection<String> unrestricted, ResourceUriMatcher uriMatcher, String adminRoleName) {
        this.isEnabled = isEnabled;
        this.unrestrictedEndpoints = this.getOrDefault(unrestricted);
        this.uriMatcher = uriMatcher;
        this.adminRoleName = Objects.requireNonNull(adminRoleName, "Admin role is required");
    }

    private Set<String> getOrDefault(Collection<String> unrestricted) {
        return CollectionsUtil.isNotNullOrEmpty(unrestricted) ? Set.copyOf(unrestricted) : ImmutableSet.of((Object)"/__health", (Object)"/__gtg", (Object)"/__trouble", (Object)"/__about", (Object)"/graphql", (Object)"/license", (Object[])new String[]{"/license/validate", "/actuator"});
    }

    public void filter(String requestUri, String username, SecurityContext securityContext) {
        String uri;
        block6: {
            block5: {
                uri = RequestUtils.normalizeUri((String)requestUri);
                if (!this.isEnabled) break block5;
                if (!this.unrestrictedEndpoints.stream().anyMatch(uri::startsWith)) break block6;
            }
            return;
        }
        if (!this.uriMatcher.match(uri)) {
            throw new NoSuchResourceException("The resource '" + requestUri + "' could not be found.");
        }
        Set<Role> roles = RolesProviderUtil.getRoles(securityContext);
        if (SOML_RBAC_ENDPOINT.equals(requestUri) && !this.hasAdminRole(roles)) {
            String reason = "Current endpoint can be accessed only by user with '" + this.adminRoleName + "' role.";
            throw new NoPermissionsException(username, roles, reason);
        }
    }

    private boolean hasAdminRole(Set<Role> roles) {
        return roles.stream().map(Role::getName).anyMatch(this.adminRoleName::equals);
    }

    public static class Builder {
        private boolean enabled;
        private Collection<String> unrestrictedEndpoints;
        private ResourceUriMatcher uriMatcher;
        private String adminRoleName;

        public Builder setEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder setUnrestrictedEndpoints(Collection<String> unrestrictedEndpoints) {
            this.unrestrictedEndpoints = unrestrictedEndpoints;
            return this;
        }

        public Builder setUriMatcher(ResourceUriMatcher uriMatcher) {
            this.uriMatcher = uriMatcher;
            return this;
        }

        public Builder setAdminRoleName(String adminRoleName) {
            this.adminRoleName = adminRoleName;
            return this;
        }

        public DefaultSomlRbacFilter build() {
            Objects.requireNonNull(this.uriMatcher, "The uriMatcher should not be null");
            return new DefaultSomlRbacFilter(this.enabled, this.unrestrictedEndpoints, this.uriMatcher, Objects.requireNonNullElse(StringUtils.trimToNull((String)this.adminRoleName), "SchemaRBACAdmin"));
        }
    }
}

