/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.http;

import com.google.common.net.MediaType;
import com.ontotext.rbac.exceptions.NoPermissionsException;
import java.io.IOException;
import java.io.Writer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.json.JSONArray;
import org.json.JSONObject;

public class AuthorizationErrorBuilder {
    private final int status;
    private final BiFunction<String, Exception, JSONObject> payloadBuilder;
    private Exception exception;
    private String resourceAddress;
    private Consumer<Integer> statusSetter;
    private Consumer<String> contentTypeSetter;

    private AuthorizationErrorBuilder(int status, BiFunction<String, Exception, JSONObject> payloadBuilder) {
        this.status = status;
        this.payloadBuilder = payloadBuilder;
    }

    public static AuthorizationErrorBuilder createForUnauthorized() {
        return new AuthorizationErrorBuilder(401, (adr, exc) -> {
            JSONObject responsePayload = new JSONObject().put("error", (Object)"Unauthorized").put("reason", (Object)exc.getMessage()).put("resource", adr);
            AuthorizationErrorBuilder.addUserDataIfAvailable(responsePayload, exc);
            return responsePayload;
        });
    }

    private static void addUserDataIfAvailable(JSONObject payload, Exception exception) {
        if (exception instanceof NoPermissionsException) {
            NoPermissionsException exc = (NoPermissionsException)((Object)exception);
            payload.put("user", (Object)exc.getUsername());
            payload.put("roles", (Object)new JSONArray(exc.getRolesNames()));
        }
    }

    public static AuthorizationErrorBuilder createForForbidden() {
        return new AuthorizationErrorBuilder(403, (adr, exc) -> new JSONObject().put("message", (Object)exc.getMessage()));
    }

    public AuthorizationErrorBuilder setException(Exception exception) {
        this.exception = exception;
        return this;
    }

    public AuthorizationErrorBuilder setResourceAddress(String resourceAddress) {
        this.resourceAddress = resourceAddress;
        return this;
    }

    public AuthorizationErrorBuilder setStatusSetter(Consumer<Integer> statusSetter) {
        this.statusSetter = statusSetter;
        return this;
    }

    public AuthorizationErrorBuilder setContentTypeSetter(Consumer<String> contentTypeSetter) {
        this.contentTypeSetter = contentTypeSetter;
        return this;
    }

    public JSONObject build() {
        this.statusSetter.accept(this.status);
        this.contentTypeSetter.accept(MediaType.JSON_UTF_8.withoutParameters().toString());
        return this.payloadBuilder.apply(this.resourceAddress, this.exception);
    }

    public void send(Writer writer) throws IOException {
        writer.write(this.build().toString());
    }
}

