/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler;

import com.ontotext.graphql.compiler.BaseMutationSparqlGenerator;
import com.ontotext.graphql.compiler.ConstraintGenerator;
import com.ontotext.graphql.compiler.EntityUpdateSparqlGenerator;
import com.ontotext.graphql.compiler.FilterBuilder;
import com.ontotext.graphql.compiler.FilterFactory;
import com.ontotext.graphql.compiler.RbacPartialUpdateUtils;
import com.ontotext.graphql.compiler.querymodel.AbstractQuery;
import com.ontotext.graphql.compiler.querymodel.DeleteInsertQuery;
import com.ontotext.graphql.compiler.querymodel.Iri;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.TriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.graphql.compiler.querymodel.Values;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.graphql.responder.ValidationUpdateStep;
import com.ontotext.models.Constraint;
import com.ontotext.models.Constraints;
import com.ontotext.models.Prefixes;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.QueryValidationMessage;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.DeleteMutation;
import com.ontotext.models.query.SourceLocation;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class RbacPartialDeleteValidationQueryBuilder
extends BaseMutationSparqlGenerator {
    public static final String SECURITY_RBAC_CREATE_FILTER_FAILED = "security.rbac.partialUpdate.failed";
    private boolean legacyMode;

    public RbacPartialDeleteValidationQueryBuilder(SomlSchema schema, boolean legacyMode, OperationBuilderOptions options) {
        super(schema, options, new FilterFactory());
        this.legacyMode = legacyMode;
    }

    public List<ValidationUpdateStep> toValidationSteps(DeleteMutation mutation) {
        if (mutation.getConstraints() == null || !mutation.getConstraints().hasTypeConstraints()) {
            return Collections.emptyList();
        }
        List entitiesToDelete = mutation.getChanges().stream().map(Change::getId).map(arg_0 -> ((Prefixes)this.schema.getPrefixes()).toRelativeIri(arg_0)).collect(Collectors.toList());
        if (entitiesToDelete.isEmpty()) {
            return Collections.emptyList();
        }
        DeleteInsertQuery deleteInsertQuery = new DeleteInsertQuery();
        RbacPartialUpdateUtils.addInvalidatingInsert(deleteInsertQuery, (Value)RbacPartialUpdateUtils.BLANK_NODE, this.legacyMode);
        deleteInsertQuery.getWhere().addNode((SparqlNode)new Values(EntityUpdateSparqlGenerator.ENTITY_IRI_VAR, entitiesToDelete.stream().map(Iri::new).collect(Collectors.toList())));
        TriplePatternBlock where = deleteInsertQuery.getWhere();
        RbacPartialUpdateUtils.addRootConstraints(where, this.schema, mutation.getResponseTypeInstance(), EntityUpdateSparqlGenerator.ENTITY_IRI_VAR, this.options);
        RbacPartialUpdateUtils.addConstraintsAndTrigger(where, this.getRbacConstraintsBlock(mutation.getConstraints().getTypeConstraints()), this.getMessage(mutation));
        this.addBase((AbstractQuery)deleteInsertQuery);
        this.addPrefixes((AbstractQuery)deleteInsertQuery);
        return Collections.singletonList(new ValidationUpdateStep(UUID.randomUUID().toString(), deleteInsertQuery.toSparql()));
    }

    private String getMessage(DeleteMutation mutation) {
        return QueryValidationMessage.error((SourceLocation)mutation.getLocation(), (String)SECURITY_RBAC_CREATE_FILTER_FAILED, (Object[])new Object[]{"DELETE", mutation.getResponseTypeInstance().getId(), Constraints.asUserMessage((Set)mutation.getConstraints().getTypeConstraints(), (Shape)mutation.getResponseTypeInstance())}).toSerializedString();
    }

    private TriplePatternBlock getRbacConstraintsBlock(Set<Constraint> constraints) {
        TriplePatternBlock block = new TriplePatternBlock();
        if (constraints.size() > 1) {
            LinkedList list = new LinkedList();
            new ConstraintGenerator(this.schema, this.options).addBoTypeConstraint(constraints, list, ConstraintGenerator.SparqlBuildingContext.contextBuilder().subject(EntityUpdateSparqlGenerator.ENTITY_IRI_VAR).filterGenerator(FilterFactory.filterGenerator((Var)EntityUpdateSparqlGenerator.ENTITY_IRI_VAR, (FilterBuilder)FilterFactory.getFilterBuilder((SomlSchema)this.schema, (OperationBuilderOptions)this.options, (FilterFactory)this.filterFactory))).build());
            block.addAll(list);
        } else {
            ((Optional)FilterFactory.filterGenerator((Var)EntityUpdateSparqlGenerator.ENTITY_IRI_VAR, (FilterBuilder)FilterFactory.getFilterBuilder((SomlSchema)this.schema, (OperationBuilderOptions)this.options, (FilterFactory)this.filterFactory)).apply(constraints.iterator().next().getFilter())).ifPresent(arg_0 -> ((TriplePatternBlock)block).addNode(arg_0));
        }
        return block;
    }
}

