/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.compiler;

import com.ontotext.graphql.compiler.BaseMutationSparqlGenerator;
import com.ontotext.graphql.compiler.ConstraintGenerator;
import com.ontotext.graphql.compiler.EntityUpdateSparqlGenerator;
import com.ontotext.graphql.compiler.FilterBuilder;
import com.ontotext.graphql.compiler.FilterFactory;
import com.ontotext.graphql.compiler.RbacPartialUpdateUtils;
import com.ontotext.graphql.compiler.querymodel.AbstractQuery;
import com.ontotext.graphql.compiler.querymodel.Bind;
import com.ontotext.graphql.compiler.querymodel.Bound;
import com.ontotext.graphql.compiler.querymodel.DeleteInsertQuery;
import com.ontotext.graphql.compiler.querymodel.Filter;
import com.ontotext.graphql.compiler.querymodel.Iri;
import com.ontotext.graphql.compiler.querymodel.Literal;
import com.ontotext.graphql.compiler.querymodel.NamedGraphTriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.Not;
import com.ontotext.graphql.compiler.querymodel.Optional;
import com.ontotext.graphql.compiler.querymodel.SparqlNode;
import com.ontotext.graphql.compiler.querymodel.SparqlNodeSequence;
import com.ontotext.graphql.compiler.querymodel.TriplePatternBlock;
import com.ontotext.graphql.compiler.querymodel.Value;
import com.ontotext.graphql.compiler.querymodel.Values;
import com.ontotext.graphql.compiler.querymodel.Var;
import com.ontotext.graphql.responder.UpdateStep;
import com.ontotext.graphql.responder.ValidationUpdateStep;
import com.ontotext.models.ActionFilter;
import com.ontotext.models.Constraint;
import com.ontotext.models.Constraints;
import com.ontotext.models.OperationType;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.QueryValidationMessage;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.CreateMutation;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.mutation.UpdateMutation;
import com.ontotext.models.query.SourceLocation;
import com.ontotext.soaas.common.SparqlUtil;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RbacMutationValidationQueryBuilder
extends BaseMutationSparqlGenerator {
    public static final String SECURITY_RBAC_CREATE_FILTER_FAILED = "security.rbac.create.filter.failed";
    private boolean legacyMode;

    public RbacMutationValidationQueryBuilder(SomlSchema schema, boolean legacyMode, OperationBuilderOptions options) {
        super(schema, options, new FilterFactory());
        this.legacyMode = legacyMode;
    }

    public List<UpdateStep> toPreCommitValidationSteps(Mutation mutation) {
        if (!(mutation instanceof CreateMutation) && !(mutation instanceof UpdateMutation)) {
            return Collections.emptyList();
        }
        return mutation.getChanges().stream().filter(Change::hasConstraints).map(this::toValidationStep).collect(Collectors.toList());
    }

    private UpdateStep toValidationStep(Change change) {
        return new ValidationUpdateStep(UUID.randomUUID().toString(), this.convertToSparql(change));
    }

    private String getMessage(Change change) {
        return QueryValidationMessage.error((SourceLocation)change.getSourceLocation(), (String)SECURITY_RBAC_CREATE_FILTER_FAILED, (Object[])new Object[]{change.getType(), change.getShape().getId(), Constraints.asUserMessage((Set)change.getConstraints(), (Shape)change.getShape())}).toSerializedString();
    }

    private String convertToSparql(Change change) {
        DeleteInsertQuery query = new DeleteInsertQuery();
        Var subject = new Var(change.getShape().getId().toLowerCase());
        Var trigger = RbacPartialUpdateUtils.TRIGGER;
        RbacPartialUpdateUtils.addInvalidatingInsert(query, (Value)trigger, this.legacyMode);
        LinkedList<SparqlNode> selectBlock = new LinkedList<SparqlNode>();
        this.addFetchPreviousResults(change, selectBlock, subject);
        this.addConstraints(change, subject, selectBlock, FilterFactory.filterGenerator((Var)subject, (FilterBuilder)FilterFactory.getFilterBuilder((SomlSchema)this.schema, (OperationBuilderOptions)this.options, (FilterFactory)this.filterFactory)));
        query.getWhere().addNode((SparqlNode)new Optional((SparqlNode)new SparqlNodeSequence(selectBlock)));
        TriplePatternBlock triggerBlock = this.generateTriggerBlock(subject, trigger, change);
        query.getWhere().addNode((SparqlNode)triggerBlock);
        this.addBase((AbstractQuery)query);
        this.addPrefixes((AbstractQuery)query);
        return SparqlUtil.prettyPrint((String)query.toSparql());
    }

    private TriplePatternBlock generateTriggerBlock(Var subject, Var trigger, Change change) {
        TriplePatternBlock triggerBlock = new TriplePatternBlock();
        triggerBlock.addNode((SparqlNode)new Filter((SparqlNode)new Not((SparqlNode)new Bound((SparqlNode)subject))));
        triggerBlock.addNode((SparqlNode)new Bind((SparqlNode)new Iri("http://ontotext.com/tx"), (Value)trigger));
        triggerBlock.addNode((SparqlNode)new Bind((SparqlNode)Literal.asString((String)this.getMessage(change)), (Value)RbacPartialUpdateUtils.REASON));
        return triggerBlock;
    }

    private void addConstraints(Change change, Var subject, List<SparqlNode> selectBlock, Function<ActionFilter, java.util.Optional<SparqlNode>> filterGenerator) {
        ConstraintGenerator constraintGenerator = new ConstraintGenerator(this.schema, this.options);
        for (Constraint constraint : change.getConstraints()) {
            constraintGenerator.addBoTypeConstraint(Collections.singleton(constraint), selectBlock, ConstraintGenerator.SparqlBuildingContext.contextBuilder().subject(subject).filterGenerator(filterGenerator).build());
        }
    }

    private void addFetchPreviousResults(Change change, Collection<SparqlNode> nodes, Var subject) {
        if (change.getType().equals((Object)OperationType.CREATE)) {
            Values values = new Values(subject, Collections.singletonList(new Iri((String)change.getEntityId().orElseThrow(IllegalArgumentException::new))));
            nodes.add((SparqlNode)values);
        } else if (change.getType().equals((Object)OperationType.UPDATE)) {
            this.fetchUpdatedIris(change, nodes, subject);
        }
    }

    private void fetchUpdatedIris(Change change, Collection<SparqlNode> nodes, Var subject) {
        NamedGraphTriplePatternBlock fetchBlock = EntityUpdateSparqlGenerator.createFetchPreviousResultsBlock((Var)subject, (String)change.getCollectChangesIn());
        nodes.add((SparqlNode)fetchBlock);
    }
}

