/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.proxy.http;

import com.ontotext.graphdb.proxy.http.GraphDbHttpClientProvider;
import com.ontotext.graphdb.security.AuthType;
import com.ontotext.graphdb.security.TokenManager;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.impl.client.HttpClientBuilder;

public class PingingGraphDbHttpClientProvider
extends GraphDbHttpClientProvider {
    private static final int VERY_SHORT_TIMEOUT = 1000;

    @Override
    protected HttpClientBuilder createHttpClient() {
        HttpRequestInterceptor requestAuthenticator = TokenManager.getInstance().getRequestAuthenticator(AuthType.SIGNATURE);
        return super.createHttpClient().disableAutomaticRetries().addInterceptorLast((request, context) -> {
            if (request.containsHeader("Authorization")) {
                throw new IllegalArgumentException("Not allowed to provide custom authentication for internal communication");
            }
            requestAuthenticator.process(request, context);
        });
    }

    @Override
    protected int getConnectionTimeout() {
        return 1000;
    }

    @Override
    protected int getSocketTimeout() {
        return 1000;
    }

    @Override
    protected int getMaxConnectionsPerRoute() {
        return 20;
    }

    @Override
    protected int getMaxConnectionsTotal() {
        return 200;
    }

    @Override
    protected int getSocketSoTimeout() {
        return 0;
    }
}

