/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.proxy.http;

import com.github.jsonldjava.utils.JsonUtils;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ontotext.graphdb.http.HttpClientProvider;
import com.ontotext.graphdb.proxy.ClusterUpdateCallback;
import com.ontotext.graphdb.proxy.state.NodeStatus;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClusterNodeResolver
implements Closeable {
    public static final String CLUSTER_STATUS_ENDPOINT = "/rest/cluster/group/status";
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int CHECK_INTERVAL = 7;
    private final HttpClientProvider clientProvider;
    private final ClusterUpdateCallback clusterUpdateCallback;
    private final ScheduledExecutorService scheduledExecutorService;
    private final AtomicBoolean statusCollectionActive = new AtomicBoolean();
    private final AddressChecker addressChecker;
    private final ScheduledFuture<?> scheduledFuture;

    public HttpClusterNodeResolver(HttpClientProvider clientProvider, ClusterUpdateCallback clusterUpdateCallback) {
        this.clientProvider = clientProvider;
        this.clusterUpdateCallback = clusterUpdateCallback;
        this.scheduledExecutorService = this.createExecutorService();
        this.addressChecker = new AddressChecker(clusterUpdateCallback, clientProvider, this.statusCollectionActive);
        this.scheduledFuture = this.scheduledExecutorService.scheduleAtFixedRate(this.addressChecker, 7L, 7L, TimeUnit.SECONDS);
    }

    protected ScheduledExecutorService createExecutorService() {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(2, new ThreadFactoryBuilder().setDaemon(true).setPriority(4).setNameFormat("http-cluster-status-%d").build());
        executor.setKeepAliveTime(10L, TimeUnit.MINUTES);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public void recheckNodeState(NodeStatus nodeStatus) {
        this.addressChecker.addresses.add(nodeStatus.getNode().getHttpAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeStatus> resolveNodesStatus(List<String> addresses) {
        List httpAddresses = addresses.stream().filter(address -> address.startsWith("http")).collect(Collectors.toList());
        if (httpAddresses.isEmpty()) {
            return Collections.emptyList();
        }
        if (!this.statusCollectionActive.compareAndSet(false, true)) {
            this.addressChecker.addresses.addAll(httpAddresses);
            return Collections.emptyList();
        }
        try {
            for (String nodeAddress : httpAddresses) {
                LOGGER.debug("Collecting state from {}", (Object)nodeAddress);
                List<NodeStatus> nodeStatuses = AddressChecker.collectState(nodeAddress, this.clientProvider.getHttpClient());
                if (nodeStatuses.isEmpty()) continue;
                List<NodeStatus> list = nodeStatuses;
                return list;
            }
            this.addressChecker.addresses.addAll(httpAddresses);
            List list = Collections.emptyList();
            return list;
        }
        finally {
            this.statusCollectionActive.set(false);
        }
    }

    @Override
    public void close() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        this.scheduledExecutorService.shutdown();
        try {
            this.scheduledExecutorService.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public Optional<NodeStatus> resolveLeader(Collection<String> httpAddresses) {
        LOGGER.info("Forcing leader resolution from {}", httpAddresses);
        for (String address : httpAddresses) {
            Optional<NodeStatus> leader;
            List<NodeStatus> statuses = AddressChecker.collectState(address, this.clientProvider.getHttpClient());
            if (statuses.isEmpty() || !(leader = statuses.stream().filter(NodeStatus::isLeader).findFirst()).isPresent()) continue;
            statuses.forEach(this.clusterUpdateCallback::nodeUpdated);
            return leader;
        }
        return Optional.empty();
    }

    private static class AddressChecker
    implements Runnable {
        private final AtomicBoolean statusCollectionActive;
        private final ClusterUpdateCallback clusterUpdateCallback;
        private final HttpClientProvider clientProvider;
        private final Set<String> addresses = new CopyOnWriteArraySet<String>();

        AddressChecker(ClusterUpdateCallback clusterUpdateCallback, HttpClientProvider clientProvider, AtomicBoolean statusCollectionActive) {
            this.clusterUpdateCallback = clusterUpdateCallback;
            this.clientProvider = clientProvider;
            this.statusCollectionActive = statusCollectionActive;
        }

        @Override
        public void run() {
            ArrayList<String> addressCopy = new ArrayList<String>(this.addresses);
            this.addresses.removeAll(addressCopy);
            if (addressCopy.isEmpty()) {
                return;
            }
            try {
                List<NodeStatus> result = this.resolveNodesStatus(addressCopy);
                if (result.isEmpty()) {
                    this.addresses.addAll(addressCopy);
                } else {
                    result.forEach(this.clusterUpdateCallback::nodeUpdated);
                }
            }
            catch (RuntimeException re) {
                this.addresses.addAll(addressCopy);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<NodeStatus> resolveNodesStatus(Collection<String> addresses) {
            if (!this.statusCollectionActive.compareAndSet(false, true)) {
                return Collections.emptyList();
            }
            try {
                for (String nodeAddress : addresses) {
                    if (Thread.currentThread().isInterrupted()) break;
                    List<NodeStatus> nodeStatuses = AddressChecker.collectState(nodeAddress, this.clientProvider.getHttpClient());
                    if (nodeStatuses.isEmpty()) continue;
                    List<NodeStatus> list = nodeStatuses;
                    return list;
                }
                List list = Collections.emptyList();
                return list;
            }
            finally {
                this.statusCollectionActive.set(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static List<NodeStatus> collectState(String address, CloseableHttpClient httpClient) {
            HttpGet request = new HttpGet(URI.create(address).resolve(HttpClusterNodeResolver.CLUSTER_STATUS_ENDPOINT));
            request.addHeader("Accept", "application/json");
            CloseableHttpResponse response = null;
            try {
                response = httpClient.execute((HttpUriRequest)request);
                int statusCode = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                if (statusCode == 200 && AddressChecker.isJson(entity)) {
                    InputStream content = entity.getContent();
                    Object values = JsonUtils.fromInputStream((InputStream)content, (Charset)StandardCharsets.UTF_8);
                    if (values instanceof Collection) {
                        List<NodeStatus> statuses = ((Collection)values).stream().map(value -> new NodeStatus((Map)value)).collect(Collectors.toList());
                        if (statuses.stream().anyMatch(NodeStatus::notInCluster)) {
                            List<NodeStatus> list = Collections.emptyList();
                            return list;
                        }
                        List<NodeStatus> list = statuses;
                        return list;
                    }
                } else if (statusCode != 404) {
                    String body = IOUtils.toString((InputStream)entity.getContent(), (Charset)StandardCharsets.UTF_8);
                    LOGGER.warn("Unable to read the cluster status from {}. Got HTTP {} : {}", new Object[]{address, statusCode, body});
                } else if (LOGGER.isDebugEnabled()) {
                    String body = IOUtils.toString((InputStream)entity.getContent(), (Charset)StandardCharsets.UTF_8);
                    LOGGER.debug("No cluster found at {}: {}", (Object)address, (Object)body);
                }
            }
            catch (SocketTimeoutException | ConnectTimeoutException | HttpHostConnectException httpEx) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Unable to connect to {}", (Object)httpEx.getMessage());
                } else {
                    LOGGER.warn("Unable to connect to {}", (Object)address);
                }
            }
            catch (IOException e) {
                LOGGER.warn("Unable to get cluster status from {}", (Object)address, (Object)e);
            }
            finally {
                IOUtils.closeQuietly((Closeable)response);
            }
            return Collections.emptyList();
        }

        private static boolean isJson(HttpEntity entity) {
            return Arrays.stream(entity.getContentType().getElements()).map(HeaderElement::getName).anyMatch(Predicate.isEqual("application/json"));
        }
    }
}

