/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.proxy;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.cluster.observer.grpc.PingRequest;
import com.ontotext.graphdb.cluster.observer.grpc.PingResponse;
import com.ontotext.graphdb.cluster.observer.grpc.PingServiceGrpc;
import com.ontotext.graphdb.proxy.ClusterProxyBean;
import com.ontotext.graphdb.proxy.HttpUtil;
import com.ontotext.graphdb.proxy.grpc.RpcClusterNodeResolver;
import com.ontotext.graphdb.proxy.http.PingingGraphDbHttpClientProvider;
import com.ontotext.graphdb.proxy.state.ClusterAddressResolver;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Closeable;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.web.servlet.HttpServletBean;

public class ClusterProxyHealthServlet
extends HttpServletBean {
    private static final String SUCCESS = "OK";
    private static final String INACCESSIBLE = "INACCESSIBLE";
    private static final String UNSTABLE = "UNSTABLE";
    private static final String UNHEALTHY = "UNHEALTHY";
    private static CloseableHttpClient httpClient;
    private static ExecutorService executorService;
    private static boolean firstHealthCheck;

    protected void initServletBean() {
        ClusterProxyHealthServlet.setHttpClientIfNotSet();
        ClusterProxyHealthServlet.setExecutorServiceIfNotSet();
    }

    private static void setExecutorServiceIfNotSet() {
        if (executorService == null) {
            executorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setPriority(1).setNameFormat("health-%d").build());
        }
    }

    private static void setHttpClientIfNotSet() {
        if (httpClient != null) {
            return;
        }
        httpClient = new PingingGraphDbHttpClientProvider().getHttpClient();
    }

    public void destroy() {
        try {
            if (executorService != null) {
                executorService.shutdown();
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)httpClient);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        HealthResult health = this.readClusterHealth();
        int statusCode = health.isHealthy() ? 200 : 503;
        Map<String, Object> body = health.forSerialization();
        HttpUtil.writeJsonContent(resp, statusCode, body, this.logger);
    }

    private HealthResult readClusterHealth() {
        ClusterAddressResolver clusterAddressResolver = ClusterProxyBean.getInstance().getClusterAddressResolver();
        if (firstHealthCheck) {
            clusterAddressResolver.resolveRandomNode();
            firstHealthCheck = false;
        }
        String currentRpcAddress = clusterAddressResolver.getClusterStateHolder().getCurrentRpcAddress();
        ListenableFuture<HealthResult> checkResult = this.checkIfHostsAreAccessible(clusterAddressResolver.getClusterAddresses(), currentRpcAddress);
        return (HealthResult)Futures.getUnchecked(checkResult);
    }

    private ListenableFuture<HealthResult> checkIfHostsAreAccessible(Collection<String> hosts, String selfRpcAddress) {
        List<String> httpHosts = hosts.stream().filter(host -> host.startsWith("http")).collect(Collectors.toList());
        List<String> rpcHosts = hosts.stream().filter(host -> !host.startsWith("http")).collect(Collectors.toList());
        ListenableFuture<Map<String, String>> httpInaccessibleHosts = this.checkIfHostsAreAccessible(httpHosts, this::checkHttpHost);
        ListenableFuture<Map<String, String>> rpcInaccessibleHosts = this.checkIfHostsAreAccessible(rpcHosts, host -> this.checkRpcHost((String)host, selfRpcAddress));
        return Futures.whenAllComplete(List.of(httpInaccessibleHosts, rpcInaccessibleHosts)).call(() -> {
            Map<String, String> rpcResponses;
            Map<String, String> httpResponses;
            try {
                httpResponses = (Map<String, String>)Futures.getDone((Future)httpInaccessibleHosts);
            }
            catch (ExecutionException ee) {
                httpResponses = Map.of("http", this.resolveExceptionMessage(ee, "HTTP checks"));
            }
            try {
                rpcResponses = (Map<String, String>)Futures.getDone((Future)rpcInaccessibleHosts);
            }
            catch (ExecutionException ee) {
                rpcResponses = Map.of("grpc", this.resolveExceptionMessage(ee, "gRPC checks"));
            }
            return new HealthResult(httpResponses, rpcResponses);
        }, (Executor)executorService);
    }

    private ListenableFuture<Map<String, String>> checkIfHostsAreAccessible(List<String> hosts, UnaryOperator<String> checker) {
        if (hosts.isEmpty()) {
            return Futures.immediateFuture(Collections.emptyMap());
        }
        LinkedHashMap<String, ListenableFuture> futureMap = new LinkedHashMap<String, ListenableFuture>();
        for (String host : hosts) {
            ListenableFuture future = Futures.submit(() -> {
                this.logger.debug((Object)("Checking " + host + " if accessible"));
                String result = (String)checker.apply(host);
                this.logger.debug((Object)(host + " is " + result));
                return result;
            }, (Executor)executorService);
            futureMap.put(host, future);
        }
        return Futures.whenAllComplete(futureMap.values()).call(() -> {
            LinkedHashMap responseMap = new LinkedHashMap();
            futureMap.forEach((peerAddress, future) -> responseMap.put(peerAddress, this.getFutureResult((ListenableFuture<String>)future, (String)peerAddress)));
            return responseMap;
        }, (Executor)executorService);
    }

    private String getFutureResult(ListenableFuture<String> future, String peerAddress) {
        try {
            return (String)Futures.getDone(future);
        }
        catch (ExecutionException ee) {
            return this.resolveExceptionMessage(ee, peerAddress);
        }
    }

    private String resolveExceptionMessage(ExecutionException ee, String address) {
        if (ee.getCause() != null) {
            if (ee.getCause().getMessage() != null) {
                return ee.getCause().getMessage();
            }
            if (ee.getMessage() != null) {
                return ee.getMessage();
            }
        }
        return "Unexpected problem during health check of " + address + ". Cause: " + ee.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String checkHttpHost(String host) {
        URI protocolEndpoint = URI.create(host).resolve("/protocol");
        HttpGet get = new HttpGet(protocolEndpoint);
        get.addHeader("X-GraphDB-Proxied-From", Config.getExternalUrl(null));
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);){
            if (response.getStatusLine().getStatusCode() == 200) {
                String string2 = SUCCESS;
                return string2;
            }
            String string = UNSTABLE;
            return string;
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Could not read " + String.valueOf(protocolEndpoint)), (Throwable)e);
                return INACCESSIBLE;
            }
            this.logger.warn((Object)("Could not read " + String.valueOf(protocolEndpoint) + " : " + e.getMessage()));
            return INACCESSIBLE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkRpcHost(String rpcAddress, String selfRpcAddress) {
        ManagedChannel channel = RpcClusterNodeResolver.createChannelTo(rpcAddress).build();
        try {
            PingResponse response = ((PingServiceGrpc.PingServiceBlockingStub)PingServiceGrpc.newBlockingStub((Channel)channel).withDeadlineAfter(1L, TimeUnit.SECONDS)).ping(PingRequest.newBuilder().setAddress(selfRpcAddress).build());
            if (!response.getSuccess()) {
                String string = response.getMessage();
                return string;
            }
        }
        catch (StatusRuntimeException sre) {
            this.logger.warn((Object)("Unable to communicate with a node at " + rpcAddress + " due to " + sre.getStatus().getDescription()));
            String description = sre.getStatus().getDescription();
            if (description == null) {
                String string = sre.getStatus().getCode().toString();
                return string;
            }
            if (sre.getStatus().getCode() == Status.Code.DEADLINE_EXCEEDED) {
                String string = INACCESSIBLE;
                return string;
            }
            if (sre.getStatus().getCode() == Status.Code.UNAUTHENTICATED) {
                description = description.split("\n")[0];
            }
            String string = sre.getStatus().getCode().toString() + " : " + description;
            return string;
        }
        catch (Exception ex) {
            this.logger.warn((Object)("Cluster node at " + rpcAddress + " is not accessible!"), (Throwable)ex);
            String string = INACCESSIBLE;
            return string;
        }
        finally {
            channel.shutdown();
        }
        return SUCCESS;
    }

    static {
        firstHealthCheck = true;
    }

    private static class HealthResult {
        private final Map<String, String> httpResults;
        private final Map<String, String> rpcResults;

        public HealthResult(Map<String, String> httpResults, Map<String, String> rpcResults) {
            this.httpResults = httpResults;
            this.rpcResults = rpcResults;
        }

        boolean isHealthy() {
            if (this.httpResults.isEmpty() && this.rpcResults.isEmpty()) {
                return false;
            }
            return this.isHttpHealthy() && this.isRpcHealthy();
        }

        private boolean isHttpHealthy() {
            return this.httpResults.values().stream().anyMatch(Predicate.isEqual(ClusterProxyHealthServlet.SUCCESS));
        }

        private boolean isRpcHealthy() {
            return this.rpcResults.values().stream().anyMatch(Predicate.isEqual(ClusterProxyHealthServlet.SUCCESS)) && this.rpcResults.values().stream().noneMatch(value -> value.contains(Status.Code.UNAUTHENTICATED.name()));
        }

        public Map<String, Object> forSerialization() {
            TreeMap<String, String> result = new TreeMap<String, String>(this.httpResults);
            result.putAll(this.rpcResults);
            String overallState = this.isHealthy() ? ClusterProxyHealthServlet.SUCCESS : ClusterProxyHealthServlet.UNHEALTHY;
            return Map.of("status", overallState, "health", result);
        }
    }
}

