/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.proxy;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.http.HttpClientProvider;
import com.ontotext.graphdb.http.ServletProxy;
import com.ontotext.graphdb.proxy.Options;
import com.ontotext.graphdb.proxy.http.GraphDbHttpClientProvider;
import com.ontotext.graphdb.proxy.http.PingingGraphDbHttpClientProvider;
import com.ontotext.graphdb.proxy.state.ClusterAddressResolver;
import com.ontotext.graphdb.proxy.state.ClusterStateHolder;
import com.ontotext.graphdb.proxy.state.NodeStatus;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.utils.URLEncodedUtils;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.parser.ParsedOperation;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserUtil;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpMethod;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

public class ClusterProxyBean {
    private ServletProxy servletProxy;
    private HttpClientProvider clientProvider;
    private HttpClientProvider statusCheckingClientProvider;
    private ClusterAddressResolver clusterAddressResolver;
    private int requestRetry = -1;
    private static Log logger;
    private String hosts;
    private volatile boolean shutdown = false;
    private volatile boolean initialized = false;

    public static ClusterProxyBean getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public synchronized void init() throws ServletException {
        this.setLoggerIfNotSet();
        this.setServletProxyIfNotSet();
        this.setClientProviderIfNotSet();
        this.setStatusCheckingClientProviderIfNotSet();
        this.setClusterAddressResolverIfNotSet();
        this.setRequestRetryIfNotSet();
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpServletRequest request, HttpServletResponse response, boolean requireLeader) {
        Throwable lastException;
        boolean shouldThrowExceptionIfNoLeader = ClusterProxyBean.checkShouldThrowExceptionIfNoLeader(request);
        Supplier<NodeStatus> addressResolver = this.createAddressResolver(requireLeader, shouldThrowExceptionIfNoLeader);
        int retries = this.getRequestRetry();
        do {
            String proxyUri;
            NodeStatus nodeStatus;
            if (this.shutdown) {
                logger.warn((Object)("Unable to handle request " + request.getMethod() + " " + request.getRequestURI() + " as the proxy is shutting down"));
                lastException = new RuntimeException("Proxy is shutting down!");
                break;
            }
            try {
                nodeStatus = addressResolver.get();
                proxyUri = this.getResolveDestinationAddress(request, nodeStatus);
            }
            catch (IllegalStateException e) {
                logger.error((Object)("Unable to handle request due to: " + e.getMessage()));
                try {
                    response.sendError(503, e.getMessage());
                }
                catch (IOException ex) {
                    logger.error((Object)"Could not send error to client", (Throwable)ex);
                }
                return;
            }
            catch (IllegalAccessException e) {
                logger.error((Object)("Caller tried to send proxied transaction URI to server, not part of the cluster configurations: " + e.getMessage()));
                try {
                    response.sendError(417, e.getMessage());
                }
                catch (IOException ex) {
                    logger.error((Object)"Could not send error to client", (Throwable)ex);
                }
                return;
            }
            boolean activeQuery = false;
            try {
                activeQuery = this.updateActiveQueryCounts(nodeStatus, request);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Redirecting request to %s %s %s", nodeStatus.getStatus(), request.getMethod(), proxyUri));
                }
                BinaryOperator transactionHeaderReWriter = this.servletProxy.transactionHeaderReWriter(request, servletRequest -> Config.getExternalUrl((String)servletRequest.getHeader("Referer")));
                this.getServletProxy().proxyRequestWithAuthentication(request, response, proxyUri, this.getClientProvider().getHttpClient(), transactionHeaderReWriter);
                this.getClusterAddressResolver().setAccessible(nodeStatus);
                return;
            }
            catch (ConnectException | SocketTimeoutException | ClientProtocolException hhce) {
                this.getClusterAddressResolver().markAsNotAccessible(nodeStatus);
                lastException = hhce;
                logger.warn((Object)("Could not connect to " + proxyUri + ". Retrying.."));
            }
            catch (Exception ioe) {
                logger.error((Object)("Request to " + proxyUri + " failed."), (Throwable)ioe);
                return;
            }
            finally {
                if (activeQuery) {
                    nodeStatus.decrementQueryCount();
                }
            }
        } while (--retries > 0);
        try {
            response.sendError(500, lastException.getMessage());
        }
        catch (Exception e) {
            logger.error((Object)("Request processing of " + request.getRequestURI() + " failed!"), (Throwable)e);
        }
    }

    private static boolean checkShouldThrowExceptionIfNoLeader(HttpServletRequest request) {
        String queryString;
        boolean shouldThrowExceptionIfNoLeader = request.getMethod().equals(HttpMethod.POST.name()) || request.getMethod().equals(HttpMethod.PUT.name());
        String requestURI = request.getRequestURI();
        if (request.getMethod().equals(HttpMethod.POST.name()) && (requestURI.equals("/rest/cluster/config") || requestURI.equals("/rest/cluster/httpConfig") || requestURI.equals("/rest/locations") || requestURI.equals("/rest/login") || requestURI.equals("/rest/report")) || requestURI.endsWith("/health") || request.getMethod().equals(HttpMethod.GET.name()) && requestURI.equals("/rest/cluster")) {
            shouldThrowExceptionIfNoLeader = false;
        }
        if ((queryString = request.getQueryString()) != null && !request.getRequestURI().startsWith("/rest/monitor")) {
            List params = URLEncodedUtils.parse((String)queryString, (Charset)StandardCharsets.UTF_8);
            for (NameValuePair param : params) {
                if (!"query".equals(param.getName()) || param.getValue() == null) continue;
                try {
                    ParsedOperation operation = QueryParserUtil.parseOperation((QueryLanguage)QueryLanguage.SPARQL, (String)param.getValue(), null);
                    if (!(operation instanceof ParsedQuery)) break;
                    shouldThrowExceptionIfNoLeader = false;
                }
                catch (MalformedQueryException e) {
                    logger.warn((Object)"Could not parse query due to: ", (Throwable)e);
                }
                break;
            }
        }
        if (request.getRequestURI().startsWith("/rest/monitor") && request.getRequestURI().endsWith("/operations")) {
            shouldThrowExceptionIfNoLeader = false;
        }
        return shouldThrowExceptionIfNoLeader;
    }

    @VisibleForTesting
    @NotNull
    String getResolveDestinationAddress(HttpServletRequest request, NodeStatus nodeStatus) throws IllegalAccessException {
        String transactionUri = this.servletProxy.extractProxiedTransactionUri(request);
        if (transactionUri != null) {
            int index = transactionUri.indexOf("/repositories/");
            String serverAddress = transactionUri.substring(0, index);
            if (!this.clusterAddressResolver.isValidAddressFromCluster(serverAddress)) {
                throw new IllegalAccessException(serverAddress + " is not part of the current cluster configuration.");
            }
            return transactionUri;
        }
        return nodeStatus.getHttpAddressUri().resolve(request.getRequestURI()).toString();
    }

    private boolean updateActiveQueryCounts(NodeStatus nodeStatus, HttpServletRequest request) {
        if (request.getRequestURI().startsWith("/repositories/") && !request.getRequestURI().endsWith("/statements") && "POST".equalsIgnoreCase(request.getMethod())) {
            nodeStatus.incrementQueryCount();
            return true;
        }
        return false;
    }

    private Supplier<NodeStatus> createAddressResolver(boolean requireLeader, boolean shouldThrowExceptionWhenNoLeader) {
        if (requireLeader) {
            if (shouldThrowExceptionWhenNoLeader) {
                return () -> this.getClusterAddressResolver().resolveLeaderNodeOrElseThrow();
            }
            return () -> this.getClusterAddressResolver().resolveLeaderNode();
        }
        return () -> this.getClusterAddressResolver().resolveRandomNode();
    }

    void setClusterAddressResolver(ClusterAddressResolver clusterAddressResolver) {
        this.clusterAddressResolver = clusterAddressResolver;
    }

    ClusterAddressResolver getClusterAddressResolver() {
        return this.clusterAddressResolver;
    }

    private void setClusterAddressResolverIfNotSet() throws ServletException {
        if (this.clusterAddressResolver != null) {
            return;
        }
        try {
            List<String> resolvedHosts = this.resolveHosts();
            InetSocketAddress rpcBindAddress = Options.getRpcBindAddress();
            String rpcAddress = Config.getRPCAddress();
            String hostsString = String.join((CharSequence)", ", resolvedHosts);
            logger.info((Object)("Will proxy requests to:" + hostsString));
            logger.info((Object)("Going to listen for RPC updates at: " + rpcAddress));
            this.setClusterAddressResolver(this.createClusterAddressResolver(resolvedHosts, rpcBindAddress, rpcAddress));
            logger.info((Object)"Initialization complete. Ready to accept requests.");
        }
        catch (IOException ioe) {
            throw new ServletException("Unable start RPC server due to: " + ioe.getMessage(), (Throwable)ioe);
        }
    }

    @NotNull
    protected ClusterAddressResolver createClusterAddressResolver(List<String> hosts, InetSocketAddress rpcBindAddress, String rpcAddress) throws IOException {
        return new ClusterAddressResolver(this.createClusterInfoResolver(hosts, rpcBindAddress, rpcAddress));
    }

    @NotNull
    protected ClusterStateHolder createClusterInfoResolver(List<String> hosts, InetSocketAddress rpcBindAddress, String rpcAddress) throws IOException {
        return new ClusterStateHolder(this.getStatusCheckingClientProvider(), hosts, rpcBindAddress, rpcAddress);
    }

    void setServletProxy(ServletProxy servletProxy) {
        this.servletProxy = servletProxy;
    }

    private void setServletProxyIfNotSet() {
        if (this.servletProxy == null) {
            this.setServletProxy(new ServletProxy(new MappingJackson2HttpMessageConverter()));
        }
    }

    ServletProxy getServletProxy() {
        return this.servletProxy;
    }

    void setClientProvider(HttpClientProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    private void setClientProviderIfNotSet() {
        if (this.clientProvider == null) {
            this.setClientProvider((HttpClientProvider)new GraphDbHttpClientProvider());
        }
    }

    HttpClientProvider getClientProvider() {
        return this.clientProvider;
    }

    HttpClientProvider getStatusCheckingClientProvider() {
        return this.statusCheckingClientProvider;
    }

    void setStatusCheckingClientProvider(HttpClientProvider statusCheckingClientProvider) {
        this.statusCheckingClientProvider = statusCheckingClientProvider;
    }

    private void setStatusCheckingClientProviderIfNotSet() {
        if (this.statusCheckingClientProvider == null) {
            this.setStatusCheckingClientProvider((HttpClientProvider)new PingingGraphDbHttpClientProvider());
        }
    }

    void setRequestRetry(int requestRetry) {
        this.requestRetry = requestRetry;
    }

    private void setRequestRetryIfNotSet() {
        if (this.requestRetry < 0) {
            this.setRequestRetry(Options.getRequestRetries());
        }
    }

    int getRequestRetry() {
        return this.requestRetry;
    }

    public String getHosts() {
        return this.hosts;
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    private List<String> resolveHosts() {
        if (this.getHosts() == null) {
            return Options.getHosts();
        }
        return Options.parseHosts(this.hosts);
    }

    public void setLogger(Log logger) {
        ClusterProxyBean.logger = logger;
    }

    private void setLoggerIfNotSet() {
        if (logger == null) {
            logger = LogFactory.getLog(ClusterProxyBean.class);
        }
    }

    public void shutdown() {
        this.shutdown = true;
        if (this.clientProvider != null) {
            IOUtils.closeQuietly((Closeable)this.clientProvider.getHttpClient());
        }
        if (this.statusCheckingClientProvider != null) {
            IOUtils.closeQuietly((Closeable)this.statusCheckingClientProvider.getHttpClient());
        }
        IOUtils.closeQuietly((Closeable)this.clusterAddressResolver);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @VisibleForTesting
    void reset() {
        this.shutdown();
        this.servletProxy = null;
        this.clientProvider = null;
        this.statusCheckingClientProvider = null;
        this.clusterAddressResolver = null;
        this.requestRetry = -1;
        this.hosts = null;
        this.initialized = false;
        this.shutdown = false;
    }

    private static class InstanceHolder {
        private static final ClusterProxyBean INSTANCE = new ClusterProxyBean();

        private InstanceHolder() {
        }
    }
}

