/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugin.history.collection.factored;

import com.ontotext.graphdb.plugin.history.collection.AbstractTransactionalCollectionConnection;
import com.ontotext.graphdb.plugin.history.collection.HistoryCollectionConnection;
import com.ontotext.graphdb.plugin.history.collection.HistoryCollectionIterator;
import com.ontotext.graphdb.plugin.history.collection.factored.FactoredHistoryCollection;
import com.ontotext.graphdb.plugin.history.collection.factored.FactoredHistoryCollectionIterator;

public class FactoredHistoryCollectionConnection
extends AbstractTransactionalCollectionConnection
implements HistoryCollectionConnection {
    public FactoredHistoryCollectionConnection(FactoredHistoryCollection collection) {
        super(collection);
    }

    @Override
    public boolean add(long dateTime, long s, long p, long o, long c, int status) {
        assert (s >= 0L) : "Subject must be a non-negative number";
        assert (p >= 0L) : "Predicate must be a non-negative number";
        assert (o >= 0L) : "Object must be a non-negative number";
        assert (c >= 0L) : "Context must be a non-negative number";
        assert (dateTime >= 0L) : "DateTime must be a non-negative number";
        long dateTimeElement = FactoredHistoryCollectionConnection.dateTimeElement(dateTime);
        return super.add(new long[]{FactoredHistoryCollectionConnection.dateTimeFactor(dateTime), 0L, dateTimeElement, s, p, o, c, status, dateTimeElement, s, p, o, c, status});
    }

    @Override
    public long size() {
        return this.getCollectionSize(new long[]{Long.MIN_VALUE, 0L, Long.MAX_VALUE, 0L, 0L, 0L, 0L, 0L, 0L, Long.MAX_VALUE, 0L, 0L, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE});
    }

    @Override
    public FactoredHistoryCollectionIterator get(long dateTime1, long s1, long p1, long o1, long c1, long dateTime2, long s2, long p2, long o2, long c2) {
        return new FactoredHistoryCollectionIterator(super.get(new long[]{FactoredHistoryCollectionConnection.dateTimeFactor(dateTime1), 0L, FactoredHistoryCollectionConnection.dateTimeElement(dateTime1), s1, p1, o1, c1, 0L, FactoredHistoryCollectionConnection.dateTimeFactor(dateTime2), 0L, FactoredHistoryCollectionConnection.dateTimeElement(dateTime2), s2, p2, o2, c2, Long.MAX_VALUE}));
    }

    @Override
    public HistoryCollectionIterator get(long dateTime, long s, long p, long o, long c) {
        long dateTimeFactor = FactoredHistoryCollectionConnection.dateTimeFactor(dateTime);
        long dateTimeElement = FactoredHistoryCollectionConnection.dateTimeElement(dateTime);
        return new FactoredHistoryCollectionIterator(super.get(new long[]{dateTimeFactor, 0L, dateTimeElement, s, p, o, c, 0L, dateTimeFactor, 0L, dateTimeElement, s, p, o, c, Long.MAX_VALUE}));
    }

    public static long dateTimeFactor(long dateTime) {
        return (dateTime >> 32 ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFL;
    }

    public static long dateTimeElement(long dateTime) {
        return dateTime & 0xFFFFFFFFL;
    }

    public static long dateTime(long dateTimeFactor, long dateTimeElement) {
        return (dateTimeFactor ^ 0xFFFFFFFFFFFFFFFFL) << 32 | dateTimeElement;
    }
}

