/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugin.history.collection;

import com.ontotext.graphdb.plugin.history.collection.HistoryCollectionException;
import com.ontotext.graphdb.plugin.history.collection.TransactionalCollectionConnection;
import com.ontotext.trree.big.collections.Collection;
import com.ontotext.trree.big.collections.Connection;
import com.ontotext.trree.transactions.TransactionException;
import com.ontotext.trree.transactions.TransactionUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransactionalCollectionConnection
extends Connection
implements TransactionalCollectionConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTransactionalCollectionConnection.class);

    public AbstractTransactionalCollectionConnection(Collection collection) {
        super(collection);
    }

    @Override
    public void begin() throws HistoryCollectionException {
        try {
            this.beginTransaction();
        }
        catch (TransactionException e) {
            throw new HistoryCollectionException(e);
        }
    }

    @Override
    public void commitStageOne() throws HistoryCollectionException {
        TransactionUnit unit = this.getTransactionUnit();
        try {
            unit.commit(TransactionUnit.Level.INITIAL);
            unit.commit(TransactionUnit.Level.PRECOMMIT);
        }
        catch (TransactionException e) {
            this.rollback();
            throw new HistoryCollectionException(e);
        }
    }

    @Override
    public void commitStageTwo() throws HistoryCollectionException {
        TransactionUnit unit = this.getTransactionUnit();
        try {
            unit.commit(TransactionUnit.Level.COMMIT);
        }
        catch (TransactionException e) {
            this.rollback();
            throw new HistoryCollectionException(e);
        }
        this.transactionCommitted();
    }

    @Override
    public void rollback() {
        try {
            super.rollback();
        }
        catch (TransactionException e) {
            LOGGER.warn("Could not rollback transaction", (Throwable)e);
        }
    }
}

