/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugin.history;

import com.ontotext.graphdb.plugin.history.StatementFilterBase;
import com.ontotext.graphdb.plugin.history.StatementFilterPattern;
import com.ontotext.trree.sdk.PluginException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistedStatementFilter
extends StatementFilterBase {
    private static final Logger LOG = LoggerFactory.getLogger(PersistedStatementFilter.class);

    public PersistedStatementFilter(Path filterStatementsFile) {
        if (!Files.exists(filterStatementsFile, new LinkOption[0])) {
            try {
                Files.createFile(filterStatementsFile, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new PluginException("Cannot create statements filter file", (Throwable)e);
            }
        }
        if (Files.exists(filterStatementsFile, new LinkOption[0])) {
            try (Stream<String> stream = Files.lines(filterStatementsFile);){
                stream.forEach(stPattern -> this.getStatementFilterPatterns().add(new StatementFilterPattern((String)stPattern)));
            }
            catch (IOException ioe) {
                throw new PluginException("Cannot read filter statements file " + filterStatementsFile.getFileName());
            }
        }
    }
}

