/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugin.history;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.graphdb.plugin.history.CollectionHistory;
import com.ontotext.graphdb.plugin.history.History;
import com.ontotext.graphdb.plugin.history.HistoryConnection;
import com.ontotext.graphdb.plugin.history.HistoryEditor;
import com.ontotext.graphdb.plugin.history.HistoryElement;
import com.ontotext.graphdb.plugin.history.HistoryParameters;
import com.ontotext.graphdb.plugin.history.HistoryRequestContext;
import com.ontotext.graphdb.plugin.history.PersistedStatementFilter;
import com.ontotext.graphdb.plugin.history.StatementFilterBase;
import com.ontotext.graphdb.plugin.history.StatementFilterPattern;
import com.ontotext.trree.SystemGraphs;
import com.ontotext.trree.sdk.ClearInterpreter;
import com.ontotext.trree.sdk.ClientErrorException;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.InitReason;
import com.ontotext.trree.sdk.ListPatternInterpreter;
import com.ontotext.trree.sdk.PatternInterpreter;
import com.ontotext.trree.sdk.PluginBase;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.PluginException;
import com.ontotext.trree.sdk.PluginTransactionListener;
import com.ontotext.trree.sdk.Postprocessor;
import com.ontotext.trree.sdk.Preprocessor;
import com.ontotext.trree.sdk.QueryRequest;
import com.ontotext.trree.sdk.Request;
import com.ontotext.trree.sdk.RequestContext;
import com.ontotext.trree.sdk.ShutdownReason;
import com.ontotext.trree.sdk.StatementIterator;
import com.ontotext.trree.sdk.StatementListener;
import com.ontotext.trree.sdk.UpdateInterpreter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Supplier;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;

public class HistoryPlugin
extends PluginBase
implements PluginTransactionListener,
StatementListener,
Preprocessor,
Postprocessor,
PatternInterpreter,
UpdateInterpreter,
ClearInterpreter,
ListPatternInterpreter {
    static final long EXPLICIT_GRAPH_ID = SystemGraphs.EXPLICIT_GRAPH.getId();
    static final long IMPLICIT_GRAPH_ID = SystemGraphs.IMPLICIT_GRAPH.getId();
    static final String HISTORY_FILE = "history";
    static final String TX_METADATA_DIR = "tx-metadata";
    static final String HISTORY_IRI_PREFIX = "http://www.ontotext.com/at/";
    private static final IRI HISTORY_IRI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/at/history");
    private static final IRI HISTORY_GRAPH_IRI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/at/graph");
    private static final IRI HISTORY_SUBJECT_IRI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/at/subject");
    private static final IRI HISTORY_PREDICATE_IRI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/at/predicate");
    private static final IRI HISTORY_OBJECT_IRI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/at/object");
    private static final IRI HISTORY_TIMESTAMP_IRI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/at/timestamp");
    private static final IRI HISTORY_USERNAME_IRI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/at/username");
    private static final IRI HISTORY_TX_ID_IRI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/at/transactionId");
    @Deprecated
    private static final IRI HISTORY_PARAMETERS_IRI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/at/parameters");
    private static final IRI HISTORY_LIST_WITH_FILTER_IRI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/at/listWithFilter");
    private static final IRI HISTORY_INSERT_IRI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/at/insert");
    private static final IRI HISTORY_CLEAR_IRI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/at/clearHistory");
    private static final IRI HISTORY_TRIM_BEFORE_IRI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/at/trimBefore");
    private static final IRI HISTORY_TRIM_TO_SIZE_IRI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/at/trimToSize");
    private static final IRI HISTORY_TRIM_TO_PERIOD_IRI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/at/trimToPeriod");
    private static final IRI HISTORY_ENABLED_IRI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/at/enabled");
    private static final IRI HISTORY_ADD_FILTERS_IRI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/at/addFilters");
    private static final IRI HISTORY_GET_FILTERS_IRI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/at/getFilters");
    private static final IRI HISTORY_REMOVE_FILTERS_IRI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/at/removeFilters");
    static final Literal UNKNOWN_USERNAME = SimpleValueFactory.getInstance().createLiteral("<unknown>");
    private static final String ENABLED_CONFIG_FILENAME = "enabled.txt";
    private static final String FILTER_CONFIG_FILENAME = "filter-statements.txt";
    private boolean enabled;
    private long typeId;
    private long historyId;
    private long graphId;
    private long subjectId;
    private long predicateId;
    private long objectId;
    private long timestampId;
    private long usernameId;
    private long transactionId;
    @Deprecated
    private long historyParametersId;
    private long listWithFilterId;
    private long insertId;
    private long clearHistoryId;
    private long trimBeforeId;
    private long trimToSizeId;
    private long trimToPeriodId;
    private long enabledPredicateId;
    private long addFilters;
    private long removeFilters;
    private long getFilters;
    int entityIdSize;
    History history;
    HistoryConnection historyWriteConnection;
    private StatementFilterBase statementFilter;
    private HistoryEditor historyEditor;

    private void setEnabled(boolean enabled) {
        Path enabledConfigLocation = this.getDataDir().toPath().resolve(ENABLED_CONFIG_FILENAME);
        try (FileWriter writer = new FileWriter(enabledConfigLocation.toFile());){
            writer.write(Boolean.toString(enabled));
        }
        catch (IOException e) {
            throw new PluginException("Cannot persist enabled setting", (Throwable)e);
        }
        this.enabled = enabled;
    }

    private boolean readEnabled() {
        Path enabledConfigLocation = this.getDataDir().toPath().resolve(ENABLED_CONFIG_FILENAME);
        if (Files.isRegularFile(enabledConfigLocation, new LinkOption[0])) {
            try {
                if (Files.size(enabledConfigLocation) < 1024L) {
                    return Boolean.parseBoolean(new String(Files.readAllBytes(enabledConfigLocation)));
                }
            }
            catch (IOException e) {
                throw new PluginException("Unable to read enabled setting", (Throwable)e);
            }
        }
        return false;
    }

    public String getName() {
        return HISTORY_FILE;
    }

    public void initialize(InitReason reason, PluginConnection pluginConnection) {
        Path pluginDir = this.getDataDir().toPath();
        try {
            Files.createDirectories(pluginDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new PluginException("Could not create plugin directory: " + pluginDir, (Throwable)e);
        }
        this.enabled = this.readEnabled();
        Path configLocation = pluginDir.resolve(FILTER_CONFIG_FILENAME);
        this.statementFilter = new PersistedStatementFilter(configLocation);
        this.entityIdSize = pluginConnection.getProperties().getEntityIdSize();
        this.openHistory();
        Entities e = pluginConnection.getEntities();
        this.typeId = e.put((Value)RDF.TYPE, Entities.Scope.DEFAULT);
        this.historyId = e.put((Value)HISTORY_IRI, Entities.Scope.SYSTEM);
        this.graphId = e.put((Value)HISTORY_GRAPH_IRI, Entities.Scope.SYSTEM);
        this.subjectId = e.put((Value)HISTORY_SUBJECT_IRI, Entities.Scope.SYSTEM);
        this.predicateId = e.put((Value)HISTORY_PREDICATE_IRI, Entities.Scope.SYSTEM);
        this.objectId = e.put((Value)HISTORY_OBJECT_IRI, Entities.Scope.SYSTEM);
        this.timestampId = e.put((Value)HISTORY_TIMESTAMP_IRI, Entities.Scope.SYSTEM);
        this.usernameId = e.put((Value)HISTORY_USERNAME_IRI, Entities.Scope.SYSTEM);
        this.transactionId = e.put((Value)HISTORY_TX_ID_IRI, Entities.Scope.SYSTEM);
        this.historyParametersId = e.put((Value)HISTORY_PARAMETERS_IRI, Entities.Scope.SYSTEM);
        this.listWithFilterId = e.put((Value)HISTORY_LIST_WITH_FILTER_IRI, Entities.Scope.SYSTEM);
        this.insertId = e.put((Value)HISTORY_INSERT_IRI, Entities.Scope.SYSTEM);
        this.enabledPredicateId = e.put((Value)HISTORY_ENABLED_IRI, Entities.Scope.SYSTEM);
        this.addFilters = e.put((Value)HISTORY_ADD_FILTERS_IRI, Entities.Scope.SYSTEM);
        this.removeFilters = e.put((Value)HISTORY_REMOVE_FILTERS_IRI, Entities.Scope.SYSTEM);
        this.getFilters = e.put((Value)HISTORY_GET_FILTERS_IRI, Entities.Scope.SYSTEM);
        this.clearHistoryId = e.put((Value)HISTORY_CLEAR_IRI, Entities.Scope.SYSTEM);
        this.trimBeforeId = e.put((Value)HISTORY_TRIM_BEFORE_IRI, Entities.Scope.SYSTEM);
        this.trimToSizeId = e.put((Value)HISTORY_TRIM_TO_SIZE_IRI, Entities.Scope.SYSTEM);
        this.trimToPeriodId = e.put((Value)HISTORY_TRIM_TO_PERIOD_IRI, Entities.Scope.SYSTEM);
    }

    public long[] getPredicatesToListenFor() {
        return new long[]{this.enabledPredicateId, this.addFilters, this.removeFilters, this.trimBeforeId, this.clearHistoryId, this.trimToSizeId, this.trimToPeriodId, this.transactionId};
    }

    public boolean interpretUpdate(long subject, long predicate, long object, long context, boolean isAddition, boolean isExplicit, PluginConnection pluginConnection) {
        if (predicate == this.enabledPredicateId) {
            this.setEnabled(Boolean.parseBoolean(pluginConnection.getEntities().get(object).stringValue()));
        } else if (predicate == this.addFilters || predicate == this.removeFilters) {
            String filter = pluginConnection.getEntities().get(object).stringValue();
            StatementFilterPattern statementFilterPattern = new StatementFilterPattern(filter);
            if (predicate == this.addFilters) {
                this.statementFilter.getStatementFilterPatterns().add(statementFilterPattern);
            }
            if (predicate == this.removeFilters) {
                this.statementFilter.getStatementFilterPatterns().remove(statementFilterPattern);
            }
            this.storeFilterInCache();
        } else if (predicate == this.transactionId) {
            Value value = pluginConnection.getEntities().get(object);
            this.historyWriteConnection.setCustomTxId(value);
        } else {
            if (this.historyEditor != null) {
                throw new PluginException("Only a single trim/clear history operation per transaction must be specified");
            }
            if (this.historyWriteConnection.isModified()) {
                throw new PluginException("Trim/clear history should not be mixed with adding/removing data in the same transaction");
            }
            this.historyEditor = new HistoryEditor(this);
            if (predicate == this.clearHistoryId) {
                this.historyEditor.clearHistory();
            } else if (predicate == this.trimBeforeId) {
                this.historyEditor.trimHistoryBefore((Literal)pluginConnection.getEntities().get(object));
            } else if (predicate == this.trimToSizeId) {
                this.historyEditor.trimToSize((Literal)pluginConnection.getEntities().get(object));
            } else if (predicate == this.trimToPeriodId) {
                this.historyEditor.trimHistoryToPeriod((Literal)pluginConnection.getEntities().get(object));
            } else {
                throw new PluginException("Unhandled predicate: " + pluginConnection.getEntities().get(predicate));
            }
        }
        return true;
    }

    public void shutdown(ShutdownReason reason) {
        this.closeHistory();
        this.statementFilter = null;
    }

    public void transactionStarted(PluginConnection pluginConnection) {
        assert (this.historyEditor == null) : "History editor must be null at tx start";
        this.historyWriteConnection = this.history.getConnection();
        this.historyWriteConnection.begin();
        this.historyWriteConnection.setUsername(pluginConnection.getSecurityContext().getUsername());
    }

    public void transactionCommit(PluginConnection pluginConnection) {
        this.historyWriteConnection.precommit();
        if (this.historyEditor != null) {
            this.historyEditor.precommit();
        }
    }

    public void transactionCompleted(PluginConnection pluginConnection) {
        if (this.historyEditor != null && this.historyEditor.commit()) {
            assert (this.historyWriteConnection == null);
        } else if (this.historyWriteConnection != null) {
            this.historyWriteConnection.commit();
            this.historyWriteConnection.close();
            this.historyWriteConnection = null;
        }
        this.historyEditor = null;
    }

    public void transactionAborted(PluginConnection pluginConnection) {
        if (this.historyWriteConnection != null) {
            this.historyWriteConnection.rollback();
            this.historyWriteConnection.close();
            this.historyWriteConnection = null;
        }
        if (this.historyEditor != null) {
            this.historyEditor.rollback();
            this.historyEditor = null;
        }
    }

    public void transactionAbortedByUser(PluginConnection pluginConnection) {
    }

    public boolean statementAdded(long subject, long predicate, long object, long context, boolean isExplicit, PluginConnection pluginConnection) {
        if (this.enabled && this.statementFilter.addToHistory(subject, predicate, object, context, isExplicit, pluginConnection)) {
            if (this.historyEditor != null) {
                throw new PluginException("Trim/clear history should not be mixed with adding/removing data in the same transaction");
            }
            this.historyWriteConnection.put(subject, predicate, object, context, true, isExplicit);
        }
        return false;
    }

    public boolean statementRemoved(long subject, long predicate, long object, long context, boolean isExplicit, PluginConnection pluginConnection) {
        if (this.enabled && this.statementFilter.addToHistory(subject, predicate, object, context, isExplicit, pluginConnection)) {
            if (this.historyEditor != null) {
                throw new PluginException("Trim/clear history should not be mixed with adding/removing data in the same transaction");
            }
            this.historyWriteConnection.put(subject, predicate, object, context, false, isExplicit);
        }
        return false;
    }

    public RequestContext preprocess(Request request) {
        Dataset dataset;
        HistoryRequestContext requestContext = new HistoryRequestContext(request, this.history);
        if (request instanceof QueryRequest && (dataset = ((QueryRequest)request).getDataset()) != null) {
            Set defaultGraphs = dataset.getDefaultGraphs();
            for (IRI iri : defaultGraphs) {
                long timestamp;
                String strIri;
                if (iri == null || !(strIri = iri.stringValue()).startsWith(HISTORY_IRI_PREFIX)) continue;
                requestContext.timestamp = timestamp = this.parseTimestamp(strIri.substring(HISTORY_IRI_PREFIX.length()));
                this.getLogger().debug("REQUEST TIMESTAMP: {}", (Object)timestamp);
            }
        }
        return requestContext;
    }

    public boolean shouldPostprocess(RequestContext requestContext) {
        ((HistoryRequestContext)requestContext).close();
        return false;
    }

    public BindingSet postprocess(BindingSet bindingSet, RequestContext requestContext) {
        return bindingSet;
    }

    public Iterator<BindingSet> flush(RequestContext requestContext) {
        return null;
    }

    @VisibleForTesting
    protected long parseTimestamp(String timestamp) {
        if (timestamp.length() <= 14 && timestamp.length() >= 4 && timestamp.length() % 2 == 0) {
            GregorianCalendar calendar = new GregorianCalendar();
            try {
                calendar.set(14, 999);
                calendar.set(13, this.extractNumber(timestamp, 12, 2, 0));
                calendar.set(12, this.extractNumber(timestamp, 10, 2, 0));
                calendar.set(11, this.extractNumber(timestamp, 8, 2, 0));
                calendar.set(5, this.extractNumber(timestamp, 6, 2, 1));
                calendar.set(2, this.extractNumber(timestamp, 4, 2, 1) - 1);
                calendar.set(1, this.extractNumber(timestamp, 0, 4, 1));
                return calendar.getTimeInMillis();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new ClientErrorException("Invalid timestamp for history: " + timestamp + ", must be yyyy[[[[[MM]dd]HH]mm]ss]");
    }

    private int extractNumber(String timestamp, int start, int length, int defaultValue) {
        if (timestamp.length() < start + length) {
            return defaultValue;
        }
        return Integer.parseInt(timestamp.substring(start, start + length));
    }

    public double estimate(long subject, long predicate, long object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        if (predicate == this.enabledPredicateId || predicate == this.getFilters) {
            return 0.1;
        }
        if (predicate == this.typeId) {
            return 0.1;
        }
        if (subject == 0L) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.isEntryPredicate(predicate)) {
            return 2.0;
        }
        return Double.POSITIVE_INFINITY;
    }

    public StatementIterator interpret(long subject, long predicate, long object, long context, final PluginConnection pluginConnection, RequestContext requestContext) {
        final HistoryRequestContext rc = (HistoryRequestContext)requestContext;
        if (predicate == this.getFilters) {
            SortedSet<StatementFilterPattern> statementFilterPatterns = this.statementFilter.getStatementFilterPatterns();
            ArrayList<long[]> statements = new ArrayList<long[]>();
            for (StatementFilterPattern st : statementFilterPatterns) {
                String filter = st.toString();
                if (object != 0L && !filter.equals(pluginConnection.getEntities().get(object).stringValue())) continue;
                long literal = pluginConnection.getEntities().put((Value)SimpleValueFactory.getInstance().createLiteral(st.toString()), Entities.Scope.REQUEST);
                statements.add(new long[]{subject, predicate, literal, context});
            }
            return StatementIterator.create((long[][])((long[][])statements.toArray((T[])new long[0][])));
        }
        if (predicate == this.enabledPredicateId) {
            return StatementIterator.create((long)pluginConnection.getEntities().put((Value)SimpleValueFactory.getInstance().createBNode(), Entities.Scope.REQUEST), (long)this.enabledPredicateId, (long)pluginConnection.getEntities().put((Value)SimpleValueFactory.getInstance().createLiteral(this.enabled), Entities.Scope.REQUEST), (long)0L);
        }
        if (rc.timestamp != 0L) {
            Supplier<StatementIterator> iteratorSupplier = () -> pluginConnection.getStatements().get(subject, predicate, object, context);
            if (subject > 0L || object > 0L) {
                return ((HistoryRequestContext)requestContext).getHistoryConnection().getStatements(rc.timestamp, subject, predicate, object, context, iteratorSupplier, pluginConnection);
            }
            return iteratorSupplier.get();
        }
        if (predicate == this.typeId && object == this.historyId) {
            return rc.createHistoryIterator(pluginConnection, subject);
        }
        if (this.isEntryPredicate(predicate)) {
            final long requestedSubject = subject;
            final long requestedPredicate = predicate;
            final long requestedObject = object;
            return new StatementIterator(){
                boolean hasNexted;

                public boolean next() {
                    if (this.hasNexted) {
                        return false;
                    }
                    this.hasNexted = true;
                    HistoryElement he = rc.historyList.get(requestedSubject);
                    if (he == null) {
                        return false;
                    }
                    if (requestedPredicate == HistoryPlugin.this.subjectId) {
                        this.object = he.subject;
                    } else if (requestedPredicate == HistoryPlugin.this.predicateId) {
                        this.object = he.predicate;
                    } else if (requestedPredicate == HistoryPlugin.this.objectId) {
                        this.object = he.object;
                    } else if (requestedPredicate == HistoryPlugin.this.graphId) {
                        this.object = he.context == 0L && !he.isExplicit ? IMPLICIT_GRAPH_ID : he.context;
                    } else if (requestedPredicate == HistoryPlugin.this.timestampId) {
                        this.object = pluginConnection.getEntities().put((Value)SimpleValueFactory.getInstance().createLiteral(new Date(he.dateTime)), Entities.Scope.REQUEST);
                    } else if (requestedPredicate == HistoryPlugin.this.transactionId) {
                        this.object = pluginConnection.getEntities().put((Value)rc.getTransactionId(he.dateTime), Entities.Scope.REQUEST);
                    } else if (requestedPredicate == HistoryPlugin.this.usernameId) {
                        this.object = pluginConnection.getEntities().put((Value)rc.getUsername(he.dateTime), Entities.Scope.REQUEST);
                    } else if (requestedPredicate == HistoryPlugin.this.insertId) {
                        this.object = pluginConnection.getEntities().put((Value)SimpleValueFactory.getInstance().createLiteral(he.isAdded), Entities.Scope.REQUEST);
                    }
                    return requestedObject == 0L || requestedObject == this.object;
                }

                public void close() {
                }
            };
        }
        return null;
    }

    public double estimate(long subject, long predicate, long[] object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        if (predicate == this.historyParametersId || predicate == this.listWithFilterId) {
            return 0.01;
        }
        return 0.0;
    }

    public StatementIterator interpret(long subject, long predicate, long[] object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        HistoryRequestContext rc = (HistoryRequestContext)requestContext;
        if (predicate == this.historyParametersId || predicate == this.listWithFilterId) {
            if (predicate == this.historyParametersId) {
                this.getLogger().warn("Using <{}> is deprecated since 10.4 and may be removed in a future version, see the documentation", (Object)HISTORY_PARAMETERS_IRI);
            }
            if (subject != 0L) {
                return new StatementIterator(){

                    public boolean next() {
                        IRI listPredicate = this.predicate == HistoryPlugin.this.historyParametersId ? HISTORY_PARAMETERS_IRI : HISTORY_LIST_WITH_FILTER_IRI;
                        throw new PluginException(String.format("Using :%s to filter history requires an unbound subject", listPredicate.getLocalName()));
                    }

                    public void close() {
                    }
                };
            }
            if (object.length == 0) {
                return StatementIterator.EMPTY;
            }
            subject = pluginConnection.getEntities().put((Value)SimpleValueFactory.getInstance().createBNode(), Entities.Scope.REQUEST);
            HistoryParameters params = new HistoryParameters(subject);
            try {
                if (object[0] != 0L) {
                    String fromDateTime = pluginConnection.getEntities().get(object[0]).stringValue();
                    params.fromTimeStamp = DatatypeFactory.newInstance().newXMLGregorianCalendar(fromDateTime).toGregorianCalendar().getTime().getTime();
                }
                if (object.length > 1 && object[1] != 0L) {
                    String toDateTime = pluginConnection.getEntities().get(object[1]).stringValue();
                    params.toTimeStamp = DatatypeFactory.newInstance().newXMLGregorianCalendar(toDateTime).toGregorianCalendar().getTime().getTime();
                }
                params.forSubject = object.length > 2 ? object[2] : 0L;
                params.forPredicate = object.length > 3 ? object[3] : 0L;
                params.forObject = object.length > 4 ? object[4] : 0L;
                params.forContext = object.length > 5 ? object[5] : 0L;
                return rc.createHistoryIterator(pluginConnection, params);
            }
            catch (DatatypeConfigurationException e) {
                throw new PluginException(e.getMessage());
            }
        }
        return null;
    }

    private boolean isEntryPredicate(long predicate) {
        return predicate == this.timestampId || predicate == this.subjectId || predicate == this.objectId || predicate == this.predicateId || predicate == this.graphId || predicate == this.insertId || predicate == this.transactionId || predicate == this.usernameId;
    }

    private void storeFilterInCache() {
        Path filtersConfigLocation = this.getDataDir().toPath().resolve(FILTER_CONFIG_FILENAME);
        try (FileWriter writer = new FileWriter(filtersConfigLocation.toFile());){
            for (StatementFilterPattern filter : this.statementFilter.getStatementFilterPatterns()) {
                writer.write(filter.toString() + System.lineSeparator());
            }
        }
        catch (IOException e) {
            throw new PluginException("Cannot persist filters", (Throwable)e);
        }
    }

    public void beforeClear(long context, PluginConnection pluginConnection) {
        if (this.enabled && context == 0L) {
            throw new PluginException("Clearing all statements in the repository is incompatible with collecting history. Disable collecting history if you really want to clear all data.");
        }
    }

    public void afterClear(long context, PluginConnection pluginConnection) {
        if (context == 0L) {
            this.historyEditor = new HistoryEditor(this);
            this.historyEditor.clearHistory();
        }
    }

    void closeHistory() {
        if (this.historyWriteConnection != null) {
            this.historyWriteConnection.rollback();
            this.historyWriteConnection.close();
            this.historyWriteConnection = null;
        }
        if (this.history != null) {
            this.history.close();
            this.history = null;
        }
    }

    void openHistory() {
        this.history = new CollectionHistory(this.getDataDir().toPath(), this.entityIdSize);
    }
}

