/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugin.history;

import com.ontotext.graphdb.plugin.history.HistoryElement;
import com.ontotext.graphdb.plugin.history.HistoryParameters;
import com.ontotext.graphdb.plugin.history.HistoryRequestContext;
import com.ontotext.graphdb.plugin.history.collection.CloseableIterator;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.StatementIterator;
import org.eclipse.rdf4j.model.Value;

public class HistoryIterator
extends StatementIterator {
    private final HistoryRequestContext rc;
    private final PluginConnection pluginConnection;
    private final HistoryParameters hr;
    private long logIteratorEntity;
    private long lastTimestamp;
    CloseableIterator<HistoryElement> iterator;

    HistoryIterator(PluginConnection pluginConnection, HistoryRequestContext rc, HistoryParameters hr) {
        this.pluginConnection = pluginConnection;
        this.rc = rc;
        this.hr = hr;
    }

    private void init() {
        if (this.iterator == null) {
            this.iterator = this.rc.getHistoryConnection().getHistoryElementsIterator(this.hr.fromTimeStamp, this.hr.toTimeStamp, this.hr.forSubject, this.hr.forPredicate, this.hr.forObject, this.hr.forContext);
        }
    }

    public boolean next() {
        this.init();
        if (this.iterator.hasNext()) {
            HistoryElement he = (HistoryElement)this.iterator.next();
            this.subject = this.getLogIteratorEntity(he.dateTime);
            this.rc.historyList.put(this.subject, he);
            return true;
        }
        return false;
    }

    private long getLogIteratorEntity(long timestamp) {
        if (this.hr.subject != 0L) {
            return this.hr.subject;
        }
        if (this.lastTimestamp != timestamp) {
            if (this.logIteratorEntity != 0L) {
                this.rc.historyList.remove(this.logIteratorEntity);
            }
            this.lastTimestamp = timestamp;
            this.logIteratorEntity = this.pluginConnection.getEntities().put((Value)this.rc.getTransactionId(timestamp), Entities.Scope.REQUEST);
        }
        return this.logIteratorEntity;
    }

    public void close() {
        if (this.iterator != null) {
            this.iterator.close();
            this.iterator = null;
        }
    }
}

