/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.plugin.history;

import com.ontotext.trree.sdk.PluginConnection;

public class HistoryElement
implements Comparable<HistoryElement> {
    public final long dateTime;
    public final long subject;
    public final long predicate;
    public final long object;
    public final long context;
    public final boolean isAdded;
    public final boolean isExplicit;

    public HistoryElement(long dateTime, long subject, long predicate, long object, long context, boolean isAdded, boolean isExplicit) {
        this.dateTime = dateTime;
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.context = context;
        this.isAdded = isAdded;
        this.isExplicit = isExplicit;
    }

    @Override
    public int compareTo(HistoryElement o) {
        int result = Long.compare(o.dateTime, this.dateTime);
        if (result == 0 && (result = Long.compare(this.subject, o.subject)) == 0 && (result = Long.compare(this.predicate, o.predicate)) == 0 && (result = Long.compare(this.object, o.object)) == 0 && (result = Long.compare(this.context, o.context)) == 0) {
            result = Boolean.compare(this.isExplicit, o.isExplicit);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HistoryElement)) {
            return false;
        }
        HistoryElement o = (HistoryElement)obj;
        return this.dateTime == o.dateTime && this.subject == o.subject && this.predicate == o.predicate && this.context == o.context && this.isExplicit == o.isExplicit;
    }

    public void print(String label, PluginConnection pluginConnection) {
        System.out.println(String.format("HE %s: %d %s %s %s %s %s %s", label, this.dateTime, pluginConnection.getEntities().get(this.subject), pluginConnection.getEntities().get(this.predicate), pluginConnection.getEntities().get(this.object), this.context == 0L ? null : pluginConnection.getEntities().get(this.context), this.isAdded, this.isExplicit));
    }
}

