/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.util;

import com.google.protobuf.Message;
import com.ontotext.graphdb.raft.grpc.RaftRpcConnectionException;
import com.ontotext.graphdb.raft.util.StreamingResponseObserver;
import io.grpc.stub.StreamObserver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class RpcOutputStream
extends OutputStream {
    private final StreamingResponseObserver<Message> responseObserver;
    private final ByteArrayOutputStream outputStream;
    private final int threshold;
    private final Function<byte[], Message> messageBuilder;

    public <M extends Message> RpcOutputStream(StreamObserver<M> responseObserver, int threshold, Function<byte[], M> messageBuilder) {
        this.threshold = threshold;
        this.responseObserver = responseObserver instanceof StreamingResponseObserver ? (StreamingResponseObserver<Object>)responseObserver : new StreamingResponseObserver<M>(responseObserver);
        this.outputStream = new ByteArrayOutputStream(threshold + 16);
        this.messageBuilder = messageBuilder;
    }

    @Override
    public synchronized void write(int b) {
        this.outputStream.write(b);
        if (this.outputStream.size() >= this.threshold) {
            this.flushToRpcObserver();
        }
    }

    @Override
    public void write(@NotNull byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(@NotNull byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int freeSpace = this.threshold - this.outputStream.size();
            if (freeSpace < 1) {
                this.flushToRpcObserver();
                freeSpace = this.threshold;
            }
            int writable = Math.min(freeSpace, len);
            this.outputStream.write(b, off, writable);
            off += writable;
            len -= writable;
        }
    }

    @Override
    public void flush() {
        if (this.outputStream.size() > 0) {
            this.flushToRpcObserver();
        }
    }

    @Override
    public void close() {
        this.flush();
    }

    private void flushToRpcObserver() {
        if (this.responseObserver.isCancelled()) {
            throw new RaftRpcConnectionException("Connection was cancelled");
        }
        this.responseObserver.onNext(this.messageBuilder.apply(this.outputStream.toByteArray()));
        this.outputStream.reset();
    }
}

