/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.storage.log.persistent;

import com.ontotext.graphdb.raft.grpc.NodeInfo;
import com.ontotext.graphdb.raft.storage.LogChannel;
import com.ontotext.graphdb.raft.storage.LogEntry;
import com.ontotext.graphdb.raft.storage.TransactionLogException;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.io.input.CountingInputStream;
import org.jetbrains.annotations.NotNull;

public class PersistentLogEntry
implements LogEntry {
    static final String NODE_ADDRESS_SEPARATOR = ";";
    public static final int METADATA_SIZE = 36;
    private final Path channel;
    private final long length;
    private final long offset;
    private final int fingerprintSize;
    private final long index;
    private final long term;
    private final int channelId;
    private final String fingerprint;
    private volatile LogEntry.Status status;
    private final String repositoryId;
    private final List<String> affectedChannels;
    private final boolean clearAllChannels;
    private final int affectedChannelsSize;

    public PersistentLogEntry(LogChannel channel, LogEntry.Status status, long offset, long length, int fingerprintSize, long index, long term) {
        this.channel = channel.getChannelPath();
        this.offset = offset;
        this.length = length;
        this.fingerprintSize = fingerprintSize;
        this.repositoryId = channel.getRepositoryId();
        this.status = status;
        this.index = index;
        this.term = term;
        this.channelId = channel.getChannelId();
        this.fingerprint = this.fetchFingerprint();
        this.clearAllChannels = this.fetchClearAll();
        this.affectedChannelsSize = this.fetchAffectedChannelSize();
        this.affectedChannels = this.fetchAffectedChannels();
    }

    @Override
    public InputStream getDataStream() {
        try {
            FileInputStream inputStream = new FileInputStream(this.channel.toFile());
            inputStream.skipNBytes(this.getDataOffset());
            return new BoundedInputStream((InputStream)inputStream, this.getDataLimit());
        }
        catch (IOException e) {
            throw new TransactionLogException(e);
        }
    }

    @Override
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public List<NodeInfo> getNewConfig() {
        List<NodeInfo> list;
        if (!this.isMembershipConfigEntry()) {
            return null;
        }
        FileInputStream inputStream = new FileInputStream(this.channel.toFile());
        try {
            inputStream.skipNBytes(this.getDataOffset() + 4L);
            list = this.getConfigAsList(inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new TransactionLogException(e);
            }
        }
        inputStream.close();
        return list;
    }

    @Override
    public List<NodeInfo> getOldConfig() {
        List<NodeInfo> list;
        if (!this.isMembershipConfigEntry()) {
            return null;
        }
        FileInputStream inputStream = new FileInputStream(this.channel.toFile());
        try {
            inputStream.skipNBytes(this.getDataOffset() + 4L);
            this.getConfigAsList(inputStream);
            list = this.getConfigAsList(inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new TransactionLogException(e);
            }
        }
        inputStream.close();
        return list;
    }

    @Override
    public boolean isMembershipConfigEntry() {
        boolean bl;
        if (this.channelId != -2) {
            return false;
        }
        FileInputStream inputStream = new FileInputStream(this.channel.toFile());
        try {
            inputStream.skipNBytes(this.getDataOffset());
            bl = this.readNextIntFromInputStream(inputStream) == 0;
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | BufferUnderflowException e) {
                return false;
            }
        }
        inputStream.close();
        return bl;
    }

    @Override
    public Map<String, Number> getConfigParameters() {
        Map<String, Number> map;
        if (this.isMembershipConfigEntry()) {
            return null;
        }
        FileInputStream inputStream = new FileInputStream(this.channel.toFile());
        try {
            inputStream.skipNBytes(this.getDataOffset() + 4L);
            map = this.getPropertyMap(inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new TransactionLogException(e);
            }
        }
        inputStream.close();
        return map;
    }

    private Map<String, Number> getPropertyMap(FileInputStream inputStream) throws IOException {
        int sizeOfNewGroup = this.readNextIntFromInputStream(inputStream);
        HashMap<String, Number> result = new HashMap<String, Number>();
        for (int i = 0; i < sizeOfNewGroup; ++i) {
            Number propertyValue;
            int byteSizeOfNextProperty = this.readNextIntFromInputStream(inputStream);
            String property = this.readString(inputStream, byteSizeOfNextProperty);
            if (property.equals("graphdb.raft.transaction.log.threshold.gb")) {
                propertyValue = Float.valueOf(this.readNextFloatFromInputStream(inputStream));
                result.put(property, propertyValue);
                continue;
            }
            propertyValue = this.readNextIntFromInputStream(inputStream);
            result.put(property, propertyValue);
        }
        return result;
    }

    @NotNull
    private List<NodeInfo> getConfigAsList(FileInputStream inputStream) throws IOException {
        int sizeOfNewGroup = this.readNextIntFromInputStream(inputStream);
        ArrayList<NodeInfo> result = new ArrayList<NodeInfo>();
        for (int i = 0; i < sizeOfNewGroup; ++i) {
            int byteSizeOfNewNode = this.readNextIntFromInputStream(inputStream);
            String address = this.readString(inputStream, byteSizeOfNewNode);
            String[] addresses = address.split(NODE_ADDRESS_SEPARATOR, 2);
            NodeInfo.Builder builder = NodeInfo.newBuilder();
            builder.setRpcAddress(addresses[0]);
            if (addresses.length == 2) {
                builder.setHttpAddress(addresses[1]);
            }
            result.add(builder.build());
        }
        return result;
    }

    private int readNextIntFromInputStream(FileInputStream inputStream) throws IOException {
        byte[] sizeOfNewNode = inputStream.readNBytes(4);
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.put(sizeOfNewNode);
        buffer.flip();
        return buffer.getInt();
    }

    private float readNextFloatFromInputStream(FileInputStream inputStream) throws IOException {
        byte[] sizeOfNewNode = inputStream.readNBytes(4);
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.put(sizeOfNewNode);
        buffer.flip();
        return buffer.getFloat();
    }

    @Override
    public String getRepository() {
        return this.repositoryId;
    }

    @Override
    public long getIndex() {
        return this.index;
    }

    @Override
    public LogEntry.Status getStatus() {
        return this.status;
    }

    @Override
    public int getChannel() {
        return this.channelId;
    }

    @Override
    public long getTerm() {
        return this.term;
    }

    @Override
    public List<String> getAffectedChannels() {
        if (this.getChannel() != -5) {
            throw new TransactionLogException("Log entry " + this.index + " is not a backup entry");
        }
        return this.affectedChannels;
    }

    @Override
    public boolean clearAllChannels() {
        if (this.getChannel() != -5) {
            throw new TransactionLogException("Log entry " + this.index + " is not a backup entry");
        }
        return this.clearAllChannels;
    }

    @Override
    public long getSize() {
        return this.length;
    }

    @Override
    public long getDataSize() {
        return this.getDataLimit();
    }

    @Override
    public byte getSecondaryType() {
        byte by;
        if (this.getChannel() != -8) {
            throw new TransactionLogException("Log entry " + this.index + " is not a backup entry");
        }
        FileInputStream inputStream = new FileInputStream(this.channel.toFile());
        try {
            inputStream.skipNBytes(this.getDataOffset());
            by = (byte)inputStream.read();
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new TransactionLogException(e);
            }
        }
        inputStream.close();
        return by;
    }

    @Override
    public void setStatus(LogEntry.Status status) {
        this.status = status;
    }

    private String fetchFingerprint() {
        String string;
        DataInputStream inputStream = new DataInputStream(new FileInputStream(this.channel.toFile()));
        try {
            inputStream.skipNBytes(this.getFingerprintOffset());
            string = this.readString(inputStream, this.fingerprintSize);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new TransactionLogException(e);
            }
        }
        inputStream.close();
        return string;
    }

    private boolean fetchClearAll() {
        boolean bl;
        if (this.channelId != -5) {
            return false;
        }
        FileInputStream inputStream = new FileInputStream(this.channel.toFile());
        try {
            inputStream.skipNBytes(this.getDataOffset());
            bl = inputStream.read() != 0;
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new TransactionLogException(e);
            }
        }
        inputStream.close();
        return bl;
    }

    private int fetchAffectedChannelSize() {
        int n;
        if (this.channelId != -5) {
            return 0;
        }
        DataInputStream inputStream = new DataInputStream(new FileInputStream(this.channel.toFile()));
        try {
            inputStream.skipNBytes(36L + this.offset + 1L);
            n = inputStream.readInt() + 4 + 1;
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new TransactionLogException(e);
            }
        }
        inputStream.close();
        return n;
    }

    private List<String> fetchAffectedChannels() {
        ArrayList<String> arrayList;
        if (this.channelId != -5) {
            return null;
        }
        FileInputStream stream = new FileInputStream(this.channel.toFile());
        try {
            stream.skipNBytes(36L + this.offset + 4L + 1L);
            CountingInputStream countingStream = new CountingInputStream((InputStream)stream);
            DataInputStream dataStream = new DataInputStream((InputStream)countingStream);
            ArrayList<String> affectedChannels = new ArrayList<String>();
            while (countingStream.getCount() < this.affectedChannelsSize - 5) {
                affectedChannels.add(this.readString(dataStream, dataStream.readInt()));
            }
            arrayList = affectedChannels;
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new TransactionLogException(e);
            }
        }
        stream.close();
        return arrayList;
    }

    private long getFingerprintOffset() {
        return this.offset + (this.length - (long)(8 + this.fingerprintSize));
    }

    private long getDataOffset() {
        long tmp = 36L + this.offset;
        if (this.channelId == -5) {
            tmp += (long)this.affectedChannelsSize;
        }
        return tmp;
    }

    private long getDataLimit() {
        long len = this.length - (long)(this.fingerprintSize + 36 + 8);
        if (this.channelId == -5) {
            len -= (long)this.affectedChannelsSize;
        }
        return len;
    }

    private String readString(InputStream stream, int size) throws IOException {
        byte[] node = stream.readNBytes(size);
        return new String(node, StandardCharsets.UTF_8);
    }
}

