/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.storage.log.memory;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import com.ontotext.graphdb.raft.grpc.ClusterConfigOptions;
import com.ontotext.graphdb.raft.grpc.NodeInfo;
import com.ontotext.graphdb.raft.node.concurrent.SemaphoreLock;
import com.ontotext.graphdb.raft.storage.LogEntry;
import com.ontotext.graphdb.raft.util.RaftUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;

public class InMemoryLogEntry
implements LogEntry,
Serializable {
    private final AtomicReference<LogEntry.Status> status;
    private final AtomicReference<String> fingerprint;
    private final long index;
    private final long term;
    private volatile int channel;
    private volatile long size;
    private final transient Lock updateLock;
    private final AtomicReference<String> repository;
    private volatile byte[] data;
    private volatile transient List<NodeInfo> newConfig;
    private volatile transient List<NodeInfo> oldConfig;
    private volatile Map<String, Number> configParameters;
    private volatile List<String> affectedChannels;
    private volatile boolean clearAllChannels;

    public InMemoryLogEntry(long index, long term, ByteString data, String fingerprint, int channel, long size) {
        this.index = index;
        this.term = term;
        this.fingerprint = new AtomicReference<String>(fingerprint);
        this.channel = channel;
        this.status = new AtomicReference();
        this.size = size;
        this.data = data.toByteArray();
        this.updateLock = new SemaphoreLock();
        this.repository = new AtomicReference();
    }

    public InMemoryLogEntry(long index, long term, List<NodeInfo> newConfig, List<NodeInfo> oldConfig, String fingerprint, int channel, int size) {
        this.index = index;
        this.term = term;
        this.fingerprint = new AtomicReference<String>(fingerprint);
        this.channel = channel;
        this.status = new AtomicReference();
        this.size = size;
        this.newConfig = newConfig;
        this.oldConfig = oldConfig;
        this.updateLock = new SemaphoreLock();
        this.repository = new AtomicReference();
    }

    public InMemoryLogEntry(long index, long term, ClusterConfigOptions parameters, String fingerprint, int channel, int size) {
        this.configParameters = new HashMap<String, Number>();
        this.index = index;
        this.term = term;
        this.fingerprint = new AtomicReference<String>(fingerprint);
        this.channel = channel;
        this.status = new AtomicReference();
        this.size = size;
        this.configParameters.putAll(RaftUtil.collectAllProperties(parameters));
        this.updateLock = new SemaphoreLock();
        this.repository = new AtomicReference();
    }

    @Override
    public InputStream getDataStream() {
        return new ByteArrayInputStream(this.data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendData(ByteString append) {
        this.updateLock.lock();
        try {
            byte[] appendable = append.toByteArray();
            byte[] result = Arrays.copyOf(this.data, this.data.length + appendable.length);
            System.arraycopy(append.toByteArray(), 0, result, this.data.length, appendable.length);
            this.data = result;
        }
        finally {
            this.updateLock.unlock();
        }
    }

    @Override
    public long getDataSize() {
        return this.data.length;
    }

    @Override
    public String getFingerprint() {
        return this.fingerprint.get();
    }

    @Override
    public List<NodeInfo> getNewConfig() {
        return this.newConfig;
    }

    @Override
    public List<NodeInfo> getOldConfig() {
        return this.oldConfig;
    }

    @Override
    public boolean isMembershipConfigEntry() {
        return this.newConfig != null;
    }

    @Override
    public Map<String, Number> getConfigParameters() {
        return this.configParameters;
    }

    @Override
    public String getRepository() {
        return this.repository.get();
    }

    public void setRepository(String repository) {
        this.repository.set(repository);
    }

    @Override
    public long getIndex() {
        return this.index;
    }

    @Override
    public LogEntry.Status getStatus() {
        return this.status.get();
    }

    @Override
    public void setStatus(LogEntry.Status status) {
        this.status.set(status);
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    @Override
    public long getTerm() {
        return this.term;
    }

    @Override
    public List<String> getAffectedChannels() {
        return this.affectedChannels;
    }

    @Override
    public boolean clearAllChannels() {
        return this.clearAllChannels;
    }

    public void setAffectedChannels(List<String> affectedChannels) {
        this.affectedChannels = affectedChannels;
    }

    public void setClearAllChannels(boolean clearAllChannels) {
        this.clearAllChannels = clearAllChannels;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public byte getSecondaryType() {
        return 0;
    }

    public void setSize(long size) {
        this.size = size;
    }

    @VisibleForTesting
    public void removeData() {
        this.data = new byte[0];
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint.set(fingerprint);
    }
}

