/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.node.task;

import com.ontotext.graphdb.raft.RaftException;
import com.ontotext.graphdb.raft.node.RaftTaskController;
import com.ontotext.graphdb.raft.storage.TransactionLog;
import com.ontotext.graphdb.raft.util.RaftUtil;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateSecondaryTagsTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(UpdateSecondaryTagsTask.class);
    private final RaftTaskController controller;
    private final String tag;
    private final boolean add;
    private final AtomicBoolean updated;

    public UpdateSecondaryTagsTask(RaftTaskController controller, String tag, boolean add, AtomicBoolean updated) {
        this.controller = controller;
        this.tag = tag;
        this.add = add;
        this.updated = updated;
    }

    @Override
    public void run() {
        if (this.tag.isBlank()) {
            throw new RaftException("Secondary tag is blank");
        }
        TransactionLog log = this.controller.getTransactionLog();
        OutputStream stream = log.beginTransactionRecord("SECONDARY", this.controller.getGroup().getRecoveryFlag());
        try {
            if (this.add) {
                if (this.controller.getGroup().getTagMap().containsKey(this.tag)) {
                    this.updated.set(false);
                    log.rollbackTransactionRecord("SECONDARY");
                    return;
                }
                stream.write(4);
            } else {
                if (!this.controller.getGroup().getTagMap().containsKey(this.tag)) {
                    this.updated.set(false);
                    log.rollbackTransactionRecord("SECONDARY");
                    return;
                }
                stream.write(5);
            }
            stream.write(RaftUtil.serializeString(this.tag));
            stream.flush();
        }
        catch (Exception e) {
            logger.error("Failed to pull updates from primary cluster due to: ", (Throwable)e);
            log.rollbackTransactionRecord("SECONDARY");
            if (e instanceof RaftException) {
                throw (RaftException)((Object)e);
            }
            throw new RaftException(e);
        }
    }
}

