/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.node.task;

import com.ontotext.graphdb.raft.RaftException;
import com.ontotext.graphdb.raft.node.RaftTaskController;
import com.ontotext.graphdb.raft.storage.TransactionLog;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopSecondaryModeTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(StopSecondaryModeTask.class);
    private final RaftTaskController controller;

    public StopSecondaryModeTask(RaftTaskController controller) {
        this.controller = controller;
    }

    @Override
    public void run() {
        TransactionLog log = this.controller.getTransactionLog();
        OutputStream stream = log.beginTransactionRecord("SECONDARY", this.controller.getGroup().getRecoveryFlag());
        try {
            stream.write(2);
            stream.flush();
        }
        catch (Exception e) {
            logger.error("Failed to pull updates from primary cluster due to: ", (Throwable)e);
            log.rollbackTransactionRecord("SECONDARY");
            if (e instanceof RaftException) {
                throw (RaftException)((Object)e);
            }
            throw new RaftException(e);
        }
    }
}

