/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.node.task;

import com.ontotext.graphdb.raft.grpc.AppendEntry;
import com.ontotext.graphdb.raft.grpc.AppendResponse;
import com.ontotext.graphdb.raft.grpc.RpcNodeClient;
import com.ontotext.graphdb.raft.node.Quorum;
import com.ontotext.graphdb.raft.node.RaftTaskController;
import com.ontotext.graphdb.raft.node.task.AppendTask;

public class HeartbeatTask
extends AppendTask {
    private final AppendEntry entry;

    public HeartbeatTask(RpcNodeClient rpcNode, AppendEntry entry, Quorum quorum, RaftTaskController state) {
        super(rpcNode, quorum, state);
        this.entry = entry;
    }

    @Override
    public void run() {
        this.sendHeartbeatToNode();
    }

    protected void sendHeartbeatToNode() {
        try {
            AppendResponse response;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Sending heartbeat message {} to {} ", (Object)this.entry, (Object)this.rpcNode.getAddress());
            }
            if ((response = this.rpcNode.sendTransactionRpc(this.entry, this.quorum)) == null) {
                this.logger.error("Follower {} did not respond for heartbeat with ID {}", (Object)this.rpcNode.getAddress(), (Object)this.entry.getCommitIndex());
                return;
            }
            this.processResponse(response.getTerm(), response.getMatchIndex(), response.getSuccess());
        }
        catch (Exception e) {
            this.logger.error("Node {} could not respond to heartbeat {} due to: {}", new Object[]{this.rpcNode.getAddress(), this.entry.getCommitIndex(), e.getMessage()});
            this.rpcNode.setNoConnectionStatus(e);
        }
    }

    @Override
    protected long getEntryCommitIndex() {
        return this.entry.getCommitIndex();
    }
}

