/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.node.task;

import com.ontotext.graphdb.raft.grpc.ConfigEntry;
import com.ontotext.graphdb.raft.grpc.ConfigResponse;
import com.ontotext.graphdb.raft.grpc.RaftRpcConnectionException;
import com.ontotext.graphdb.raft.grpc.RpcNodeClient;
import com.ontotext.graphdb.raft.node.Quorum;
import com.ontotext.graphdb.raft.node.RaftTaskController;
import com.ontotext.graphdb.raft.node.task.AppendTask;

public class ConfigEntryTask
extends AppendTask {
    protected final ConfigEntry entry;

    public ConfigEntryTask(RpcNodeClient rpcNode, ConfigEntry entry, Quorum quorum, RaftTaskController state) {
        super(rpcNode, quorum, state);
        this.entry = entry;
    }

    @Override
    public void run() {
        RpcNodeClient.Status status = this.rpcNode.getStatus();
        if (status == RpcNodeClient.Status.SYNCING || status == RpcNodeClient.Status.NO_CONNECTION) {
            this.logger.warn("Skip config entry to node {} due to status {}", (Object)this.rpcNode.getAddress(), (Object)status);
            return;
        }
        this.appendConfigEntryToNode();
    }

    private void appendConfigEntryToNode() {
        try {
            ConfigResponse response;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Sending message {} to {} ", (Object)this.entry, (Object)this.rpcNode.getAddress());
            }
            if ((response = this.rpcNode.sendConfigUpdateRpc(this.entry)) == null) {
                this.logger.error("Follower {} did not respond for update with ID {}", (Object)this.rpcNode.getAddress(), (Object)this.entry.getCommitIndex());
                return;
            }
            this.processResponse(response.getTerm(), response.getMatchIndex(), response.getSuccess());
        }
        catch (RaftRpcConnectionException e) {
            this.rpcNode.setNoConnectionStatus(e);
        }
    }

    @Override
    protected long getEntryCommitIndex() {
        return this.entry.getCommitIndex();
    }
}

