/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.node.task;

import com.google.protobuf.ByteString;
import com.ontotext.graphdb.raft.grpc.AppendEntry;
import com.ontotext.graphdb.raft.grpc.AppendResponse;
import com.ontotext.graphdb.raft.grpc.BackupEntry;
import com.ontotext.graphdb.raft.grpc.ConfigEntry;
import com.ontotext.graphdb.raft.grpc.ConfigResponse;
import com.ontotext.graphdb.raft.grpc.RaftRpcConnectionException;
import com.ontotext.graphdb.raft.grpc.RpcNodeClient;
import com.ontotext.graphdb.raft.node.Quorum;
import com.ontotext.graphdb.raft.node.RaftTaskController;
import com.ontotext.graphdb.raft.storage.LogEntry;
import com.ontotext.graphdb.raft.util.RaftUtil;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatchupTask
implements Runnable {
    protected static final Logger logger = LoggerFactory.getLogger(CatchupTask.class);
    protected final RpcNodeClient rpcNode;
    protected final LogEntry logEntry;
    protected final RaftTaskController state;
    protected final Quorum quorum;

    public CatchupTask(RpcNodeClient rpcNode, LogEntry entry, Quorum quorum, RaftTaskController state) {
        this.rpcNode = rpcNode;
        this.logEntry = entry;
        this.quorum = quorum;
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            boolean responseSuccess;
            long responseIndex;
            long responseTerm;
            if (logger.isDebugEnabled()) {
                logger.debug("Catching up follower {} with term {} and entry {}", new Object[]{this.rpcNode.getAddress(), this.state.getCurrentTerm(), this.logEntry.getIndex()});
            }
            if (this.logEntry.getChannel() == -2) {
                ConfigResponse response = this.rpcNode.sendConfigUpdateRpc(this.buildConfigEntry());
                if (response == null) {
                    logger.warn("No catchup response from node {}", (Object)this.rpcNode.getAddress());
                    this.rpcNode.setNoConnectionStatus(null);
                    return;
                }
                responseTerm = response.getTerm();
                responseIndex = response.getMatchIndex();
                responseSuccess = response.getSuccess();
            } else {
                AppendResponse response;
                if (this.logEntry.getChannel() == -5) {
                    try {
                        AppendResponse response2 = this.rpcNode.sendBackupStreamRpc(this.logEntry.getDataStream(), this.buildBackupEntry(), this.quorum);
                        if (response2 == null) {
                            logger.warn("No catchup response from node {}", (Object)this.rpcNode.getAddress());
                            this.rpcNode.setNoConnectionStatus(null);
                            return;
                        }
                        responseTerm = response2.getTerm();
                        responseIndex = response2.getMatchIndex();
                        responseSuccess = response2.getSuccess();
                    }
                    catch (IOException e) {
                        logger.error("Error during catching up of follower {} due to: ", (Object)this.rpcNode.getAddress(), (Object)e);
                        return;
                    }
                }
                boolean shouldStream = (long)this.state.getMessageSizeBytes() < this.logEntry.getSize();
                try {
                    AppendEntry missingAppendEntry = this.buildAppendEntry(shouldStream);
                    this.rpcNode.beginUpdate(missingAppendEntry.getCommitIndex());
                    try {
                        response = shouldStream ? this.rpcNode.sendTransactionStreamRpc(this.logEntry.getDataStream(), missingAppendEntry, this.quorum) : this.rpcNode.sendTransactionRpc(missingAppendEntry, this.quorum);
                    }
                    finally {
                        this.rpcNode.finishUpdate(missingAppendEntry.getCommitIndex());
                    }
                }
                catch (IOException e) {
                    logger.error("Error during catching up of follower {} due to: ", (Object)this.rpcNode.getAddress(), (Object)e);
                    return;
                }
                if (response == null) {
                    logger.warn("No catchup response from node {}", (Object)this.rpcNode.getAddress());
                    this.rpcNode.setNoConnectionStatus(null);
                    return;
                }
                responseTerm = response.getTerm();
                responseIndex = response.getMatchIndex();
                responseSuccess = response.getSuccess();
            }
            this.processCatchupResponse(responseTerm, responseIndex, responseSuccess);
        }
        catch (RaftRpcConnectionException e) {
            this.rpcNode.setNoConnectionStatus(e);
        }
    }

    protected void processCatchupResponse(long responseTerm, long responseMatchIndex, boolean success) {
        long currentTerm = this.state.getCurrentTerm();
        if (responseTerm == currentTerm) {
            this.rpcNode.setMatchIndex(responseMatchIndex);
            this.rpcNode.setNextIndex(responseMatchIndex + 1L);
            if (success) {
                if (responseMatchIndex == this.state.getLastLogIndex()) {
                    if (this.quorum != null) {
                        this.quorum.increment(true);
                    }
                    logger.info("Successfully caught up node {} to log index {}", (Object)this.rpcNode.getAddress(), (Object)responseMatchIndex);
                    this.rpcNode.setInSyncStatus();
                } else {
                    RaftUtil.handleOutOfSyncFollower(this.rpcNode, responseMatchIndex, this.quorum, this.state, false);
                }
            } else {
                RaftUtil.handleOutOfSyncFollower(this.rpcNode, responseMatchIndex, this.quorum, this.state, true);
            }
        } else if (responseTerm < currentTerm) {
            logger.warn("[Node {}] Stale append response with term {} when current term is {} from {}", new Object[]{this.state.getCurrentAddress(), responseTerm, currentTerm, this.rpcNode.getAddress()});
        } else {
            logger.warn("[Node {}] Received higher append response with term {} when current term is {} from {}", new Object[]{this.state.getCurrentAddress(), responseTerm, currentTerm, this.rpcNode.getAddress()});
        }
    }

    protected ConfigEntry buildConfigEntry() {
        long matchIndex = this.getMatchIndex();
        ConfigEntry.Builder builder = ConfigEntry.newBuilder().setTerm(this.state.getCurrentTerm()).setLogTerm(this.logEntry.getTerm()).setPrevLogIndex(matchIndex).setPrevLogTerm(this.state.getLogEntryTerm(matchIndex)).setCommitIndex(this.logEntry.getIndex()).setFingerprint(this.logEntry.getFingerprint()).setChannel(this.logEntry.getChannel()).setLeaderId(this.state.getCurrentAddress()).setShouldKeepCurrentGroup(this.quorum != null);
        if (this.logEntry.isMembershipConfigEntry()) {
            builder.addAllNewConfigServers(this.logEntry.getNewConfig()).addAllOldConfig(this.logEntry.getOldConfig());
        } else {
            builder.setProperties(RaftUtil.buildClusterConfigOptions(this.logEntry.getConfigParameters()));
        }
        return builder.build();
    }

    protected AppendEntry buildAppendEntry(boolean shouldStream) throws IOException {
        long matchIndex = this.getMatchIndex();
        AppendEntry.Builder builder = AppendEntry.newBuilder().setTerm(this.state.getCurrentTerm()).setLogTerm(this.logEntry.getTerm()).setPrevLogIndex(matchIndex).setPrevLogTerm(this.state.getLogEntryTerm(matchIndex)).setCommitIndex(this.logEntry.getIndex()).setFingerprint(this.logEntry.getFingerprint()).setChannel(this.logEntry.getChannel()).setLeaderId(this.state.getCurrentAddress());
        if (!shouldStream) {
            try (InputStream stream = this.logEntry.getDataStream();){
                builder.setRdfData(ByteString.readFrom((InputStream)stream));
            }
        }
        return builder.build();
    }

    protected BackupEntry buildBackupEntry() throws IOException {
        return BackupEntry.newBuilder().setData(this.buildAppendEntry(true)).addAllUpdatedChannels(this.logEntry.getAffectedChannels()).build();
    }

    private long getMatchIndex() {
        return this.logEntry.getIndex() - 1L;
    }
}

