/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.node.task;

import com.ontotext.graphdb.raft.grpc.AppendEntry;
import com.ontotext.graphdb.raft.grpc.AppendResponse;
import com.ontotext.graphdb.raft.grpc.RpcNodeClient;
import com.ontotext.graphdb.raft.node.Quorum;
import com.ontotext.graphdb.raft.node.RaftTaskController;
import com.ontotext.graphdb.raft.node.task.AppendTask;
import java.io.InputStream;

public class AppendEntryTask
extends AppendTask {
    protected final AppendEntry entry;
    protected final InputStream dataStream;

    public AppendEntryTask(RpcNodeClient rpcNode, AppendEntry entry, InputStream dataStream, Quorum quorum, RaftTaskController state) {
        super(rpcNode, quorum, state);
        this.entry = entry;
        this.dataStream = dataStream;
    }

    @Override
    public void run() {
        RpcNodeClient.Status status = this.rpcNode.getStatus();
        if (status == RpcNodeClient.Status.SYNCING || status == RpcNodeClient.Status.NO_CONNECTION) {
            this.logger.warn("Skip append entry {} to node {} due to status {}", new Object[]{this.entry.getCommitIndex(), this.rpcNode.getAddress(), status});
            if (this.quorum != null) {
                this.quorum.incrementStart();
            }
            return;
        }
        if (this.dataStream == null) {
            this.appendEntryToNode();
        } else {
            this.appendStreamingEntryToNode();
        }
    }

    private void appendEntryToNode() {
        try {
            AppendResponse response;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Sending message {} to {} ", (Object)this.entry.getCommitIndex(), (Object)this.rpcNode.getAddress());
            }
            this.rpcNode.beginUpdate(this.entry.getCommitIndex());
            try {
                response = this.rpcNode.sendTransactionRpc(this.entry, this.quorum);
            }
            finally {
                this.rpcNode.finishUpdate(this.entry.getCommitIndex());
            }
            if (response == null) {
                this.logger.error("Follower {} did not respond for update with ID {}", (Object)this.rpcNode.getAddress(), (Object)this.entry.getCommitIndex());
                return;
            }
            this.processResponse(response.getTerm(), response.getMatchIndex(), response.getSuccess());
        }
        catch (Exception e) {
            this.logger.error("Error occurred during entry {} replication to node {} due to: ", new Object[]{this.entry.getCommitIndex(), this.rpcNode.getAddress(), e});
            this.rpcNode.setNoConnectionStatus(e);
        }
    }

    private void appendStreamingEntryToNode() {
        try {
            AppendResponse response;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Sending streaming message {} to {} ", (Object)this.entry.getCommitIndex(), (Object)this.rpcNode.getAddress());
            }
            this.rpcNode.beginUpdate(this.entry.getCommitIndex());
            try {
                response = this.rpcNode.sendTransactionStreamRpc(this.dataStream, this.entry, this.quorum);
            }
            finally {
                this.rpcNode.finishUpdate(this.entry.getCommitIndex());
            }
            if (response == null) {
                this.logger.error("Follower {} did not respond for update with ID {}", (Object)this.rpcNode.getAddress(), (Object)this.entry.getCommitIndex());
                return;
            }
            this.processResponse(response.getTerm(), response.getMatchIndex(), response.getSuccess());
        }
        catch (Exception e) {
            this.logger.error("Error occurred during stream entry {} replication to node {} due to: ", new Object[]{this.entry.getCommitIndex(), this.rpcNode.getAddress(), e});
            this.rpcNode.setNoConnectionStatus(e);
        }
    }

    @Override
    protected long getEntryCommitIndex() {
        return this.entry.getCommitIndex();
    }
}

