/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.node.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.StampedLock;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeReadWriteLock
implements ReadWriteLock {
    private static final Logger logger = LoggerFactory.getLogger(NodeReadWriteLock.class);
    protected final StampedLock stampedLock;
    private final LongAdder readerIngress = new LongAdder();
    private final LongAdder readerEgress = new LongAdder();
    private final Lock staticWriteLock;

    public NodeReadWriteLock() {
        this.stampedLock = new StampedLock();
        this.staticWriteLock = new StaticWriteLock();
    }

    @Override
    @NotNull
    public Lock readLock() {
        return new NodeReadLock();
    }

    @Override
    @NotNull
    public Lock writeLock() {
        return new NodeWriteLock();
    }

    public Lock staticWriteLock() {
        return this.staticWriteLock;
    }

    private class StaticWriteLock
    extends NodeWriteLock {
        private volatile boolean hasLocked;

        private StaticWriteLock() {
        }

        @Override
        public void lock() {
            NodeReadWriteLock.this.stampedLock.writeLock();
            while (!Thread.currentThread().isInterrupted()) {
                long ingressSum;
                long egressSum = NodeReadWriteLock.this.readerEgress.sum();
                if (egressSum == (ingressSum = NodeReadWriteLock.this.readerIngress.sum())) {
                    this.hasLocked = true;
                    return;
                }
                Thread.onSpinWait();
            }
            logger.warn("Thread interrupted");
            NodeReadWriteLock.this.stampedLock.asWriteLock().unlock();
        }

        @Override
        public void unlock() {
            if (this.hasLocked) {
                NodeReadWriteLock.this.stampedLock.asWriteLock().unlock();
                this.hasLocked = false;
            } else {
                logger.warn("Node static write lock was not acquired by this thread");
            }
        }
    }

    protected class NodeReadLock
    implements Lock {
        protected volatile boolean hasLocked;

        protected NodeReadLock() {
        }

        @Override
        public void lock() {
            while (!Thread.currentThread().isInterrupted()) {
                NodeReadWriteLock.this.readerIngress.increment();
                if (!NodeReadWriteLock.this.stampedLock.isWriteLocked()) {
                    this.hasLocked = true;
                    return;
                }
                NodeReadWriteLock.this.readerEgress.increment();
                while (NodeReadWriteLock.this.stampedLock.isWriteLocked() && !Thread.currentThread().isInterrupted()) {
                    Thread.onSpinWait();
                }
            }
            logger.warn("Read lock acquisition interrupted");
        }

        @Override
        public void unlock() {
            if (this.hasLocked) {
                NodeReadWriteLock.this.readerEgress.increment();
                this.hasLocked = false;
            } else {
                logger.warn("Node read lock was not acquired by this thread");
            }
        }

        @Override
        public void lockInterruptibly() {
            throw new UnsupportedOperationException("Node Read Lock does not support this operation");
        }

        @Override
        public boolean tryLock() {
            throw new UnsupportedOperationException("Node Read Lock does not support this operation");
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) {
            throw new UnsupportedOperationException("Node Read Lock does not support this operation");
        }

        @Override
        @NotNull
        public Condition newCondition() {
            throw new UnsupportedOperationException("Node Read Lock does not support this operation");
        }
    }

    private class NodeWriteLock
    implements Lock {
        private volatile boolean hasLocked = false;

        NodeWriteLock() {
        }

        @Override
        public void lock() {
            NodeReadWriteLock.this.stampedLock.writeLock();
            while (!Thread.currentThread().isInterrupted()) {
                long ingressSum;
                long egressSum = NodeReadWriteLock.this.readerEgress.sum();
                if (egressSum == (ingressSum = NodeReadWriteLock.this.readerIngress.sum())) {
                    this.hasLocked = true;
                    return;
                }
                Thread.onSpinWait();
            }
            logger.warn("Write lock acquisition interrupted");
            NodeReadWriteLock.this.stampedLock.asWriteLock().unlock();
        }

        @Override
        public void unlock() {
            if (this.hasLocked) {
                NodeReadWriteLock.this.stampedLock.asWriteLock().unlock();
                this.hasLocked = false;
            } else {
                logger.warn("Node write lock was not acquired by this thread");
            }
        }

        @Override
        public void lockInterruptibly() {
            throw new UnsupportedOperationException("Node Write Lock does not support this operation");
        }

        @Override
        public boolean tryLock() {
            throw new UnsupportedOperationException("Node Write Lock does not support this operation");
        }

        @Override
        public boolean tryLock(long time, @NotNull TimeUnit unit) {
            long startTime = System.currentTimeMillis();
            long threshold = TimeUnit.MILLISECONDS.convert(time, unit);
            long writeLocked = 0L;
            while (System.currentTimeMillis() - startTime < threshold) {
                writeLocked = NodeReadWriteLock.this.stampedLock.tryWriteLock();
                if (writeLocked == 0L) continue;
                while (System.currentTimeMillis() - startTime < threshold) {
                    long ingressSum;
                    long egressSum = NodeReadWriteLock.this.readerEgress.sum();
                    if (egressSum == (ingressSum = NodeReadWriteLock.this.readerIngress.sum())) {
                        return true;
                    }
                    Thread.onSpinWait();
                }
            }
            if (writeLocked != 0L) {
                NodeReadWriteLock.this.stampedLock.asWriteLock().unlock();
            }
            return false;
        }

        @Override
        @NotNull
        public Condition newCondition() {
            throw new UnsupportedOperationException("Node Write Lock does not support this operation");
        }
    }
}

