/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.node.concurrent;

import com.ontotext.graphdb.raft.node.Quorum;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public class FutureQuorum
implements Quorum {
    private final Queue<Future<?>> tasks;
    private final AtomicInteger successful;
    private final AtomicInteger failed;
    private final AtomicInteger started;
    private int quorumThreshold;
    private int size;
    private boolean total;

    public FutureQuorum(int size) {
        this.size = size++;
        this.tasks = new ConcurrentLinkedDeque();
        this.successful = new AtomicInteger(0);
        this.failed = new AtomicInteger(0);
        this.started = new AtomicInteger(0);
        this.quorumThreshold = (int)Math.round((double)size / 2.0);
    }

    @Override
    public void clear() {
        this.tasks.clear();
        this.successful.set(0);
        this.failed.set(0);
        this.started.set(0);
    }

    @Override
    public void setTotal(boolean total) {
        this.total = total;
    }

    @Override
    public boolean getTotal() {
        return this.total;
    }

    @Override
    public void addTask(Future<?> task) {
        this.tasks.add(task);
    }

    @Override
    public void await() {
        while (!(this.tasks.isEmpty() || this.hasReachedFailedQuorum() || this.hasReachedSuccessQuorum())) {
            this.tasks.removeIf(Future::isDone);
            if (this.tasks.isEmpty()) break;
            Thread.onSpinWait();
        }
    }

    @Override
    public void awaitStart() {
        while (!this.tasks.isEmpty() && !this.hasReachedStartQuorum()) {
            this.tasks.removeIf(Future::isDone);
            if (this.tasks.isEmpty()) break;
            Thread.onSpinWait();
        }
    }

    @Override
    public void awaitAll() {
        while (!this.tasks.isEmpty() || !this.hasReachedTotalSuccessQuorum() || this.failed.get() == 0) {
            this.tasks.removeIf(Future::isDone);
            if (this.tasks.isEmpty()) break;
            Thread.onSpinWait();
        }
    }

    @Override
    public void increment(boolean success) {
        if (success) {
            this.successful.incrementAndGet();
        } else {
            this.failed.incrementAndGet();
        }
    }

    @Override
    public void incrementStart() {
        this.started.incrementAndGet();
    }

    @Override
    public void fail() {
        this.failed.set(this.quorumThreshold);
    }

    @Override
    public Quorum.State getState() {
        boolean isFailed;
        boolean isSuccessful;
        boolean bl = isSuccessful = this.total ? this.hasReachedTotalSuccessQuorum() : this.hasReachedSuccessQuorum();
        boolean bl2 = this.total ? this.failed.get() > 0 : (isFailed = this.hasReachedFailedQuorum());
        if (isSuccessful) {
            return Quorum.State.SUCCESSFUL;
        }
        if (isFailed) {
            return Quorum.State.UNSUCCESSFUL;
        }
        return Quorum.State.NOT_REACHED;
    }

    @Override
    public void setSize(int newSize) {
        if (newSize != this.size) {
            this.clear();
            this.size = newSize++;
            this.quorumThreshold = (int)Math.round((double)newSize / 2.0);
        }
    }

    private boolean hasReachedSuccessQuorum() {
        return this.successful.get() >= this.quorumThreshold;
    }

    private boolean hasReachedTotalSuccessQuorum() {
        return this.successful.get() == this.size;
    }

    private boolean hasReachedFailedQuorum() {
        return this.failed.get() >= this.quorumThreshold;
    }

    private boolean hasReachedStartQuorum() {
        return this.started.get() >= this.size;
    }
}

