/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.node;

import com.ontotext.graphdb.raft.ClusterGroup;
import com.ontotext.graphdb.raft.NodeState;
import com.ontotext.graphdb.raft.grpc.NodeInfo;
import com.ontotext.graphdb.raft.grpc.RpcNodeClient;
import com.ontotext.graphdb.raft.node.Quorum;
import com.ontotext.graphdb.raft.node.QuorumCache;
import com.ontotext.graphdb.raft.node.concurrent.SemaphoreLock;
import com.ontotext.graphdb.raft.storage.LogEntry;
import com.ontotext.graphdb.raft.storage.TransactionLog;
import com.ontotext.graphdb.raft.storage.TransactionLogException;
import com.ontotext.graphdb.raft.util.RaftUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;

public class RaftTaskController {
    private final LongSupplier currentTerm;
    private final Consumer<Long> stepDown;
    private final ClusterGroup group;
    private final AtomicReference<NodeState> state;
    private final Supplier<ScheduledExecutorService> executorServiceSupplier;
    private final Lock responseLock;
    private final QuorumCache cache;
    private final OutOfSyncHook hook;
    private final BiFunction<String, String, Boolean> fingerprintsComparator;

    public RaftTaskController(LongSupplier currentTerm, Consumer<Long> stepDown, OutOfSyncHook hook, ClusterGroup group, AtomicReference<NodeState> state, Supplier<ScheduledExecutorService> executorServiceSupplier, QuorumCache cache, BiFunction<String, String, Boolean> fingerprintsComparator) {
        this.currentTerm = currentTerm;
        this.stepDown = stepDown;
        this.hook = hook;
        this.group = group;
        this.state = state;
        this.executorServiceSupplier = executorServiceSupplier;
        this.cache = cache;
        this.responseLock = new SemaphoreLock();
        this.fingerprintsComparator = fingerprintsComparator;
    }

    public ClusterGroup getGroup() {
        return this.group;
    }

    public long getCurrentTerm() {
        return this.currentTerm.getAsLong();
    }

    public void stepDown(long term) {
        this.stepDown.accept(term);
    }

    public String getCurrentAddress() {
        return this.group.getCurrentAddress();
    }

    public NodeState getNodeState() {
        return this.state.get();
    }

    public Future<?> submitTask(Runnable task) {
        return this.executorServiceSupplier.get().submit(task);
    }

    public Future<?> scheduleTaskInMs(Runnable task, int milliseconds) {
        return this.executorServiceSupplier.get().schedule(task, (long)milliseconds, TimeUnit.MILLISECONDS);
    }

    public long getLatestSnapshotIndex() {
        return this.group.getStateMachine().getLatestSnapshotIndex();
    }

    public Iterable<RpcNodeClient> getRpcNodes() {
        return this.group;
    }

    public Lock getResponseLock() {
        return this.responseLock;
    }

    public TransactionLog getTransactionLog() {
        return this.group.getTransactionLog();
    }

    public long getLastLogIndex() {
        return this.group.getTransactionLog().getLastLogIndex();
    }

    public long getLastLogTerm() {
        return this.group.getTransactionLog().getLastLogTerm();
    }

    public LogEntry getLogEntry(long entryId) {
        return this.group.getTransactionLog().fetchLogEntry(entryId);
    }

    public long getLogEntryTerm(long entryId) {
        return this.group.getTransactionLog().getLogEntryTerm(entryId);
    }

    public int getMessageSizeBytes() {
        return this.group.getMessageSizeBytes();
    }

    public int getVerificationTimeout() {
        return this.group.getVerificationTimeout();
    }

    public void updateClusterGroup(List<NodeInfo> oldConfig, List<NodeInfo> newConfig) {
        RaftUtil.updateClusterGroup(oldConfig, newConfig, this.group);
    }

    public void rollbackClusterGroupUpdate(List<NodeInfo> oldConfig, List<NodeInfo> newConfig) {
        RaftUtil.rollbackClusterGroupUpdate(oldConfig, newConfig, this.group);
    }

    public void updateClusterGroup(Map<String, Number> parameters) {
        this.group.updateProperties(parameters);
    }

    public void releaseQuorum(Quorum quorum) {
        this.cache.releaseQuorum(quorum);
    }

    public void applyTruncateToMachine(LogEntry entry) {
        if (entry.getChannel() != -6) {
            throw new TransactionLogException("Could not truncate log as entry channel is: " + entry.getChannel());
        }
        this.group.getStateMachine().readLock();
        try {
            this.group.getStateMachine().apply(entry);
        }
        finally {
            this.group.getStateMachine().readUnlock();
        }
    }

    public void goOutOfSync() {
        this.hook.goOutOfSync();
    }

    public boolean areFingerprintsEqual(String actual, String another) {
        return this.fingerprintsComparator.apply(actual, another);
    }

    public static interface OutOfSyncHook {
        public void goOutOfSync();
    }
}

