/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.grpc;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.MapFieldReflectionAccessor;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import com.ontotext.graphdb.raft.grpc.ClusterServerProto;
import com.ontotext.graphdb.raft.grpc.RecoveryStateOperation;
import com.ontotext.graphdb.raft.grpc.RecoveryStateOperationOrBuilder;
import com.ontotext.graphdb.raft.grpc.StatusResponseOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public final class StatusResponse
extends GeneratedMessageV3
implements StatusResponseOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int ENDPOINT_FIELD_NUMBER = 1;
    private volatile Object endpoint_ = "";
    public static final int STATUS_FIELD_NUMBER = 2;
    private int status_ = 0;
    public static final int TERM_FIELD_NUMBER = 3;
    private long term_ = 0L;
    public static final int LASTLOGINDEX_FIELD_NUMBER = 4;
    private long lastLogIndex_ = 0L;
    public static final int LASTLOGTERM_FIELD_NUMBER = 5;
    private long lastLogTerm_ = 0L;
    public static final int FINGERPRINT_FIELD_NUMBER = 6;
    private volatile Object fingerprint_ = "";
    public static final int SYNCSTATUS_FIELD_NUMBER = 7;
    private MapField<String, String> syncStatus_;
    public static final int RECOVERYSTATE_FIELD_NUMBER = 8;
    private RecoveryStateOperation recoveryState_;
    public static final int TOPOLOGYSTATUS_FIELD_NUMBER = 9;
    private ClusterTopologyStatus topologyStatus_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final StatusResponse DEFAULT_INSTANCE = new StatusResponse();
    private static final Parser<StatusResponse> PARSER = new AbstractParser<StatusResponse>(){

        public StatusResponse parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = StatusResponse.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private StatusResponse(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private StatusResponse() {
        this.endpoint_ = "";
        this.status_ = 0;
        this.fingerprint_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new StatusResponse();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return ClusterServerProto.internal_static_cluster_StatusResponse_descriptor;
    }

    protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
        switch (number) {
            case 7: {
                return this.internalGetSyncStatus();
            }
        }
        throw new RuntimeException("Invalid map field number: " + number);
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return ClusterServerProto.internal_static_cluster_StatusResponse_fieldAccessorTable.ensureFieldAccessorsInitialized(StatusResponse.class, Builder.class);
    }

    @Override
    public String getEndpoint() {
        Object ref = this.endpoint_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.endpoint_ = s;
        return s;
    }

    @Override
    public ByteString getEndpointBytes() {
        Object ref = this.endpoint_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.endpoint_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getStatusValue() {
        return this.status_;
    }

    @Override
    public Status getStatus() {
        Status result = Status.forNumber(this.status_);
        return result == null ? Status.UNRECOGNIZED : result;
    }

    @Override
    public long getTerm() {
        return this.term_;
    }

    @Override
    public long getLastLogIndex() {
        return this.lastLogIndex_;
    }

    @Override
    public long getLastLogTerm() {
        return this.lastLogTerm_;
    }

    @Override
    public String getFingerprint() {
        Object ref = this.fingerprint_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.fingerprint_ = s;
        return s;
    }

    @Override
    public ByteString getFingerprintBytes() {
        Object ref = this.fingerprint_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.fingerprint_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    private MapField<String, String> internalGetSyncStatus() {
        if (this.syncStatus_ == null) {
            return MapField.emptyMapField(SyncStatusDefaultEntryHolder.defaultEntry);
        }
        return this.syncStatus_;
    }

    @Override
    public int getSyncStatusCount() {
        return this.internalGetSyncStatus().getMap().size();
    }

    @Override
    public boolean containsSyncStatus(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        return this.internalGetSyncStatus().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, String> getSyncStatus() {
        return this.getSyncStatusMap();
    }

    @Override
    public Map<String, String> getSyncStatusMap() {
        return this.internalGetSyncStatus().getMap();
    }

    @Override
    public String getSyncStatusOrDefault(String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetSyncStatus().getMap();
        return map.containsKey(key) ? (String)map.get(key) : defaultValue;
    }

    @Override
    public String getSyncStatusOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetSyncStatus().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (String)map.get(key);
    }

    @Override
    public boolean hasRecoveryState() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public RecoveryStateOperation getRecoveryState() {
        return this.recoveryState_ == null ? RecoveryStateOperation.getDefaultInstance() : this.recoveryState_;
    }

    @Override
    public RecoveryStateOperationOrBuilder getRecoveryStateOrBuilder() {
        return this.recoveryState_ == null ? RecoveryStateOperation.getDefaultInstance() : this.recoveryState_;
    }

    @Override
    public boolean hasTopologyStatus() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public ClusterTopologyStatus getTopologyStatus() {
        return this.topologyStatus_ == null ? ClusterTopologyStatus.getDefaultInstance() : this.topologyStatus_;
    }

    @Override
    public ClusterTopologyStatusOrBuilder getTopologyStatusOrBuilder() {
        return this.topologyStatus_ == null ? ClusterTopologyStatus.getDefaultInstance() : this.topologyStatus_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.endpoint_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.endpoint_);
        }
        if (this.status_ != Status.CANDIDATE.getNumber()) {
            output.writeEnum(2, this.status_);
        }
        if (this.term_ != 0L) {
            output.writeInt64(3, this.term_);
        }
        if (this.lastLogIndex_ != 0L) {
            output.writeInt64(4, this.lastLogIndex_);
        }
        if (this.lastLogTerm_ != 0L) {
            output.writeInt64(5, this.lastLogTerm_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.fingerprint_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)6, (Object)this.fingerprint_);
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetSyncStatus(), SyncStatusDefaultEntryHolder.defaultEntry, (int)7);
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(8, (MessageLite)this.getRecoveryState());
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(9, (MessageLite)this.getTopologyStatus());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.endpoint_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.endpoint_);
        }
        if (this.status_ != Status.CANDIDATE.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)2, (int)this.status_);
        }
        if (this.term_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)3, (long)this.term_);
        }
        if (this.lastLogIndex_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)4, (long)this.lastLogIndex_);
        }
        if (this.lastLogTerm_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)5, (long)this.lastLogTerm_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.fingerprint_)) {
            size += GeneratedMessageV3.computeStringSize((int)6, (Object)this.fingerprint_);
        }
        for (Map.Entry entry : this.internalGetSyncStatus().getMap().entrySet()) {
            MapEntry syncStatus__ = SyncStatusDefaultEntryHolder.defaultEntry.newBuilderForType().setKey((Object)((String)entry.getKey())).setValue((Object)((String)entry.getValue())).build();
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)syncStatus__);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)this.getRecoveryState());
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)this.getTopologyStatus());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StatusResponse)) {
            return super.equals(obj);
        }
        StatusResponse other = (StatusResponse)obj;
        if (!this.getEndpoint().equals(other.getEndpoint())) {
            return false;
        }
        if (this.status_ != other.status_) {
            return false;
        }
        if (this.getTerm() != other.getTerm()) {
            return false;
        }
        if (this.getLastLogIndex() != other.getLastLogIndex()) {
            return false;
        }
        if (this.getLastLogTerm() != other.getLastLogTerm()) {
            return false;
        }
        if (!this.getFingerprint().equals(other.getFingerprint())) {
            return false;
        }
        if (!this.internalGetSyncStatus().equals(other.internalGetSyncStatus())) {
            return false;
        }
        if (this.hasRecoveryState() != other.hasRecoveryState()) {
            return false;
        }
        if (this.hasRecoveryState() && !this.getRecoveryState().equals(other.getRecoveryState())) {
            return false;
        }
        if (this.hasTopologyStatus() != other.hasTopologyStatus()) {
            return false;
        }
        if (this.hasTopologyStatus() && !this.getTopologyStatus().equals(other.getTopologyStatus())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + StatusResponse.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getEndpoint().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.status_;
        hash = 37 * hash + 3;
        hash = 53 * hash + Internal.hashLong((long)this.getTerm());
        hash = 37 * hash + 4;
        hash = 53 * hash + Internal.hashLong((long)this.getLastLogIndex());
        hash = 37 * hash + 5;
        hash = 53 * hash + Internal.hashLong((long)this.getLastLogTerm());
        hash = 37 * hash + 6;
        hash = 53 * hash + this.getFingerprint().hashCode();
        if (!this.internalGetSyncStatus().getMap().isEmpty()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.internalGetSyncStatus().hashCode();
        }
        if (this.hasRecoveryState()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getRecoveryState().hashCode();
        }
        if (this.hasTopologyStatus()) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getTopologyStatus().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static StatusResponse parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (StatusResponse)PARSER.parseFrom(data);
    }

    public static StatusResponse parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (StatusResponse)PARSER.parseFrom(data, extensionRegistry);
    }

    public static StatusResponse parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (StatusResponse)PARSER.parseFrom(data);
    }

    public static StatusResponse parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (StatusResponse)PARSER.parseFrom(data, extensionRegistry);
    }

    public static StatusResponse parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (StatusResponse)PARSER.parseFrom(data);
    }

    public static StatusResponse parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (StatusResponse)PARSER.parseFrom(data, extensionRegistry);
    }

    public static StatusResponse parseFrom(InputStream input) throws IOException {
        return (StatusResponse)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static StatusResponse parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (StatusResponse)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static StatusResponse parseDelimitedFrom(InputStream input) throws IOException {
        return (StatusResponse)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static StatusResponse parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (StatusResponse)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static StatusResponse parseFrom(CodedInputStream input) throws IOException {
        return (StatusResponse)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static StatusResponse parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (StatusResponse)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return StatusResponse.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(StatusResponse prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static StatusResponse getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<StatusResponse> parser() {
        return PARSER;
    }

    public Parser<StatusResponse> getParserForType() {
        return PARSER;
    }

    public StatusResponse getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements StatusResponseOrBuilder {
        private int bitField0_;
        private Object endpoint_ = "";
        private int status_ = 0;
        private long term_;
        private long lastLogIndex_;
        private long lastLogTerm_;
        private Object fingerprint_ = "";
        private MapField<String, String> syncStatus_;
        private RecoveryStateOperation recoveryState_;
        private SingleFieldBuilderV3<RecoveryStateOperation, RecoveryStateOperation.Builder, RecoveryStateOperationOrBuilder> recoveryStateBuilder_;
        private ClusterTopologyStatus topologyStatus_;
        private SingleFieldBuilderV3<ClusterTopologyStatus, ClusterTopologyStatus.Builder, ClusterTopologyStatusOrBuilder> topologyStatusBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return ClusterServerProto.internal_static_cluster_StatusResponse_descriptor;
        }

        protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
            switch (number) {
                case 7: {
                    return this.internalGetSyncStatus();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected MapFieldReflectionAccessor internalGetMutableMapFieldReflection(int number) {
            switch (number) {
                case 7: {
                    return this.internalGetMutableSyncStatus();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ClusterServerProto.internal_static_cluster_StatusResponse_fieldAccessorTable.ensureFieldAccessorsInitialized(StatusResponse.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getRecoveryStateFieldBuilder();
                this.getTopologyStatusFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.endpoint_ = "";
            this.status_ = 0;
            this.term_ = 0L;
            this.lastLogIndex_ = 0L;
            this.lastLogTerm_ = 0L;
            this.fingerprint_ = "";
            this.internalGetMutableSyncStatus().clear();
            this.recoveryState_ = null;
            if (this.recoveryStateBuilder_ != null) {
                this.recoveryStateBuilder_.dispose();
                this.recoveryStateBuilder_ = null;
            }
            this.topologyStatus_ = null;
            if (this.topologyStatusBuilder_ != null) {
                this.topologyStatusBuilder_.dispose();
                this.topologyStatusBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return ClusterServerProto.internal_static_cluster_StatusResponse_descriptor;
        }

        public StatusResponse getDefaultInstanceForType() {
            return StatusResponse.getDefaultInstance();
        }

        public StatusResponse build() {
            StatusResponse result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public StatusResponse buildPartial() {
            StatusResponse result = new StatusResponse(this);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartial0(StatusResponse result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.endpoint_ = this.endpoint_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.status_ = this.status_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.term_ = this.term_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.lastLogIndex_ = this.lastLogIndex_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.lastLogTerm_ = this.lastLogTerm_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.fingerprint_ = this.fingerprint_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.syncStatus_ = this.internalGetSyncStatus();
                result.syncStatus_.makeImmutable();
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 0x80) != 0) {
                result.recoveryState_ = this.recoveryStateBuilder_ == null ? this.recoveryState_ : (RecoveryStateOperation)this.recoveryStateBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.topologyStatus_ = this.topologyStatusBuilder_ == null ? this.topologyStatus_ : (ClusterTopologyStatus)this.topologyStatusBuilder_.build();
                to_bitField0_ |= 2;
            }
            result.bitField0_ |= to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof StatusResponse) {
                return this.mergeFrom((StatusResponse)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(StatusResponse other) {
            if (other == StatusResponse.getDefaultInstance()) {
                return this;
            }
            if (!other.getEndpoint().isEmpty()) {
                this.endpoint_ = other.endpoint_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.status_ != 0) {
                this.setStatusValue(other.getStatusValue());
            }
            if (other.getTerm() != 0L) {
                this.setTerm(other.getTerm());
            }
            if (other.getLastLogIndex() != 0L) {
                this.setLastLogIndex(other.getLastLogIndex());
            }
            if (other.getLastLogTerm() != 0L) {
                this.setLastLogTerm(other.getLastLogTerm());
            }
            if (!other.getFingerprint().isEmpty()) {
                this.fingerprint_ = other.fingerprint_;
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            this.internalGetMutableSyncStatus().mergeFrom(other.internalGetSyncStatus());
            this.bitField0_ |= 0x40;
            if (other.hasRecoveryState()) {
                this.mergeRecoveryState(other.getRecoveryState());
            }
            if (other.hasTopologyStatus()) {
                this.mergeTopologyStatus(other.getTopologyStatus());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block17: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block17;
                        }
                        case 10: {
                            this.endpoint_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block17;
                        }
                        case 16: {
                            this.status_ = input.readEnum();
                            this.bitField0_ |= 2;
                            continue block17;
                        }
                        case 24: {
                            this.term_ = input.readInt64();
                            this.bitField0_ |= 4;
                            continue block17;
                        }
                        case 32: {
                            this.lastLogIndex_ = input.readInt64();
                            this.bitField0_ |= 8;
                            continue block17;
                        }
                        case 40: {
                            this.lastLogTerm_ = input.readInt64();
                            this.bitField0_ |= 0x10;
                            continue block17;
                        }
                        case 50: {
                            this.fingerprint_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x20;
                            continue block17;
                        }
                        case 58: {
                            MapEntry syncStatus__ = (MapEntry)input.readMessage(SyncStatusDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                            this.internalGetMutableSyncStatus().getMutableMap().put((String)syncStatus__.getKey(), (String)syncStatus__.getValue());
                            this.bitField0_ |= 0x40;
                            continue block17;
                        }
                        case 66: {
                            input.readMessage((MessageLite.Builder)this.getRecoveryStateFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x80;
                            continue block17;
                        }
                        case 74: {
                            input.readMessage((MessageLite.Builder)this.getTopologyStatusFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x100;
                            continue block17;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getEndpoint() {
            Object ref = this.endpoint_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.endpoint_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getEndpointBytes() {
            Object ref = this.endpoint_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.endpoint_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setEndpoint(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.endpoint_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearEndpoint() {
            this.endpoint_ = StatusResponse.getDefaultInstance().getEndpoint();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setEndpointBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            StatusResponse.checkByteStringIsUtf8((ByteString)value);
            this.endpoint_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public int getStatusValue() {
            return this.status_;
        }

        public Builder setStatusValue(int value) {
            this.status_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public Status getStatus() {
            Status result = Status.forNumber(this.status_);
            return result == null ? Status.UNRECOGNIZED : result;
        }

        public Builder setStatus(Status value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 2;
            this.status_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearStatus() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.status_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public long getTerm() {
            return this.term_;
        }

        public Builder setTerm(long value) {
            this.term_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearTerm() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.term_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getLastLogIndex() {
            return this.lastLogIndex_;
        }

        public Builder setLastLogIndex(long value) {
            this.lastLogIndex_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearLastLogIndex() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.lastLogIndex_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getLastLogTerm() {
            return this.lastLogTerm_;
        }

        public Builder setLastLogTerm(long value) {
            this.lastLogTerm_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearLastLogTerm() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.lastLogTerm_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public String getFingerprint() {
            Object ref = this.fingerprint_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.fingerprint_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getFingerprintBytes() {
            Object ref = this.fingerprint_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.fingerprint_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setFingerprint(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.fingerprint_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearFingerprint() {
            this.fingerprint_ = StatusResponse.getDefaultInstance().getFingerprint();
            this.bitField0_ &= 0xFFFFFFDF;
            this.onChanged();
            return this;
        }

        public Builder setFingerprintBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            StatusResponse.checkByteStringIsUtf8((ByteString)value);
            this.fingerprint_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        private MapField<String, String> internalGetSyncStatus() {
            if (this.syncStatus_ == null) {
                return MapField.emptyMapField(SyncStatusDefaultEntryHolder.defaultEntry);
            }
            return this.syncStatus_;
        }

        private MapField<String, String> internalGetMutableSyncStatus() {
            if (this.syncStatus_ == null) {
                this.syncStatus_ = MapField.newMapField(SyncStatusDefaultEntryHolder.defaultEntry);
            }
            if (!this.syncStatus_.isMutable()) {
                this.syncStatus_ = this.syncStatus_.copy();
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this.syncStatus_;
        }

        @Override
        public int getSyncStatusCount() {
            return this.internalGetSyncStatus().getMap().size();
        }

        @Override
        public boolean containsSyncStatus(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetSyncStatus().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getSyncStatus() {
            return this.getSyncStatusMap();
        }

        @Override
        public Map<String, String> getSyncStatusMap() {
            return this.internalGetSyncStatus().getMap();
        }

        @Override
        public String getSyncStatusOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetSyncStatus().getMap();
            return map.containsKey(key) ? (String)map.get(key) : defaultValue;
        }

        @Override
        public String getSyncStatusOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetSyncStatus().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (String)map.get(key);
        }

        public Builder clearSyncStatus() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.internalGetMutableSyncStatus().getMutableMap().clear();
            return this;
        }

        public Builder removeSyncStatus(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            this.internalGetMutableSyncStatus().getMutableMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, String> getMutableSyncStatus() {
            this.bitField0_ |= 0x40;
            return this.internalGetMutableSyncStatus().getMutableMap();
        }

        public Builder putSyncStatus(String key, String value) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            if (value == null) {
                throw new NullPointerException("map value");
            }
            this.internalGetMutableSyncStatus().getMutableMap().put(key, value);
            this.bitField0_ |= 0x40;
            return this;
        }

        public Builder putAllSyncStatus(Map<String, String> values) {
            this.internalGetMutableSyncStatus().getMutableMap().putAll(values);
            this.bitField0_ |= 0x40;
            return this;
        }

        @Override
        public boolean hasRecoveryState() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public RecoveryStateOperation getRecoveryState() {
            if (this.recoveryStateBuilder_ == null) {
                return this.recoveryState_ == null ? RecoveryStateOperation.getDefaultInstance() : this.recoveryState_;
            }
            return (RecoveryStateOperation)this.recoveryStateBuilder_.getMessage();
        }

        public Builder setRecoveryState(RecoveryStateOperation value) {
            if (this.recoveryStateBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.recoveryState_ = value;
            } else {
                this.recoveryStateBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder setRecoveryState(RecoveryStateOperation.Builder builderForValue) {
            if (this.recoveryStateBuilder_ == null) {
                this.recoveryState_ = builderForValue.build();
            } else {
                this.recoveryStateBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder mergeRecoveryState(RecoveryStateOperation value) {
            if (this.recoveryStateBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0 && this.recoveryState_ != null && this.recoveryState_ != RecoveryStateOperation.getDefaultInstance()) {
                    this.getRecoveryStateBuilder().mergeFrom(value);
                } else {
                    this.recoveryState_ = value;
                }
            } else {
                this.recoveryStateBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.recoveryState_ != null) {
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            return this;
        }

        public Builder clearRecoveryState() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.recoveryState_ = null;
            if (this.recoveryStateBuilder_ != null) {
                this.recoveryStateBuilder_.dispose();
                this.recoveryStateBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public RecoveryStateOperation.Builder getRecoveryStateBuilder() {
            this.bitField0_ |= 0x80;
            this.onChanged();
            return (RecoveryStateOperation.Builder)this.getRecoveryStateFieldBuilder().getBuilder();
        }

        @Override
        public RecoveryStateOperationOrBuilder getRecoveryStateOrBuilder() {
            if (this.recoveryStateBuilder_ != null) {
                return (RecoveryStateOperationOrBuilder)this.recoveryStateBuilder_.getMessageOrBuilder();
            }
            return this.recoveryState_ == null ? RecoveryStateOperation.getDefaultInstance() : this.recoveryState_;
        }

        private SingleFieldBuilderV3<RecoveryStateOperation, RecoveryStateOperation.Builder, RecoveryStateOperationOrBuilder> getRecoveryStateFieldBuilder() {
            if (this.recoveryStateBuilder_ == null) {
                this.recoveryStateBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getRecoveryState(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.recoveryState_ = null;
            }
            return this.recoveryStateBuilder_;
        }

        @Override
        public boolean hasTopologyStatus() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public ClusterTopologyStatus getTopologyStatus() {
            if (this.topologyStatusBuilder_ == null) {
                return this.topologyStatus_ == null ? ClusterTopologyStatus.getDefaultInstance() : this.topologyStatus_;
            }
            return (ClusterTopologyStatus)this.topologyStatusBuilder_.getMessage();
        }

        public Builder setTopologyStatus(ClusterTopologyStatus value) {
            if (this.topologyStatusBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.topologyStatus_ = value;
            } else {
                this.topologyStatusBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder setTopologyStatus(ClusterTopologyStatus.Builder builderForValue) {
            if (this.topologyStatusBuilder_ == null) {
                this.topologyStatus_ = builderForValue.build();
            } else {
                this.topologyStatusBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder mergeTopologyStatus(ClusterTopologyStatus value) {
            if (this.topologyStatusBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0 && this.topologyStatus_ != null && this.topologyStatus_ != ClusterTopologyStatus.getDefaultInstance()) {
                    this.getTopologyStatusBuilder().mergeFrom(value);
                } else {
                    this.topologyStatus_ = value;
                }
            } else {
                this.topologyStatusBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.topologyStatus_ != null) {
                this.bitField0_ |= 0x100;
                this.onChanged();
            }
            return this;
        }

        public Builder clearTopologyStatus() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.topologyStatus_ = null;
            if (this.topologyStatusBuilder_ != null) {
                this.topologyStatusBuilder_.dispose();
                this.topologyStatusBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public ClusterTopologyStatus.Builder getTopologyStatusBuilder() {
            this.bitField0_ |= 0x100;
            this.onChanged();
            return (ClusterTopologyStatus.Builder)this.getTopologyStatusFieldBuilder().getBuilder();
        }

        @Override
        public ClusterTopologyStatusOrBuilder getTopologyStatusOrBuilder() {
            if (this.topologyStatusBuilder_ != null) {
                return (ClusterTopologyStatusOrBuilder)this.topologyStatusBuilder_.getMessageOrBuilder();
            }
            return this.topologyStatus_ == null ? ClusterTopologyStatus.getDefaultInstance() : this.topologyStatus_;
        }

        private SingleFieldBuilderV3<ClusterTopologyStatus, ClusterTopologyStatus.Builder, ClusterTopologyStatusOrBuilder> getTopologyStatusFieldBuilder() {
            if (this.topologyStatusBuilder_ == null) {
                this.topologyStatusBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getTopologyStatus(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.topologyStatus_ = null;
            }
            return this.topologyStatusBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum Status implements ProtocolMessageEnum
    {
        CANDIDATE(0),
        LEADER(1),
        FOLLOWER(2),
        CREATING_SNAPSHOT(3),
        OUT_OF_SYNC(4),
        NO_CLUSTER(5),
        NO_CONNECTION(6),
        RESTRICTED(7),
        UNRECOGNIZED(-1);

        public static final int CANDIDATE_VALUE = 0;
        public static final int LEADER_VALUE = 1;
        public static final int FOLLOWER_VALUE = 2;
        public static final int CREATING_SNAPSHOT_VALUE = 3;
        public static final int OUT_OF_SYNC_VALUE = 4;
        public static final int NO_CLUSTER_VALUE = 5;
        public static final int NO_CONNECTION_VALUE = 6;
        public static final int RESTRICTED_VALUE = 7;
        private static final Internal.EnumLiteMap<Status> internalValueMap;
        private static final Status[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static Status valueOf(int value) {
            return Status.forNumber(value);
        }

        public static Status forNumber(int value) {
            switch (value) {
                case 0: {
                    return CANDIDATE;
                }
                case 1: {
                    return LEADER;
                }
                case 2: {
                    return FOLLOWER;
                }
                case 3: {
                    return CREATING_SNAPSHOT;
                }
                case 4: {
                    return OUT_OF_SYNC;
                }
                case 5: {
                    return NO_CLUSTER;
                }
                case 6: {
                    return NO_CONNECTION;
                }
                case 7: {
                    return RESTRICTED;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<Status> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)Status.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return Status.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)StatusResponse.getDescriptor().getEnumTypes().get(0);
        }

        public static Status valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != Status.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private Status(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<Status>(){

                public Status findValueByNumber(int number) {
                    return Status.forNumber(number);
                }
            };
            VALUES = Status.values();
        }
    }

    private static final class SyncStatusDefaultEntryHolder {
        static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)ClusterServerProto.internal_static_cluster_StatusResponse_SyncStatusEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

        private SyncStatusDefaultEntryHolder() {
        }
    }

    public static final class ClusterTopologyStatus
    extends GeneratedMessageV3
    implements ClusterTopologyStatusOrBuilder {
        private static final long serialVersionUID = 0L;
        private int kindCase_ = 0;
        private Object kind_;
        public static final int PRIMARYSTATUS_FIELD_NUMBER = 1;
        public static final int SECONDARYSTATUS_FIELD_NUMBER = 2;
        private byte memoizedIsInitialized = (byte)-1;
        private static final ClusterTopologyStatus DEFAULT_INSTANCE = new ClusterTopologyStatus();
        private static final Parser<ClusterTopologyStatus> PARSER = new AbstractParser<ClusterTopologyStatus>(){

            public ClusterTopologyStatus parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = ClusterTopologyStatus.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private ClusterTopologyStatus(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private ClusterTopologyStatus() {
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new ClusterTopologyStatus();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return ClusterServerProto.internal_static_cluster_StatusResponse_ClusterTopologyStatus_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ClusterServerProto.internal_static_cluster_StatusResponse_ClusterTopologyStatus_fieldAccessorTable.ensureFieldAccessorsInitialized(ClusterTopologyStatus.class, Builder.class);
        }

        @Override
        public KindCase getKindCase() {
            return KindCase.forNumber(this.kindCase_);
        }

        @Override
        public boolean hasPrimaryStatus() {
            return this.kindCase_ == 1;
        }

        @Override
        public PrimaryStatus getPrimaryStatus() {
            if (this.kindCase_ == 1) {
                return (PrimaryStatus)this.kind_;
            }
            return PrimaryStatus.getDefaultInstance();
        }

        @Override
        public PrimaryStatusOrBuilder getPrimaryStatusOrBuilder() {
            if (this.kindCase_ == 1) {
                return (PrimaryStatus)this.kind_;
            }
            return PrimaryStatus.getDefaultInstance();
        }

        @Override
        public boolean hasSecondaryStatus() {
            return this.kindCase_ == 2;
        }

        @Override
        public SecondaryStatus getSecondaryStatus() {
            if (this.kindCase_ == 2) {
                return (SecondaryStatus)this.kind_;
            }
            return SecondaryStatus.getDefaultInstance();
        }

        @Override
        public SecondaryStatusOrBuilder getSecondaryStatusOrBuilder() {
            if (this.kindCase_ == 2) {
                return (SecondaryStatus)this.kind_;
            }
            return SecondaryStatus.getDefaultInstance();
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (this.kindCase_ == 1) {
                output.writeMessage(1, (MessageLite)((PrimaryStatus)this.kind_));
            }
            if (this.kindCase_ == 2) {
                output.writeMessage(2, (MessageLite)((SecondaryStatus)this.kind_));
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.kindCase_ == 1) {
                size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)((PrimaryStatus)this.kind_));
            }
            if (this.kindCase_ == 2) {
                size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)((SecondaryStatus)this.kind_));
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ClusterTopologyStatus)) {
                return super.equals(obj);
            }
            ClusterTopologyStatus other = (ClusterTopologyStatus)obj;
            if (!this.getKindCase().equals((Object)other.getKindCase())) {
                return false;
            }
            switch (this.kindCase_) {
                case 1: {
                    if (this.getPrimaryStatus().equals(other.getPrimaryStatus())) break;
                    return false;
                }
                case 2: {
                    if (this.getSecondaryStatus().equals(other.getSecondaryStatus())) break;
                    return false;
                }
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + ClusterTopologyStatus.getDescriptor().hashCode();
            switch (this.kindCase_) {
                case 1: {
                    hash = 37 * hash + 1;
                    hash = 53 * hash + this.getPrimaryStatus().hashCode();
                    break;
                }
                case 2: {
                    hash = 37 * hash + 2;
                    hash = 53 * hash + this.getSecondaryStatus().hashCode();
                    break;
                }
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static ClusterTopologyStatus parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (ClusterTopologyStatus)PARSER.parseFrom(data);
        }

        public static ClusterTopologyStatus parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (ClusterTopologyStatus)PARSER.parseFrom(data, extensionRegistry);
        }

        public static ClusterTopologyStatus parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (ClusterTopologyStatus)PARSER.parseFrom(data);
        }

        public static ClusterTopologyStatus parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (ClusterTopologyStatus)PARSER.parseFrom(data, extensionRegistry);
        }

        public static ClusterTopologyStatus parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (ClusterTopologyStatus)PARSER.parseFrom(data);
        }

        public static ClusterTopologyStatus parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (ClusterTopologyStatus)PARSER.parseFrom(data, extensionRegistry);
        }

        public static ClusterTopologyStatus parseFrom(InputStream input) throws IOException {
            return (ClusterTopologyStatus)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static ClusterTopologyStatus parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (ClusterTopologyStatus)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static ClusterTopologyStatus parseDelimitedFrom(InputStream input) throws IOException {
            return (ClusterTopologyStatus)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static ClusterTopologyStatus parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (ClusterTopologyStatus)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static ClusterTopologyStatus parseFrom(CodedInputStream input) throws IOException {
            return (ClusterTopologyStatus)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static ClusterTopologyStatus parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (ClusterTopologyStatus)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return ClusterTopologyStatus.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(ClusterTopologyStatus prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static ClusterTopologyStatus getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<ClusterTopologyStatus> parser() {
            return PARSER;
        }

        public Parser<ClusterTopologyStatus> getParserForType() {
            return PARSER;
        }

        public ClusterTopologyStatus getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements ClusterTopologyStatusOrBuilder {
            private int kindCase_ = 0;
            private Object kind_;
            private int bitField0_;
            private SingleFieldBuilderV3<PrimaryStatus, PrimaryStatus.Builder, PrimaryStatusOrBuilder> primaryStatusBuilder_;
            private SingleFieldBuilderV3<SecondaryStatus, SecondaryStatus.Builder, SecondaryStatusOrBuilder> secondaryStatusBuilder_;

            public static final Descriptors.Descriptor getDescriptor() {
                return ClusterServerProto.internal_static_cluster_StatusResponse_ClusterTopologyStatus_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return ClusterServerProto.internal_static_cluster_StatusResponse_ClusterTopologyStatus_fieldAccessorTable.ensureFieldAccessorsInitialized(ClusterTopologyStatus.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                if (this.primaryStatusBuilder_ != null) {
                    this.primaryStatusBuilder_.clear();
                }
                if (this.secondaryStatusBuilder_ != null) {
                    this.secondaryStatusBuilder_.clear();
                }
                this.kindCase_ = 0;
                this.kind_ = null;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return ClusterServerProto.internal_static_cluster_StatusResponse_ClusterTopologyStatus_descriptor;
            }

            public ClusterTopologyStatus getDefaultInstanceForType() {
                return ClusterTopologyStatus.getDefaultInstance();
            }

            public ClusterTopologyStatus build() {
                ClusterTopologyStatus result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public ClusterTopologyStatus buildPartial() {
                ClusterTopologyStatus result = new ClusterTopologyStatus(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.buildPartialOneofs(result);
                this.onBuilt();
                return result;
            }

            private void buildPartial0(ClusterTopologyStatus result) {
                int from_bitField0_ = this.bitField0_;
            }

            private void buildPartialOneofs(ClusterTopologyStatus result) {
                result.kindCase_ = this.kindCase_;
                result.kind_ = this.kind_;
                if (this.kindCase_ == 1 && this.primaryStatusBuilder_ != null) {
                    result.kind_ = this.primaryStatusBuilder_.build();
                }
                if (this.kindCase_ == 2 && this.secondaryStatusBuilder_ != null) {
                    result.kind_ = this.secondaryStatusBuilder_.build();
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof ClusterTopologyStatus) {
                    return this.mergeFrom((ClusterTopologyStatus)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(ClusterTopologyStatus other) {
                if (other == ClusterTopologyStatus.getDefaultInstance()) {
                    return this;
                }
                switch (other.getKindCase().ordinal()) {
                    case 0: {
                        this.mergePrimaryStatus(other.getPrimaryStatus());
                        break;
                    }
                    case 1: {
                        this.mergeSecondaryStatus(other.getSecondaryStatus());
                        break;
                    }
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block10: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block10;
                            }
                            case 10: {
                                input.readMessage((MessageLite.Builder)this.getPrimaryStatusFieldBuilder().getBuilder(), extensionRegistry);
                                this.kindCase_ = 1;
                                continue block10;
                            }
                            case 18: {
                                input.readMessage((MessageLite.Builder)this.getSecondaryStatusFieldBuilder().getBuilder(), extensionRegistry);
                                this.kindCase_ = 2;
                                continue block10;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public KindCase getKindCase() {
                return KindCase.forNumber(this.kindCase_);
            }

            public Builder clearKind() {
                this.kindCase_ = 0;
                this.kind_ = null;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasPrimaryStatus() {
                return this.kindCase_ == 1;
            }

            @Override
            public PrimaryStatus getPrimaryStatus() {
                if (this.primaryStatusBuilder_ == null) {
                    if (this.kindCase_ == 1) {
                        return (PrimaryStatus)this.kind_;
                    }
                    return PrimaryStatus.getDefaultInstance();
                }
                if (this.kindCase_ == 1) {
                    return (PrimaryStatus)this.primaryStatusBuilder_.getMessage();
                }
                return PrimaryStatus.getDefaultInstance();
            }

            public Builder setPrimaryStatus(PrimaryStatus value) {
                if (this.primaryStatusBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.kind_ = value;
                    this.onChanged();
                } else {
                    this.primaryStatusBuilder_.setMessage((AbstractMessage)value);
                }
                this.kindCase_ = 1;
                return this;
            }

            public Builder setPrimaryStatus(PrimaryStatus.Builder builderForValue) {
                if (this.primaryStatusBuilder_ == null) {
                    this.kind_ = builderForValue.build();
                    this.onChanged();
                } else {
                    this.primaryStatusBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.kindCase_ = 1;
                return this;
            }

            public Builder mergePrimaryStatus(PrimaryStatus value) {
                if (this.primaryStatusBuilder_ == null) {
                    this.kind_ = this.kindCase_ == 1 && this.kind_ != PrimaryStatus.getDefaultInstance() ? PrimaryStatus.newBuilder((PrimaryStatus)this.kind_).mergeFrom(value).buildPartial() : value;
                    this.onChanged();
                } else if (this.kindCase_ == 1) {
                    this.primaryStatusBuilder_.mergeFrom((AbstractMessage)value);
                } else {
                    this.primaryStatusBuilder_.setMessage((AbstractMessage)value);
                }
                this.kindCase_ = 1;
                return this;
            }

            public Builder clearPrimaryStatus() {
                if (this.primaryStatusBuilder_ == null) {
                    if (this.kindCase_ == 1) {
                        this.kindCase_ = 0;
                        this.kind_ = null;
                        this.onChanged();
                    }
                } else {
                    if (this.kindCase_ == 1) {
                        this.kindCase_ = 0;
                        this.kind_ = null;
                    }
                    this.primaryStatusBuilder_.clear();
                }
                return this;
            }

            public PrimaryStatus.Builder getPrimaryStatusBuilder() {
                return (PrimaryStatus.Builder)this.getPrimaryStatusFieldBuilder().getBuilder();
            }

            @Override
            public PrimaryStatusOrBuilder getPrimaryStatusOrBuilder() {
                if (this.kindCase_ == 1 && this.primaryStatusBuilder_ != null) {
                    return (PrimaryStatusOrBuilder)this.primaryStatusBuilder_.getMessageOrBuilder();
                }
                if (this.kindCase_ == 1) {
                    return (PrimaryStatus)this.kind_;
                }
                return PrimaryStatus.getDefaultInstance();
            }

            private SingleFieldBuilderV3<PrimaryStatus, PrimaryStatus.Builder, PrimaryStatusOrBuilder> getPrimaryStatusFieldBuilder() {
                if (this.primaryStatusBuilder_ == null) {
                    if (this.kindCase_ != 1) {
                        this.kind_ = PrimaryStatus.getDefaultInstance();
                    }
                    this.primaryStatusBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((PrimaryStatus)this.kind_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.kind_ = null;
                }
                this.kindCase_ = 1;
                this.onChanged();
                return this.primaryStatusBuilder_;
            }

            @Override
            public boolean hasSecondaryStatus() {
                return this.kindCase_ == 2;
            }

            @Override
            public SecondaryStatus getSecondaryStatus() {
                if (this.secondaryStatusBuilder_ == null) {
                    if (this.kindCase_ == 2) {
                        return (SecondaryStatus)this.kind_;
                    }
                    return SecondaryStatus.getDefaultInstance();
                }
                if (this.kindCase_ == 2) {
                    return (SecondaryStatus)this.secondaryStatusBuilder_.getMessage();
                }
                return SecondaryStatus.getDefaultInstance();
            }

            public Builder setSecondaryStatus(SecondaryStatus value) {
                if (this.secondaryStatusBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.kind_ = value;
                    this.onChanged();
                } else {
                    this.secondaryStatusBuilder_.setMessage((AbstractMessage)value);
                }
                this.kindCase_ = 2;
                return this;
            }

            public Builder setSecondaryStatus(SecondaryStatus.Builder builderForValue) {
                if (this.secondaryStatusBuilder_ == null) {
                    this.kind_ = builderForValue.build();
                    this.onChanged();
                } else {
                    this.secondaryStatusBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.kindCase_ = 2;
                return this;
            }

            public Builder mergeSecondaryStatus(SecondaryStatus value) {
                if (this.secondaryStatusBuilder_ == null) {
                    this.kind_ = this.kindCase_ == 2 && this.kind_ != SecondaryStatus.getDefaultInstance() ? SecondaryStatus.newBuilder((SecondaryStatus)this.kind_).mergeFrom(value).buildPartial() : value;
                    this.onChanged();
                } else if (this.kindCase_ == 2) {
                    this.secondaryStatusBuilder_.mergeFrom((AbstractMessage)value);
                } else {
                    this.secondaryStatusBuilder_.setMessage((AbstractMessage)value);
                }
                this.kindCase_ = 2;
                return this;
            }

            public Builder clearSecondaryStatus() {
                if (this.secondaryStatusBuilder_ == null) {
                    if (this.kindCase_ == 2) {
                        this.kindCase_ = 0;
                        this.kind_ = null;
                        this.onChanged();
                    }
                } else {
                    if (this.kindCase_ == 2) {
                        this.kindCase_ = 0;
                        this.kind_ = null;
                    }
                    this.secondaryStatusBuilder_.clear();
                }
                return this;
            }

            public SecondaryStatus.Builder getSecondaryStatusBuilder() {
                return (SecondaryStatus.Builder)this.getSecondaryStatusFieldBuilder().getBuilder();
            }

            @Override
            public SecondaryStatusOrBuilder getSecondaryStatusOrBuilder() {
                if (this.kindCase_ == 2 && this.secondaryStatusBuilder_ != null) {
                    return (SecondaryStatusOrBuilder)this.secondaryStatusBuilder_.getMessageOrBuilder();
                }
                if (this.kindCase_ == 2) {
                    return (SecondaryStatus)this.kind_;
                }
                return SecondaryStatus.getDefaultInstance();
            }

            private SingleFieldBuilderV3<SecondaryStatus, SecondaryStatus.Builder, SecondaryStatusOrBuilder> getSecondaryStatusFieldBuilder() {
                if (this.secondaryStatusBuilder_ == null) {
                    if (this.kindCase_ != 2) {
                        this.kind_ = SecondaryStatus.getDefaultInstance();
                    }
                    this.secondaryStatusBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((SecondaryStatus)this.kind_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.kind_ = null;
                }
                this.kindCase_ = 2;
                this.onChanged();
                return this.secondaryStatusBuilder_;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }

        public static enum KindCase implements Internal.EnumLite,
        AbstractMessageLite.InternalOneOfEnum
        {
            PRIMARYSTATUS(1),
            SECONDARYSTATUS(2),
            KIND_NOT_SET(0);

            private final int value;

            private KindCase(int value) {
                this.value = value;
            }

            @Deprecated
            public static KindCase valueOf(int value) {
                return KindCase.forNumber(value);
            }

            public static KindCase forNumber(int value) {
                switch (value) {
                    case 1: {
                        return PRIMARYSTATUS;
                    }
                    case 2: {
                        return SECONDARYSTATUS;
                    }
                    case 0: {
                        return KIND_NOT_SET;
                    }
                }
                return null;
            }

            public int getNumber() {
                return this.value;
            }
        }
    }

    public static final class SecondaryStatus
    extends GeneratedMessageV3
    implements SecondaryStatusOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int PRIMARYINDEX_FIELD_NUMBER = 1;
        private long primaryIndex_ = 0L;
        public static final int PRIMARYLEADER_FIELD_NUMBER = 2;
        private volatile Object primaryLeader_ = "";
        private byte memoizedIsInitialized = (byte)-1;
        private static final SecondaryStatus DEFAULT_INSTANCE = new SecondaryStatus();
        private static final Parser<SecondaryStatus> PARSER = new AbstractParser<SecondaryStatus>(){

            public SecondaryStatus parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = SecondaryStatus.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private SecondaryStatus(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private SecondaryStatus() {
            this.primaryLeader_ = "";
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new SecondaryStatus();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return ClusterServerProto.internal_static_cluster_StatusResponse_SecondaryStatus_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ClusterServerProto.internal_static_cluster_StatusResponse_SecondaryStatus_fieldAccessorTable.ensureFieldAccessorsInitialized(SecondaryStatus.class, Builder.class);
        }

        @Override
        public long getPrimaryIndex() {
            return this.primaryIndex_;
        }

        @Override
        public String getPrimaryLeader() {
            Object ref = this.primaryLeader_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.primaryLeader_ = s;
            return s;
        }

        @Override
        public ByteString getPrimaryLeaderBytes() {
            Object ref = this.primaryLeader_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.primaryLeader_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (this.primaryIndex_ != 0L) {
                output.writeInt64(1, this.primaryIndex_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.primaryLeader_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.primaryLeader_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.primaryIndex_ != 0L) {
                size += CodedOutputStream.computeInt64Size((int)1, (long)this.primaryIndex_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.primaryLeader_)) {
                size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.primaryLeader_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SecondaryStatus)) {
                return super.equals(obj);
            }
            SecondaryStatus other = (SecondaryStatus)obj;
            if (this.getPrimaryIndex() != other.getPrimaryIndex()) {
                return false;
            }
            if (!this.getPrimaryLeader().equals(other.getPrimaryLeader())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + SecondaryStatus.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + Internal.hashLong((long)this.getPrimaryIndex());
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getPrimaryLeader().hashCode();
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static SecondaryStatus parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (SecondaryStatus)PARSER.parseFrom(data);
        }

        public static SecondaryStatus parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (SecondaryStatus)PARSER.parseFrom(data, extensionRegistry);
        }

        public static SecondaryStatus parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (SecondaryStatus)PARSER.parseFrom(data);
        }

        public static SecondaryStatus parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (SecondaryStatus)PARSER.parseFrom(data, extensionRegistry);
        }

        public static SecondaryStatus parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (SecondaryStatus)PARSER.parseFrom(data);
        }

        public static SecondaryStatus parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (SecondaryStatus)PARSER.parseFrom(data, extensionRegistry);
        }

        public static SecondaryStatus parseFrom(InputStream input) throws IOException {
            return (SecondaryStatus)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static SecondaryStatus parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (SecondaryStatus)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static SecondaryStatus parseDelimitedFrom(InputStream input) throws IOException {
            return (SecondaryStatus)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static SecondaryStatus parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (SecondaryStatus)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static SecondaryStatus parseFrom(CodedInputStream input) throws IOException {
            return (SecondaryStatus)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static SecondaryStatus parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (SecondaryStatus)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return SecondaryStatus.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(SecondaryStatus prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static SecondaryStatus getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<SecondaryStatus> parser() {
            return PARSER;
        }

        public Parser<SecondaryStatus> getParserForType() {
            return PARSER;
        }

        public SecondaryStatus getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements SecondaryStatusOrBuilder {
            private int bitField0_;
            private long primaryIndex_;
            private Object primaryLeader_ = "";

            public static final Descriptors.Descriptor getDescriptor() {
                return ClusterServerProto.internal_static_cluster_StatusResponse_SecondaryStatus_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return ClusterServerProto.internal_static_cluster_StatusResponse_SecondaryStatus_fieldAccessorTable.ensureFieldAccessorsInitialized(SecondaryStatus.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.primaryIndex_ = 0L;
                this.primaryLeader_ = "";
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return ClusterServerProto.internal_static_cluster_StatusResponse_SecondaryStatus_descriptor;
            }

            public SecondaryStatus getDefaultInstanceForType() {
                return SecondaryStatus.getDefaultInstance();
            }

            public SecondaryStatus build() {
                SecondaryStatus result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public SecondaryStatus buildPartial() {
                SecondaryStatus result = new SecondaryStatus(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(SecondaryStatus result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.primaryIndex_ = this.primaryIndex_;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.primaryLeader_ = this.primaryLeader_;
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof SecondaryStatus) {
                    return this.mergeFrom((SecondaryStatus)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(SecondaryStatus other) {
                if (other == SecondaryStatus.getDefaultInstance()) {
                    return this;
                }
                if (other.getPrimaryIndex() != 0L) {
                    this.setPrimaryIndex(other.getPrimaryIndex());
                }
                if (!other.getPrimaryLeader().isEmpty()) {
                    this.primaryLeader_ = other.primaryLeader_;
                    this.bitField0_ |= 2;
                    this.onChanged();
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block10: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block10;
                            }
                            case 8: {
                                this.primaryIndex_ = input.readInt64();
                                this.bitField0_ |= 1;
                                continue block10;
                            }
                            case 18: {
                                this.primaryLeader_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 2;
                                continue block10;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public long getPrimaryIndex() {
                return this.primaryIndex_;
            }

            public Builder setPrimaryIndex(long value) {
                this.primaryIndex_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearPrimaryIndex() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.primaryIndex_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public String getPrimaryLeader() {
                Object ref = this.primaryLeader_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.primaryLeader_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getPrimaryLeaderBytes() {
                Object ref = this.primaryLeader_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.primaryLeader_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setPrimaryLeader(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.primaryLeader_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearPrimaryLeader() {
                this.primaryLeader_ = SecondaryStatus.getDefaultInstance().getPrimaryLeader();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
                return this;
            }

            public Builder setPrimaryLeaderBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                SecondaryStatus.checkByteStringIsUtf8((ByteString)value);
                this.primaryLeader_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface SecondaryStatusOrBuilder
    extends MessageOrBuilder {
        public long getPrimaryIndex();

        public String getPrimaryLeader();

        public ByteString getPrimaryLeaderBytes();
    }

    public static final class PrimaryStatus
    extends GeneratedMessageV3
    implements PrimaryStatusOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int TAGSTATUS_FIELD_NUMBER = 1;
        private MapField<String, Long> tagStatus_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final PrimaryStatus DEFAULT_INSTANCE = new PrimaryStatus();
        private static final Parser<PrimaryStatus> PARSER = new AbstractParser<PrimaryStatus>(){

            public PrimaryStatus parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = PrimaryStatus.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private PrimaryStatus(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private PrimaryStatus() {
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new PrimaryStatus();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return ClusterServerProto.internal_static_cluster_StatusResponse_PrimaryStatus_descriptor;
        }

        protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
            switch (number) {
                case 1: {
                    return this.internalGetTagStatus();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ClusterServerProto.internal_static_cluster_StatusResponse_PrimaryStatus_fieldAccessorTable.ensureFieldAccessorsInitialized(PrimaryStatus.class, Builder.class);
        }

        private MapField<String, Long> internalGetTagStatus() {
            if (this.tagStatus_ == null) {
                return MapField.emptyMapField(TagStatusDefaultEntryHolder.defaultEntry);
            }
            return this.tagStatus_;
        }

        @Override
        public int getTagStatusCount() {
            return this.internalGetTagStatus().getMap().size();
        }

        @Override
        public boolean containsTagStatus(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetTagStatus().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, Long> getTagStatus() {
            return this.getTagStatusMap();
        }

        @Override
        public Map<String, Long> getTagStatusMap() {
            return this.internalGetTagStatus().getMap();
        }

        @Override
        public long getTagStatusOrDefault(String key, long defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetTagStatus().getMap();
            return map.containsKey(key) ? (Long)map.get(key) : defaultValue;
        }

        @Override
        public long getTagStatusOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetTagStatus().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (Long)map.get(key);
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetTagStatus(), TagStatusDefaultEntryHolder.defaultEntry, (int)1);
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            for (Map.Entry entry : this.internalGetTagStatus().getMap().entrySet()) {
                MapEntry tagStatus__ = TagStatusDefaultEntryHolder.defaultEntry.newBuilderForType().setKey((Object)((String)entry.getKey())).setValue((Object)((Long)entry.getValue())).build();
                size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)tagStatus__);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PrimaryStatus)) {
                return super.equals(obj);
            }
            PrimaryStatus other = (PrimaryStatus)obj;
            if (!this.internalGetTagStatus().equals(other.internalGetTagStatus())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + PrimaryStatus.getDescriptor().hashCode();
            if (!this.internalGetTagStatus().getMap().isEmpty()) {
                hash = 37 * hash + 1;
                hash = 53 * hash + this.internalGetTagStatus().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static PrimaryStatus parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (PrimaryStatus)PARSER.parseFrom(data);
        }

        public static PrimaryStatus parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (PrimaryStatus)PARSER.parseFrom(data, extensionRegistry);
        }

        public static PrimaryStatus parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (PrimaryStatus)PARSER.parseFrom(data);
        }

        public static PrimaryStatus parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (PrimaryStatus)PARSER.parseFrom(data, extensionRegistry);
        }

        public static PrimaryStatus parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (PrimaryStatus)PARSER.parseFrom(data);
        }

        public static PrimaryStatus parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (PrimaryStatus)PARSER.parseFrom(data, extensionRegistry);
        }

        public static PrimaryStatus parseFrom(InputStream input) throws IOException {
            return (PrimaryStatus)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static PrimaryStatus parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (PrimaryStatus)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static PrimaryStatus parseDelimitedFrom(InputStream input) throws IOException {
            return (PrimaryStatus)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static PrimaryStatus parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (PrimaryStatus)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static PrimaryStatus parseFrom(CodedInputStream input) throws IOException {
            return (PrimaryStatus)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static PrimaryStatus parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (PrimaryStatus)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return PrimaryStatus.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(PrimaryStatus prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static PrimaryStatus getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<PrimaryStatus> parser() {
            return PARSER;
        }

        public Parser<PrimaryStatus> getParserForType() {
            return PARSER;
        }

        public PrimaryStatus getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements PrimaryStatusOrBuilder {
            private int bitField0_;
            private MapField<String, Long> tagStatus_;

            public static final Descriptors.Descriptor getDescriptor() {
                return ClusterServerProto.internal_static_cluster_StatusResponse_PrimaryStatus_descriptor;
            }

            protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
                switch (number) {
                    case 1: {
                        return this.internalGetTagStatus();
                    }
                }
                throw new RuntimeException("Invalid map field number: " + number);
            }

            protected MapFieldReflectionAccessor internalGetMutableMapFieldReflection(int number) {
                switch (number) {
                    case 1: {
                        return this.internalGetMutableTagStatus();
                    }
                }
                throw new RuntimeException("Invalid map field number: " + number);
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return ClusterServerProto.internal_static_cluster_StatusResponse_PrimaryStatus_fieldAccessorTable.ensureFieldAccessorsInitialized(PrimaryStatus.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.internalGetMutableTagStatus().clear();
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return ClusterServerProto.internal_static_cluster_StatusResponse_PrimaryStatus_descriptor;
            }

            public PrimaryStatus getDefaultInstanceForType() {
                return PrimaryStatus.getDefaultInstance();
            }

            public PrimaryStatus build() {
                PrimaryStatus result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public PrimaryStatus buildPartial() {
                PrimaryStatus result = new PrimaryStatus(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(PrimaryStatus result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.tagStatus_ = this.internalGetTagStatus();
                    result.tagStatus_.makeImmutable();
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof PrimaryStatus) {
                    return this.mergeFrom((PrimaryStatus)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(PrimaryStatus other) {
                if (other == PrimaryStatus.getDefaultInstance()) {
                    return this;
                }
                this.internalGetMutableTagStatus().mergeFrom(other.internalGetTagStatus());
                this.bitField0_ |= 1;
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block9: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block9;
                            }
                            case 10: {
                                MapEntry tagStatus__ = (MapEntry)input.readMessage(TagStatusDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                                this.internalGetMutableTagStatus().getMutableMap().put((String)tagStatus__.getKey(), (Long)tagStatus__.getValue());
                                this.bitField0_ |= 1;
                                continue block9;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            private MapField<String, Long> internalGetTagStatus() {
                if (this.tagStatus_ == null) {
                    return MapField.emptyMapField(TagStatusDefaultEntryHolder.defaultEntry);
                }
                return this.tagStatus_;
            }

            private MapField<String, Long> internalGetMutableTagStatus() {
                if (this.tagStatus_ == null) {
                    this.tagStatus_ = MapField.newMapField(TagStatusDefaultEntryHolder.defaultEntry);
                }
                if (!this.tagStatus_.isMutable()) {
                    this.tagStatus_ = this.tagStatus_.copy();
                }
                this.bitField0_ |= 1;
                this.onChanged();
                return this.tagStatus_;
            }

            @Override
            public int getTagStatusCount() {
                return this.internalGetTagStatus().getMap().size();
            }

            @Override
            public boolean containsTagStatus(String key) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                return this.internalGetTagStatus().getMap().containsKey(key);
            }

            @Override
            @Deprecated
            public Map<String, Long> getTagStatus() {
                return this.getTagStatusMap();
            }

            @Override
            public Map<String, Long> getTagStatusMap() {
                return this.internalGetTagStatus().getMap();
            }

            @Override
            public long getTagStatusOrDefault(String key, long defaultValue) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                Map map = this.internalGetTagStatus().getMap();
                return map.containsKey(key) ? (Long)map.get(key) : defaultValue;
            }

            @Override
            public long getTagStatusOrThrow(String key) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                Map map = this.internalGetTagStatus().getMap();
                if (!map.containsKey(key)) {
                    throw new IllegalArgumentException();
                }
                return (Long)map.get(key);
            }

            public Builder clearTagStatus() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.internalGetMutableTagStatus().getMutableMap().clear();
                return this;
            }

            public Builder removeTagStatus(String key) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                this.internalGetMutableTagStatus().getMutableMap().remove(key);
                return this;
            }

            @Deprecated
            public Map<String, Long> getMutableTagStatus() {
                this.bitField0_ |= 1;
                return this.internalGetMutableTagStatus().getMutableMap();
            }

            public Builder putTagStatus(String key, long value) {
                if (key == null) {
                    throw new NullPointerException("map key");
                }
                this.internalGetMutableTagStatus().getMutableMap().put(key, value);
                this.bitField0_ |= 1;
                return this;
            }

            public Builder putAllTagStatus(Map<String, Long> values) {
                this.internalGetMutableTagStatus().getMutableMap().putAll(values);
                this.bitField0_ |= 1;
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }

        private static final class TagStatusDefaultEntryHolder {
            static final MapEntry<String, Long> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)ClusterServerProto.internal_static_cluster_StatusResponse_PrimaryStatus_TagStatusEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.INT64, (Object)0L);

            private TagStatusDefaultEntryHolder() {
            }
        }
    }

    public static interface PrimaryStatusOrBuilder
    extends MessageOrBuilder {
        public int getTagStatusCount();

        public boolean containsTagStatus(String var1);

        @Deprecated
        public Map<String, Long> getTagStatus();

        public Map<String, Long> getTagStatusMap();

        public long getTagStatusOrDefault(String var1, long var2);

        public long getTagStatusOrThrow(String var1);
    }

    public static interface ClusterTopologyStatusOrBuilder
    extends MessageOrBuilder {
        public boolean hasPrimaryStatus();

        public PrimaryStatus getPrimaryStatus();

        public PrimaryStatusOrBuilder getPrimaryStatusOrBuilder();

        public boolean hasSecondaryStatus();

        public SecondaryStatus getSecondaryStatus();

        public SecondaryStatusOrBuilder getSecondaryStatusOrBuilder();

        public ClusterTopologyStatus.KindCase getKindCase();
    }
}

