/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.grpc;

import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.raft.node.RaftHandlerService;
import com.ontotext.graphdb.raft.node.RaftNode;
import com.ontotext.graphdb.raft.recovery.RecoveryService;
import com.ontotext.graphdb.raft.security.AuthenticatorInterceptor;
import com.ontotext.graphdb.raft.security.MDCHeadersServerInterceptor;
import com.ontotext.graphdb.raft.security.SSLInterceptor;
import com.ontotext.graphdb.raft.security.SecurityConfig;
import com.ontotext.graphdb.raft.security.SecurityUtil;
import io.grpc.BindableService;
import io.grpc.HandlerRegistry;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.util.MutableHandlerRegistry;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class RpcServer {
    private final RaftHandlerService raftService;
    private final RecoveryService recoveryService;
    private final Server server;
    protected final MutableHandlerRegistry serviceRegistry = new MutableHandlerRegistry();
    private final String address;
    private NamedThreadFactory threadFactory;
    private ExecutorService executor;

    public RpcServer(List<BindableService> services, String address, int port) {
        this(services, address, port, null);
    }

    public RpcServer(List<BindableService> services, String address, int port, ServerInterceptor debugInterceptor) {
        this(address, services, x -> x.createTcpServerBuilder(address, port), debugInterceptor);
    }

    protected <T extends RpcServer> RpcServer(String address, List<BindableService> services, Function<T, ServerBuilder<?>> serverBuilder, ServerInterceptor debugInterceptor) {
        this.address = address;
        this.raftService = new RaftHandlerService();
        this.recoveryService = new RecoveryService(this.raftService::getRaftNode);
        this.server = this.createServer(services, serverBuilder.apply(this), debugInterceptor);
    }

    public int getPort() {
        return this.server.getPort();
    }

    public void start() throws IOException {
        this.server.start();
        this.setupShutdownHook();
        if (this.threadFactory != null) {
            this.threadFactory.setThreadName(this.address + ":" + this.server.getPort() + "-grpc-executor-%d");
        }
    }

    protected void setupShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            RaftNode raftNode = this.raftService.getRaftNode();
            if (raftNode != null) {
                raftNode.shutdown();
            }
            try {
                this.stop();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                e.printStackTrace(System.err);
            }
        }));
    }

    public void stop() throws InterruptedException {
        if (!this.server.isTerminated()) {
            try {
                this.getRecoveryService().shutdown();
            }
            finally {
                try {
                    this.server.shutdown().awaitTermination(30L, TimeUnit.SECONDS);
                }
                finally {
                    if (this.executor != null) {
                        this.executor.shutdownNow();
                        this.executor = null;
                    }
                }
            }
        }
    }

    public boolean isStopped() {
        return this.server.isTerminated();
    }

    public void injectRaftNode(RaftNode raftNode) {
        this.raftService.injectRaftNode(raftNode);
    }

    public Optional<RaftNode> getRaftNode() {
        return Optional.ofNullable(this.raftService.getRaftNode());
    }

    public void removeRaftNode() {
        this.raftService.removeRaftNode();
    }

    public void addService(BindableService bindableService) {
        this.serviceRegistry.addService(bindableService);
    }

    public void removeService(BindableService bindableService) {
        this.serviceRegistry.removeService(bindableService.bindService());
    }

    protected Server createServer(List<BindableService> services, ServerBuilder<?> builder, ServerInterceptor debugInterceptor) {
        if (debugInterceptor != null) {
            builder.intercept(debugInterceptor);
        }
        for (BindableService service : services) {
            builder.addService(service);
        }
        builder.addService((BindableService)this.raftService);
        this.addService(this.recoveryService);
        if (debugInterceptor != null) {
            builder.executor((Executor)this.createExecutor());
        }
        return builder.build();
    }

    private ExecutorService createExecutor() {
        if (this.executor == null) {
            this.threadFactory = new NamedThreadFactory();
            this.executor = Executors.newCachedThreadPool(this.threadFactory);
        }
        return this.executor;
    }

    protected ServerBuilder<?> createTcpServerBuilder(String address, int port) {
        ServerCredentials serverCredentials = SecurityUtil.createServerCredentials((SecurityConfig)SecurityConfig.INSTANCE);
        return ((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)(address != null ? new InetSocketAddress(address, port) : new InetSocketAddress(port)), (ServerCredentials)serverCredentials).fallbackHandlerRegistry((HandlerRegistry)this.serviceRegistry)).intercept((ServerInterceptor)new AuthenticatorInterceptor(() -> address != null ? address + ":" + this.server.getPort() : Config.getRPCAddress()))).intercept((ServerInterceptor)new SSLInterceptor())).intercept((ServerInterceptor)new MDCHeadersServerInterceptor());
    }

    public RecoveryService getRecoveryService() {
        return this.recoveryService;
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private static final AtomicLong threadCount = new AtomicLong(0L);
        private String nameFormat = "grpc-default-executor-%d";
        private final ThreadFactory backingThreadFactory = Executors.defaultThreadFactory();

        private NamedThreadFactory() {
        }

        @Override
        public Thread newThread(@NotNull Runnable runnable) {
            Thread thread = this.backingThreadFactory.newThread(runnable);
            if (this.nameFormat != null) {
                thread.setName(NamedThreadFactory.format(this.nameFormat, threadCount.getAndIncrement()));
            }
            return thread;
        }

        private static String format(String format, Object ... args) {
            return String.format(Locale.ROOT, format, args);
        }

        public void setThreadName(String name) {
            this.nameFormat = name;
        }
    }
}

