/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft;

import com.ontotext.graphdb.raft.RecoveryOperation;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class RecoveryState {
    private AtomicReference<RecoveryOperation> currentState = new AtomicReference<RecoveryOperation>(RecoveryOperation.NO_RECOVERY_OPERATION);
    private volatile Set<String> affectedNodeAddresses = new HashSet<String>();

    public void setStateToSearchingForNode() {
        this.currentState.compareAndSet(RecoveryOperation.NO_RECOVERY_OPERATION, RecoveryOperation.SEARCHING_FOR_NODE);
        this.affectedNodeAddresses.clear();
    }

    public void setStateToWaitingForSnapshot(String nodeAddress) {
        this.currentState.compareAndSet(RecoveryOperation.SEARCHING_FOR_NODE, RecoveryOperation.WAITING_FOR_SNAPSHOT);
        this.affectedNodeAddresses.add(nodeAddress);
    }

    public void setStateToRecordingSnapshot(String nodeAddress) {
        this.currentState.compareAndSet(RecoveryOperation.WAITING_FOR_SNAPSHOT, RecoveryOperation.RECEIVING_SNAPSHOT);
        this.affectedNodeAddresses.add(nodeAddress);
    }

    public void setStateToApplySnapshot() {
        this.currentState.compareAndSet(RecoveryOperation.RECEIVING_SNAPSHOT, RecoveryOperation.APPLYING_SNAPSHOT);
        this.affectedNodeAddresses.clear();
    }

    public void setStateToBuildingSnapshot(String nodeAddress) {
        this.currentState.compareAndSet(RecoveryOperation.NO_RECOVERY_OPERATION, RecoveryOperation.BUILDING_SNAPSHOT);
        this.affectedNodeAddresses.add(nodeAddress);
    }

    public void setStateToSendingSnapshot(String nodeAddress) {
        this.currentState.compareAndSet(RecoveryOperation.NO_RECOVERY_OPERATION, RecoveryOperation.SENDING_SNAPSHOT);
        this.currentState.compareAndSet(RecoveryOperation.BUILDING_SNAPSHOT, RecoveryOperation.SENDING_SNAPSHOT);
        this.affectedNodeAddresses.add(nodeAddress);
    }

    public void setStateToNoRecovery() {
        this.currentState.set(RecoveryOperation.NO_RECOVERY_OPERATION);
        this.affectedNodeAddresses.clear();
    }

    public AtomicReference<RecoveryOperation> getCurrentState() {
        return this.currentState;
    }

    public Set<String> getAffectedNodeAddresses() {
        return this.affectedNodeAddresses;
    }

    public void setStateRecoveryOperationFailureWarning(String currentAddress, Set<String> failedClientAddresses) {
        this.currentState.set(RecoveryOperation.RECOVERY_OPERATION_FAILURE_WARNING.setMessage(String.format("Node '%s' unable to recover. Action required. Insufficient disk space to create snapshot on nodes '%s'", currentAddress, String.join((CharSequence)", ", failedClientAddresses))));
        this.affectedNodeAddresses.addAll(failedClientAddresses);
    }

    public String getCurrentStateMessage() {
        return this.currentState.get().getMessage();
    }
}

