/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.raft.StateMachine;
import com.ontotext.graphdb.raft.grpc.NodeInfo;
import com.ontotext.graphdb.raft.grpc.RpcNodeClient;
import com.ontotext.graphdb.raft.recovery.RaftRecoveryException;
import com.ontotext.graphdb.raft.storage.TransactionLog;
import com.ontotext.graphdb.raft.storage.log.persistent.PersistentTransactionLog;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterGroup
implements Iterable<RpcNodeClient> {
    private static final Logger logger = LoggerFactory.getLogger(ClusterGroup.class);
    public static final String RAFT_ELECTION_MIN_MS = "graphdb.raft.election.min.ms";
    public static final String RAFT_ELECTION_RANGE_MS = "graphdb.raft.election.range.ms";
    public static final String RAFT_ELECTION_HEARTBEAT_MS = "graphdb.raft.election.heartbeat.ms";
    public static final String RAFT_RPC_MESSAGE_SIZE = "graphdb.raft.rpc.message.size";
    public static final String RAFT_RPC_VERIFICATION_MS = "graphdb.raft.rpc.verification.ms";
    public static final String RAFT_RECOVERY_RETRY_MS = "graphdb.raft.rpc.recovery.ms";
    public static final String TRANSACTION_LOG_THRESHOLD_GB = "graphdb.raft.transaction.log.threshold.gb";
    public static final String BATCH_UPDATE_INTERVAL = "graphdb.raft.batch.update.interval.ms";
    public static final Integer ELECTION_MIN_MS_DEFAULT = 8000;
    public static final Integer ELECTION_RANGE_MS_DEFAULT = 6000;
    public static final Integer HEARTBEAT_DEFAULT = 2000;
    public static final Integer MESSAGE_SIZE_KB_DEFAULT = 64;
    public static final Integer VERIFICATION_DEFAULT = 300;
    public static final Integer RECOVERY_MS_DEFAULT = 20000;
    public static final Integer BATCH_UPDATE_INTERVAL_MS_DEFAULT = 5000;
    public static final Float TRANSACTION_LOG_THRESHOLD_DEFAULT = Float.valueOf(50.0f);
    protected final Map<String, RpcNodeClient> nodeChannels;
    protected final List<NodeInfo> nodeIds;
    protected final Map<String, Long> tagMap;
    protected final AtomicReference<RpcNodeClient> primaryLeader;
    protected final Map<String, RpcNodeClient> primaryNodeChannels;
    protected final List<NodeInfo> primaryNodeIds;
    protected final AtomicReference<String> secondaryTag;
    protected final AtomicLong primaryIndex;
    protected final AtomicInteger updateCounter;
    protected AtomicBoolean nodeIdsInitialized;
    protected final NodeInfo currentAddress;
    protected final int currentId;
    protected final ReadWriteLock systemLock;
    protected final TransactionLog log;
    protected final StateMachine machine;
    protected int timeoutMsMin;
    protected int timeoutRange;
    protected int heartbeatInterval;
    protected int messageSizeKB;
    protected int messageSizeBytes;
    protected int verificationMs;
    protected int recoveryMs;
    protected int batchUpdateIntervalMs;
    protected float transactionLogThresholdGB;
    protected final Random random;
    private final AtomicBoolean isRecovering;
    private final AtomicBoolean isStreaming;
    private final AtomicBoolean isBuildingSnapshot;
    private final AtomicBoolean isSecondary;

    @VisibleForTesting
    public ClusterGroup(List<NodeInfo> nodeIds, NodeInfo currentAddress, StateMachine machine) {
        this(nodeIds, Collections.emptyList(), currentAddress, new PersistentTransactionLog(), machine, 0L, null);
    }

    @VisibleForTesting
    public ClusterGroup(List<NodeInfo> nodeIds, NodeInfo currentAddress, TransactionLog log, StateMachine machine) {
        this(nodeIds, Collections.emptyList(), currentAddress, log, machine, 0L, null);
    }

    protected ClusterGroup(List<NodeInfo> nodeIds, List<NodeInfo> primaryNodeIds, NodeInfo currentAddress, TransactionLog log, StateMachine machine, long primaryIndex, String secondaryTag) {
        this(nodeIds, primaryNodeIds, currentAddress, log, machine, Config.getPropertyAsInt((String)RAFT_ELECTION_MIN_MS, (int)ELECTION_MIN_MS_DEFAULT), Config.getPropertyAsInt((String)RAFT_ELECTION_RANGE_MS, (int)ELECTION_RANGE_MS_DEFAULT), Config.getPropertyAsInt((String)RAFT_ELECTION_HEARTBEAT_MS, (int)HEARTBEAT_DEFAULT), Config.getPropertyAsInt((String)RAFT_RPC_MESSAGE_SIZE, (int)MESSAGE_SIZE_KB_DEFAULT), Config.getPropertyAsInt((String)RAFT_RPC_VERIFICATION_MS, (int)VERIFICATION_DEFAULT), Config.getPropertyAsFloat((String)TRANSACTION_LOG_THRESHOLD_GB, (float)TRANSACTION_LOG_THRESHOLD_DEFAULT.floatValue()), Config.getPropertyAsInt((String)BATCH_UPDATE_INTERVAL, (int)BATCH_UPDATE_INTERVAL_MS_DEFAULT), primaryIndex, secondaryTag, Collections.emptySet());
    }

    public ClusterGroup(List<NodeInfo> nodeIds, List<NodeInfo> primaryNodeIds, NodeInfo currentAddress, TransactionLog log, StateMachine machine, int timeoutMsMin, int timeoutRange, int heartbeatInterval, int messageSizeKB, int verificationMs, float transactionLogThreshold, int batchUpdateInterval, long primaryIndex, String secondaryTag, Set<String> tagMap) {
        this.currentAddress = currentAddress;
        this.currentId = System.identityHashCode(currentAddress.getRpcAddress().intern());
        this.machine = machine;
        this.timeoutMsMin = timeoutMsMin;
        this.timeoutRange = timeoutRange;
        this.heartbeatInterval = heartbeatInterval;
        this.messageSizeKB = messageSizeKB;
        this.messageSizeBytes = messageSizeKB * 1024;
        this.verificationMs = verificationMs;
        this.batchUpdateIntervalMs = BATCH_UPDATE_INTERVAL_MS_DEFAULT;
        this.recoveryMs = Config.getPropertyAsInt((String)RAFT_RECOVERY_RETRY_MS, (int)RECOVERY_MS_DEFAULT);
        this.nodeIds = new LinkedList<NodeInfo>(nodeIds);
        this.primaryLeader = new AtomicReference();
        this.tagMap = new ConcurrentHashMap<String, Long>(tagMap.stream().collect(Collectors.toMap(k -> k, v -> 0L)));
        this.primaryNodeIds = Collections.synchronizedList(new LinkedList<NodeInfo>(primaryNodeIds));
        this.isSecondary = new AtomicBoolean(!primaryNodeIds.isEmpty());
        this.primaryIndex = new AtomicLong(primaryIndex);
        this.secondaryTag = new AtomicReference<String>(secondaryTag);
        this.nodeIdsInitialized = new AtomicBoolean(false);
        this.log = log;
        this.nodeChannels = new ConcurrentHashMap<String, RpcNodeClient>();
        this.primaryNodeChannels = new ConcurrentHashMap<String, RpcNodeClient>();
        this.systemLock = new ReentrantReadWriteLock();
        this.random = new Random();
        this.isRecovering = new AtomicBoolean(false);
        this.isStreaming = new AtomicBoolean(false);
        this.isBuildingSnapshot = new AtomicBoolean(false);
        this.updateCounter = new AtomicInteger(0);
        this.transactionLogThresholdGB = transactionLogThreshold;
        this.batchUpdateIntervalMs = batchUpdateInterval;
    }

    public void generateNodeChannels() {
        if (this.nodeIdsInitialized.compareAndSet(false, true)) {
            String rpcAddress;
            for (NodeInfo nodeInfo : this.nodeIds) {
                rpcAddress = nodeInfo.getRpcAddress();
                if (rpcAddress.equals(this.currentAddress.getRpcAddress())) continue;
                this.nodeChannels.put(rpcAddress, this.createRpcNodeClient(rpcAddress, this.log.getLastLogIndex() + 1L));
            }
            if (this.isSecondary()) {
                for (NodeInfo nodeInfo : this.primaryNodeIds) {
                    rpcAddress = nodeInfo.getRpcAddress();
                    if (rpcAddress.equals(this.currentAddress.getRpcAddress())) continue;
                    this.primaryNodeChannels.put(rpcAddress, this.createRpcNodeClient(rpcAddress, this.log.getLastLogIndex() + 1L));
                }
            }
        }
    }

    protected RpcNodeClient createRpcNodeClient(String clientAddress, long nextIndex) {
        return new RpcNodeClient(clientAddress, nextIndex, this.getCurrentAddress(), this.getMessageSizeBytes());
    }

    public void updateProperties(Map<String, Number> properties) {
        this.timeoutMsMin = (Integer)properties.getOrDefault(RAFT_ELECTION_MIN_MS, this.timeoutMsMin);
        this.timeoutRange = (Integer)properties.getOrDefault(RAFT_ELECTION_RANGE_MS, this.timeoutRange);
        this.heartbeatInterval = (Integer)properties.getOrDefault(RAFT_ELECTION_HEARTBEAT_MS, this.heartbeatInterval);
        this.messageSizeKB = (Integer)properties.getOrDefault(RAFT_RPC_MESSAGE_SIZE, this.messageSizeKB);
        this.verificationMs = (Integer)properties.getOrDefault(RAFT_RPC_VERIFICATION_MS, this.verificationMs);
        this.transactionLogThresholdGB = ((Float)properties.getOrDefault(TRANSACTION_LOG_THRESHOLD_GB, Float.valueOf(this.transactionLogThresholdGB))).floatValue();
        this.batchUpdateIntervalMs = (Integer)properties.getOrDefault(BATCH_UPDATE_INTERVAL, this.batchUpdateIntervalMs);
    }

    @VisibleForTesting
    public String getNode(int i) {
        return this.nodeIds.get(i).getRpcAddress();
    }

    public Optional<NodeInfo> getNodeByRpcAddress(String rpcAddress) {
        if (rpcAddress == null) {
            return Optional.empty();
        }
        return this.nodeIds.stream().filter(node -> node.getRpcAddress().equals(rpcAddress)).findFirst();
    }

    public boolean containsNode(String nodeId) {
        return this.nodeIds.stream().map(NodeInfo::getRpcAddress).anyMatch(Predicate.isEqual(nodeId));
    }

    public TransactionLog getTransactionLog() {
        return this.log;
    }

    public NodeInfo getCurrentNode() {
        return this.currentAddress;
    }

    public String getCurrentAddress() {
        return this.currentAddress.getRpcAddress();
    }

    public ReadWriteLock getSystemLock() {
        return this.systemLock;
    }

    public String getCurrentHttpAddress() {
        return this.currentAddress.getHttpAddress();
    }

    public int getCurrentId() {
        return this.currentId;
    }

    public Map<String, Long> getTagMap() {
        return this.tagMap;
    }

    public void addTag(String tag) {
        this.tagMap.putIfAbsent(tag, 0L);
    }

    public void removeTag(String tag) {
        this.tagMap.remove(tag);
    }

    public String getSecondaryTag() {
        return this.secondaryTag.get();
    }

    public void setSecondaryTag(String secondaryTag) {
        this.secondaryTag.set(secondaryTag);
    }

    public RpcNodeClient getClusterRpcNode(String address) {
        return this.nodeChannels.get(address);
    }

    public RpcNodeClient getPrimaryRpcNode(String address) {
        return this.primaryNodeChannels.get(address);
    }

    public Collection<RpcNodeClient> getPrimaryNodes() {
        return this.primaryNodeChannels.values();
    }

    public RpcNodeClient getPrimaryLeader() {
        return this.primaryLeader.get();
    }

    public boolean setPrimaryLeader(RpcNodeClient leader) {
        return this.primaryLeader.compareAndSet(null, leader);
    }

    public void resetPrimaryLeader() {
        this.primaryLeader.set(null);
    }

    public RpcNodeClient removeClusterRpcNode(NodeInfo nodeInfo) {
        RpcNodeClient nodeClient;
        if (this.nodeIds.remove(nodeInfo)) {
            logger.debug("Disconnecting client {}", (Object)nodeInfo.getRpcAddress());
        }
        if ((nodeClient = this.nodeChannels.remove(nodeInfo.getRpcAddress())) != null) {
            nodeClient.shutdown();
        }
        return nodeClient;
    }

    public Optional<RpcNodeClient> addClusterRpcNode(NodeInfo nodeInfo) {
        if (!this.nodeIds.contains(nodeInfo)) {
            this.nodeIds.add(nodeInfo);
        }
        if (!this.getCurrentNode().equals(nodeInfo)) {
            long currentLastLogIndex = this.log.getLastLogIndex();
            return Optional.of(this.nodeChannels.computeIfAbsent(nodeInfo.getRpcAddress(), nodeAddress -> this.createRpcNodeClient((String)nodeAddress, currentLastLogIndex + 1L)));
        }
        return Optional.empty();
    }

    public int size() {
        return this.nodeIds.size();
    }

    public void shutdown() {
        this.machine.shutdown();
        for (RpcNodeClient rpcNode : this.nodeChannels.values()) {
            rpcNode.shutdown();
        }
        for (RpcNodeClient rpcNode : this.primaryNodeChannels.values()) {
            rpcNode.shutdown();
        }
    }

    public void deleteRaftDirectories() {
        this.machine.deleteClusterRecoveryDir();
        this.getTransactionLog().delete();
    }

    public void reset() {
        this.shutdown();
        if (this.nodeIdsInitialized.get()) {
            this.nodeChannels.replaceAll((clientAddress, v) -> this.createRpcNodeClient((String)clientAddress, this.log.getLastLogIndex() + 1L));
        } else {
            this.generateNodeChannels();
        }
    }

    public boolean tryLockSnapshotBuild(long timeoutMs) {
        boolean locked = false;
        try {
            locked = this.machine.tryLockMachine(timeoutMs);
            if (!locked) {
                return false;
            }
            this.log.lockTransactionLog();
            logger.info("Successfully locked cluster node to build snapshot");
            return true;
        }
        catch (Exception e) {
            if (locked) {
                try {
                    this.machine.unlockMachine();
                }
                catch (Exception ex) {
                    e.addSuppressed(ex);
                }
            }
            throw e;
        }
    }

    public void lockSnapshotBuild() {
        boolean lockedStateMachine = false;
        try {
            this.machine.lockMachine();
            lockedStateMachine = true;
            this.log.lockTransactionLog();
            this.setBuildingSnapshot(true);
            logger.info("Successfully locked cluster node to build snapshot");
        }
        catch (Exception e) {
            if (lockedStateMachine) {
                try {
                    this.setBuildingSnapshot(false);
                    this.machine.unlockMachine();
                }
                catch (Exception e1) {
                    e.addSuppressed(e1);
                }
            }
            throw e;
        }
    }

    public void unlockSnapshotBuild() {
        try {
            this.setBuildingSnapshot(false);
            this.log.unlockTransactionLog();
        }
        finally {
            this.machine.unlockMachine();
        }
    }

    public boolean lockSnapshotApply() {
        boolean alreadyRecovering = false;
        boolean machineLocked = false;
        boolean systemLocked = false;
        try {
            if (!this.isRecovering.compareAndSet(false, true)) {
                alreadyRecovering = true;
                throw new RaftRecoveryException("Cluster node is already attempting to recover");
            }
            this.systemLock.writeLock().lock();
            systemLocked = true;
            this.machine.lockMachine();
            machineLocked = true;
            this.log.shutdown(true);
            logger.info("Successfully locked cluster node to apply snapshot");
            return true;
        }
        catch (Exception e) {
            if (!alreadyRecovering) {
                if (machineLocked) {
                    try {
                        this.machine.unlockMachine();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (systemLocked) {
                    try {
                        this.systemLock.writeLock().unlock();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.isRecovering.set(false);
            }
            throw e;
        }
    }

    public void unlockSnapshotApply() {
        boolean machineUnlocked = false;
        boolean systemUnlocked = false;
        try {
            this.log.initialize();
            this.machine.unlockMachine();
            machineUnlocked = true;
            this.systemLock.writeLock().unlock();
            systemUnlocked = true;
            logger.info("Successfully unlocked cluster node after snapshot recovery");
        }
        catch (Exception e) {
            if (!machineUnlocked) {
                try {
                    this.machine.unlockMachine();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!systemUnlocked) {
                try {
                    this.systemLock.writeLock().unlock();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw e;
        }
        finally {
            this.isRecovering.set(false);
        }
    }

    @Override
    public Iterator<RpcNodeClient> iterator() {
        return this.nodeChannels.values().iterator();
    }

    public long getPrimaryIndex() {
        return this.primaryIndex.get();
    }

    public void setPrimaryIndex(long primaryIndex) {
        this.primaryIndex.set(primaryIndex);
    }

    public void setIsSecondary(boolean isSecondary) {
        this.isSecondary.set(isSecondary);
    }

    public void setPrimaryNodes(List<NodeInfo> primaryNodes) {
        if (primaryNodes.isEmpty()) {
            this.isSecondary.set(false);
            this.primaryNodeIds.clear();
            try {
                for (RpcNodeClient rpcNodeClient : this.primaryNodeChannels.values()) {
                    rpcNodeClient.shutdown();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.primaryNodeChannels.clear();
        } else {
            this.isSecondary.set(true);
            this.primaryNodeIds.clear();
            this.primaryNodeIds.addAll(primaryNodes);
            for (String string : this.primaryNodeChannels.keySet()) {
                if (!this.primaryNodeIds.stream().noneMatch(info -> info.getRpcAddress().equals(string))) continue;
                RpcNodeClient ch = this.primaryNodeChannels.remove(string);
                try {
                    ch.shutdown();
                }
                catch (Exception exception) {}
            }
            for (NodeInfo nodeInfo : this.primaryNodeIds) {
                if (this.primaryNodeChannels.containsKey(nodeInfo.getRpcAddress())) continue;
                this.primaryNodeChannels.putIfAbsent(nodeInfo.getRpcAddress(), this.createRpcNodeClient(nodeInfo.getRpcAddress(), this.log.getLastLogIndex() + 1L));
            }
        }
    }

    public int getRandomTimeout() {
        return this.timeoutMsMin + this.random.nextInt(this.timeoutRange);
    }

    public int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public int getMessageSizeBytes() {
        return this.messageSizeBytes;
    }

    public int getMessageSizeKB() {
        return this.messageSizeKB;
    }

    public int getVerificationTimeout() {
        return this.verificationMs;
    }

    public int getRecoveryTimeout() {
        return this.recoveryMs;
    }

    public StateMachine getStateMachine() {
        return this.machine;
    }

    public int getTimeoutMsMin() {
        return this.timeoutMsMin;
    }

    public int getTimeoutRange() {
        return this.timeoutRange;
    }

    public int getBatchUpdateIntervalMs() {
        return this.timeoutRange;
    }

    public long getTransactionLogThreshold() {
        return (long)(this.transactionLogThresholdGB * 1024.0f * 1024.0f * 1024.0f);
    }

    public String getClusterParametersAsString() {
        return "graphdb.raft.election.min.ms=" + this.getTimeoutMsMin() + ";graphdb.raft.election.range.ms=" + this.getTimeoutRange() + ";graphdb.raft.election.heartbeat.ms=" + this.getHeartbeatInterval() + ";graphdb.raft.rpc.message.size=" + this.getMessageSizeKB() + ";graphdb.raft.rpc.verification.ms=" + this.getVerificationTimeout() + ";graphdb.raft.transaction.log.threshold.gb=" + this.getTransactionLogMaxSizeGB() + ";graphdb.raft.batch.update.interval.ms=" + this.getBatchUpdateIntervalMs() + ";";
    }

    public float getTransactionLogMaxSizeGB() {
        return this.transactionLogThresholdGB;
    }

    public List<String> getNodeIds() {
        return this.nodeIds.stream().map(NodeInfo::getRpcAddress).collect(Collectors.toUnmodifiableList());
    }

    public List<NodeInfo> getNodes() {
        return Collections.unmodifiableList(this.nodeIds);
    }

    public boolean isRecovering() {
        return this.isRecovering.get();
    }

    public AtomicBoolean getRecoveryFlag() {
        return this.isRecovering;
    }

    public void setStreaming(boolean streaming) {
        this.isStreaming.set(streaming);
    }

    public boolean isProcessingUpdates() {
        return this.updateCounter.get() > 0;
    }

    public void incrementUpdate() {
        this.updateCounter.incrementAndGet();
    }

    public void decrementUpdate() {
        this.updateCounter.decrementAndGet();
    }

    public boolean isStreaming() {
        return this.isStreaming.get();
    }

    public boolean isSecondary() {
        return this.isSecondary.get();
    }

    public boolean isBuildingSnapshot() {
        return this.isBuildingSnapshot.get();
    }

    public void setBuildingSnapshot(boolean isBuilding) {
        this.isBuildingSnapshot.set(isBuilding);
    }
}

