/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteOutput;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Internal;
import com.google.protobuf.Utf8;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class GraphDBByteString
extends ByteString.LeafByteString {
    private static final long serialVersionUID = 1L;
    protected final byte[] bytes;

    public GraphDBByteString(byte[] bytes) {
        Objects.requireNonNull(bytes);
        this.bytes = bytes;
    }

    public GraphDBByteString(byte[] bytes, int lastIndex) {
        Objects.requireNonNull(bytes);
        this.bytes = lastIndex < bytes.length ? Arrays.copyOfRange(bytes, 0, lastIndex) : bytes;
    }

    public byte byteAt(int index) {
        return this.bytes[index];
    }

    byte internalByteAt(int index) {
        return this.bytes[index];
    }

    public int size() {
        return this.bytes.length;
    }

    public ByteString substring(int beginIndex, int endIndex) {
        throw new UnsupportedOperationException("Not supported");
    }

    protected void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
        System.arraycopy(this.bytes, sourceOffset, target, targetOffset, numberToCopy);
    }

    public final void copyTo(ByteBuffer target) {
        target.put(this.bytes, this.getOffsetIntoBytes(), this.size());
    }

    public final ByteBuffer asReadOnlyByteBuffer() {
        return ByteBuffer.wrap(this.bytes, this.getOffsetIntoBytes(), this.size()).asReadOnlyBuffer();
    }

    public final List<ByteBuffer> asReadOnlyByteBufferList() {
        return Collections.singletonList(this.asReadOnlyByteBuffer());
    }

    public final void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.toByteArray());
    }

    final void writeToInternal(OutputStream outputStream, int sourceOffset, int numberToWrite) throws IOException {
        outputStream.write(this.bytes, this.getOffsetIntoBytes() + sourceOffset, numberToWrite);
    }

    final void writeTo(ByteOutput output) throws IOException {
        output.writeLazy(this.bytes, this.getOffsetIntoBytes(), this.size());
    }

    protected final String toStringInternal(Charset charset) {
        return new String(this.bytes, this.getOffsetIntoBytes(), this.size(), charset);
    }

    public final boolean isValidUtf8() {
        int offset = this.getOffsetIntoBytes();
        return Utf8.isValidUtf8((byte[])this.bytes, (int)offset, (int)(offset + this.size()));
    }

    protected final int partialIsValidUtf8(int state, int offset, int length) {
        int index = this.getOffsetIntoBytes() + offset;
        return Utf8.partialIsValidUtf8((int)state, (byte[])this.bytes, (int)index, (int)(index + length));
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ByteString)) {
            return false;
        }
        if (this.size() != ((ByteString)other).size()) {
            return false;
        }
        if (this.size() == 0) {
            return true;
        }
        if (other instanceof ByteString) {
            ByteString otherAsLiteral = (ByteString)other;
            int thisHash = this.peekCachedHashCode();
            int thatHash = otherAsLiteral.peekCachedHashCode();
            if (thisHash != 0 && thatHash != 0 && thisHash != thatHash) {
                return false;
            }
            return this.equalsRange((ByteString)other, 0, this.size());
        }
        return other.equals((Object)this);
    }

    final boolean equalsRange(ByteString other, int offset, int length) {
        if (length > other.size()) {
            throw new IllegalArgumentException("Length too large: " + length + this.size());
        }
        if (offset + length > other.size()) {
            throw new IllegalArgumentException("Ran off end of other: " + offset + ", " + length + ", " + other.size());
        }
        byte[] otherBytes = other.toByteArray();
        int thisLimit = this.getOffsetIntoBytes() + length;
        int thisIndex = this.getOffsetIntoBytes();
        int otherIndex = offset;
        while (thisIndex < thisLimit) {
            if (this.bytes[thisIndex] != otherBytes[otherIndex]) {
                return false;
            }
            ++thisIndex;
            ++otherIndex;
        }
        return true;
    }

    protected final int partialHash(int h, int offset, int length) {
        return Internal.partialHash((int)h, (byte[])this.bytes, (int)(this.getOffsetIntoBytes() + offset), (int)length);
    }

    public final InputStream newInput() {
        return new ByteArrayInputStream(this.bytes, this.getOffsetIntoBytes(), this.size());
    }

    public final CodedInputStream newCodedInput() {
        return CodedInputStream.newInstance((byte[])this.bytes, (int)this.getOffsetIntoBytes(), (int)this.size(), (boolean)true);
    }

    protected int getOffsetIntoBytes() {
        return 0;
    }
}

