/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.util;

import com.ontotext.graphdb.statistics.StatisticsListener;
import com.ontotext.trree.OwlimSchemaRepository;
import com.ontotext.trree.SailConnectionImpl;
import com.ontotext.trree.SchemaRepositoryAccess;
import com.ontotext.trree.sdk.Repository;
import com.ontotext.trree.sdk.impl.DummyPluginRepository;
import com.ontotext.trree.sdk.impl.SailConnectionPluginRepository;
import com.ontotext.trree.statistics.StatisticsSettings;
import java.util.function.BiConsumer;
import org.eclipse.rdf4j.sail.SailConnection;

public class StatisticsUtil {
    private StatisticsUtil() {
    }

    public static StatisticsListener getStatisticsListenerFromRepository(Repository repository) {
        if (!StatisticsSettings.getInstance().isStatisticsEnabled()) {
            return null;
        }
        if (!(repository instanceof SailConnectionPluginRepository)) {
            return null;
        }
        SailConnectionPluginRepository pluginRepository = (SailConnectionPluginRepository)repository;
        SailConnection sailConn = pluginRepository.getSailConnection();
        if (!(sailConn instanceof SailConnectionImpl)) {
            return null;
        }
        SchemaRepositoryAccess owlim = ((SailConnectionImpl)sailConn).getOwlim();
        if (!(owlim instanceof OwlimSchemaRepository)) {
            return null;
        }
        OwlimSchemaRepository owlimSchemaRepository = (OwlimSchemaRepository)owlim;
        return owlimSchemaRepository.getStatistics();
    }

    public static BiConsumer<String, Boolean> getPluginCreationCounter(Repository repository) {
        if (!StatisticsSettings.getInstance().isStatisticsEnabled()) {
            return null;
        }
        if (repository instanceof DummyPluginRepository) {
            DummyPluginRepository dummyPluginRepository = (DummyPluginRepository)repository;
            return dummyPluginRepository.getCountPluginCreation();
        }
        if (!(repository instanceof SailConnectionPluginRepository)) {
            return null;
        }
        SailConnectionPluginRepository pluginRepository = (SailConnectionPluginRepository)repository;
        SailConnection sailConn = pluginRepository.getSailConnection();
        if (!(sailConn instanceof SailConnectionImpl)) {
            return null;
        }
        SchemaRepositoryAccess owlim = ((SailConnectionImpl)sailConn).getOwlim();
        if (!(owlim instanceof OwlimSchemaRepository)) {
            return null;
        }
        OwlimSchemaRepository owlimSchemaRepository = (OwlimSchemaRepository)owlim;
        return (pluginName, success) -> owlimSchemaRepository.getStatistics().incrementConnectorPluginCreations(pluginName, success.booleanValue());
    }
}

