/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.impex;

import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.repository.RepositoryIdChangedListener;
import com.ontotext.forest.impex.FileTasksExecutor;
import com.ontotext.forest.impex.ImportRunnableTask;
import com.ontotext.forest.impex.ImportSettings;
import com.ontotext.forest.impex.ImportStatusService;
import com.ontotext.forest.impex.ImportTasksExecutor;
import com.ontotext.forest.impex.StringTasksExecutor;
import com.ontotext.forest.impex.URLTasksExecutor;
import com.ontotext.forest.impex.UserFileTasksExecutor;
import jakarta.inject.Named;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class RenamedRepoImpexListener
extends RepositoryIdChangedListener {
    @Autowired
    private SemanticDataManagement dataManagement;
    @Autowired
    private FileTasksExecutor fileImportExecutor;
    @Autowired
    private UserFileTasksExecutor fileUploadExecutor;
    @Autowired
    private URLTasksExecutor urlTasksExecutor;
    @Autowired
    private StringTasksExecutor stringTasksExecutor;

    protected void updateAfterChangedRepoId(String oldRepoId, String newRepoId) throws GraphDBWorkbenchException {
        this.updateImportSettings(this.fileImportExecutor.getStatusService(), oldRepoId, newRepoId);
        this.updateImportSettings(this.fileUploadExecutor.getStatusService(), oldRepoId, newRepoId);
        this.interruptTasks(this.fileImportExecutor, oldRepoId);
        this.interruptTasks(this.fileUploadExecutor, oldRepoId);
        this.interruptTasks(this.urlTasksExecutor, oldRepoId);
        this.interruptTasks(this.stringTasksExecutor, oldRepoId);
    }

    private void updateImportSettings(ImportStatusService importStatusService, String oldRepoId, String newRepoId) throws GraphDBWorkbenchException {
        for (ImportSettings importInfo : importStatusService.getAllForRepository(oldRepoId)) {
            importStatusService.clear(oldRepoId, importInfo.getName());
            importStatusService.save(newRepoId, importInfo);
        }
    }

    private void interruptTasks(ImportTasksExecutor<?> importTasksExecutor, String oldRepoId) {
        Map<String, Map<String, ImportRunnableTask>> tasks = importTasksExecutor.getTasks();
        if (tasks.containsKey(oldRepoId)) {
            tasks.get(oldRepoId).values().forEach(ImportRunnableTask::interrupt);
        }
    }
}

